/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.jinput11;

import com.spacekiller.game2d.InputAxis;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.Rumbler;
import com.spacekiller.game2d.input.AbstractInputAxis;
import com.spacekiller.game2d.input.AbstractInputButton;
import net.java.games.input.Axis;
import net.java.games.input.Mouse;

public class JInputMouseController
implements InputController {
    private Mouse mouse;
    private Mouse.Ball ball;
    private Axis ax;
    private Axis ay;
    private Axis aw;
    private Mouse.Buttons mb;
    private float x;
    private float y;
    private float w;
    private JInputMouseXAxis xAxis;
    private JInputMouseYAxis yAxis;
    private JInputMouseWheel wheel;
    private JInputMouseButton[] buttons;
    private InputAxis[] axes;

    public JInputMouseController(Mouse mouse) {
        this.initJInputMouseController(mouse);
    }

    protected void initJInputMouseController(Mouse mouse) {
        int c;
        System.out.println("Mouse-Controller: " + mouse);
        if (mouse == null) {
            return;
        }
        this.mouse = mouse;
        this.ball = mouse.getBall();
        this.ax = this.ball.getX();
        this.ay = this.ball.getY();
        this.aw = this.ball.getWheel();
        this.mb = mouse.getButtons();
        this.xAxis = new JInputMouseXAxis("x-axis");
        this.yAxis = new JInputMouseYAxis("y-axis");
        this.wheel = new JInputMouseWheel("wheel");
        Axis[] buttonAxes = this.mb.getAxes();
        int buttonCount = buttonAxes.length;
        System.out.println("Mouse-Buttons: " + buttonCount);
        this.buttons = new JInputMouseButton[buttonCount];
        for (c = 0; c < buttonCount; ++c) {
            this.buttons[c] = new JInputMouseButton("button" + (c + 1), buttonAxes[c]);
        }
        this.axes = new InputAxis[buttonCount + 3];
        this.axes[0] = this.xAxis;
        this.axes[1] = this.yAxis;
        this.axes[2] = this.wheel;
        for (c = 0; c < buttonCount; ++c) {
            this.axes[3 + c] = this.buttons[c];
        }
    }

    protected Mouse getMouse() {
        return this.mouse;
    }

    protected void setMouse(Mouse mouse) {
        this.mouse = mouse;
    }

    public InputAxis getAxisAt(int i) {
        return this.axes[i];
    }

    public int getAxisCount() {
        return this.axes.length;
    }

    public void poll() {
        if (this.ball.poll()) {
            this.x = this.ax.getPollData();
            this.y = this.ay.getPollData();
            this.w += this.aw.getPollData();
        }
        this.mb.poll();
    }

    public int getType() {
        return 2;
    }

    public InputAxis getAxisForKey(int keyCode) {
        return null;
    }

    public int getRumblerCount() {
        return 0;
    }

    public Rumbler getRumblerAt(int i) {
        return null;
    }

    public String toString() {
        return this.mouse.getName();
    }

    protected class JInputMouseButton
    extends AbstractInputButton {
        private Axis axis;

        public JInputMouseButton(String name, Axis axis) {
            super((InputController)JInputMouseController.this, name, 1000, -1);
            this.axis = axis;
        }

        public boolean isPressed() {
            return this.axis.getPollData() != 0.0f;
        }

        public float getValue() {
            return this.axis.getPollData();
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class JInputMouseWheel
    extends AbstractInputAxis {
        public JInputMouseWheel(String name) {
            super((InputController)JInputMouseController.this, name, 2020);
        }

        public float getValue() {
            return JInputMouseController.this.w;
        }

        public boolean isAnalog() {
            return true;
        }

        public boolean isNormalized() {
            return false;
        }

        public boolean isRelative() {
            return false;
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class JInputMouseYAxis
    extends AbstractInputAxis {
        public JInputMouseYAxis(String name) {
            super((InputController)JInputMouseController.this, name, 2001);
        }

        public float getValue() {
            return JInputMouseController.this.y;
        }

        public boolean isAnalog() {
            return true;
        }

        public boolean isNormalized() {
            return false;
        }

        public boolean isRelative() {
            return true;
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class JInputMouseXAxis
    extends AbstractInputAxis {
        public JInputMouseXAxis(String name) {
            super((InputController)JInputMouseController.this, name, 2000);
        }

        public float getValue() {
            return JInputMouseController.this.x;
        }

        public boolean isAnalog() {
            return true;
        }

        public boolean isNormalized() {
            return false;
        }

        public boolean isRelative() {
            return true;
        }

        public boolean isPolling() {
            return true;
        }
    }
}

