/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.jinput11;

import com.spacekiller.game2d.ext.jinput11.JInputManager;
import net.java.games.input.Axis;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Keyboard;
import net.java.games.input.Mouse;
import net.java.games.input.Rumbler;
import net.java.games.input.StandardKeyboard;

public class TestJInput {
    public static void main(String[] args) {
        try {
            JInputManager manager = JInputManager.getInstance();
            System.out.println("JInputManager: " + manager);
            ControllerEnvironment env = manager.getControllerEnvironment();
            new TestJInput().dumpControllerEnvironment(env);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void testMouseButtons(Mouse mouse) throws Exception {
        System.out.println("Mouse: " + mouse);
        Mouse.Buttons buttons = mouse.getButtons();
        System.out.println("Buttons: " + buttons);
        Axis[] buttonAxes = buttons.getAxes();
        System.out.println("Buttons-Axes: " + buttonAxes.length);
        for (int c = 0; c < buttonAxes.length; ++c) {
            Axis x = buttonAxes[c];
            System.out.println("Button #" + c + " = " + x + " => polling=" + x.isPolling());
        }
        System.out.println("Please press some mouse buttons...");
        long ms = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < ms) {
            if (!buttons.poll()) {
                System.out.println("OOPS, polling failed!");
            }
            for (int c = 0; c < buttonAxes.length; ++c) {
                Axis x = buttonAxes[c];
                float f = x.getPollData();
                if (f == 0.0f) continue;
                System.out.println("Pressed: " + x);
            }
            Thread.sleep(10L);
        }
        System.out.println("Test completed.");
    }

    public void testKeyboardButtons(Keyboard keyboard) throws Exception {
        System.out.println("Keyboard: " + keyboard);
        Axis[] axes = keyboard.getAxes();
        System.out.println("Axes: " + axes.length);
        for (int c = 0; c < axes.length; ++c) {
            Axis x = axes[c];
            System.out.println("Key #" + c + " = " + x + " => polling=" + x.isPolling());
        }
        System.out.println("Key[Z] = " + keyboard.getAxis((Axis.Identifier)StandardKeyboard.KeyID.Z));
        System.out.println("Key[Left-Ctrl] = " + keyboard.getAxis((Axis.Identifier)StandardKeyboard.KeyID.LCONTROL));
        System.out.println("Please press some keys...");
        long ms = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < ms) {
            if (!keyboard.poll()) {
                System.out.println("OOPS, polling failed!");
            }
            for (int c = 0; c < axes.length; ++c) {
                Axis x = axes[c];
                Keyboard.Key key = (Keyboard.Key)x;
                if (key.getPollData() == 0.0f) continue;
                System.out.println("Pressed: " + key);
            }
            Thread.sleep(10L);
        }
        System.out.println("Test completed.");
    }

    public void testJoystick(Controller stick) throws Exception {
        System.out.println("=====================================");
        System.out.println("Joystick: " + stick);
        Axis[] axes = stick.getAxes();
        float[] values = new float[axes.length];
        long ms = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < ms) {
            if (!stick.poll()) {
                System.out.println("OOPS, polling failed!");
            }
            for (int c = 0; c < axes.length; ++c) {
                Axis x = axes[c];
                float f = x.getPollData();
                if (f == values[c]) continue;
                values[c] = f;
                System.out.println("Axis: " + x + " => " + f);
            }
            Thread.sleep(10L);
        }
        System.out.println("Test completed.");
        System.out.println("Testing rumblers..");
        Rumbler[] rumblers = stick.getRumblers();
        System.out.println("Rumblers: " + rumblers.length);
        for (int c = 0; c < rumblers.length; ++c) {
            System.out.println("Testing rumbler: " + rumblers[c]);
            this.testRumbler(rumblers[c]);
        }
    }

    public void testRumbler(Rumbler rumbler) throws Exception {
        System.out.println("=====================================");
        System.out.println("Rumbler: " + rumbler);
        System.out.println("Start rumble..");
        rumbler.rumble(1.0f);
        Thread.sleep(2000L);
        System.out.println("Stop rumble..");
        rumbler.rumble(0.0f);
        Thread.sleep(2000L);
    }

    protected void dumpControllerEnvironment(ControllerEnvironment env) {
        Controller[] ctrl = env.getControllers();
        System.out.println("JInput controllers: " + ctrl.length);
        for (int c = 0; c < ctrl.length; ++c) {
            System.out.println("=====================================");
            Controller controller = ctrl[c];
            this.dumpController(controller);
        }
    }

    protected void dumpController(Controller ctrl) {
        System.out.println("Controller: " + ctrl);
        System.out.println("Type: " + ctrl.getType());
        System.out.println("Name: " + ctrl.getName());
        Axis[] axes = ctrl.getAxes();
        int numAxes = axes == null ? 0 : axes.length;
        System.out.println("Axes: " + numAxes);
        for (int c = 0; c < numAxes; ++c) {
            System.out.print(" - Axis #" + c + " => " + axes[c] + " => ");
            if (axes[c].isAnalog()) {
                System.out.print("Analog ");
            }
            if (axes[c].isNormalized()) {
                System.out.print("Normalized ");
            }
            if (axes[c].isPolling()) {
                System.out.print("Polling ");
            }
            if (axes[c].isRelative()) {
                System.out.print("Relative ");
            }
            System.out.println();
        }
        Rumbler[] rumblers = ctrl.getRumblers();
        int numRumblers = rumblers == null ? 0 : rumblers.length;
        System.out.println("Rumblers: " + numRumblers);
        for (int c = 0; c < numRumblers; ++c) {
            System.out.println(" - Rumbler #" + c + " => " + rumblers[c]);
        }
        Controller[] subs = ctrl.getControllers();
        int numSubs = subs == null ? 0 : subs.length;
        System.out.println("Sub-Controllers: " + numSubs);
        for (int c = 0; c < numSubs; ++c) {
            System.out.println(" - Sub-Controller #" + c + " => " + subs[c]);
        }
    }
}

