/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.member;

import com.spacekiller.util.buffer.Base64Util;
import com.spacekiller.util.member.AbstractMember;
import com.spacekiller.util.member.DefaultGroup;
import com.spacekiller.util.member.DefaultUser;
import com.spacekiller.util.member.Group;
import com.spacekiller.util.member.Member;
import com.spacekiller.util.member.User;
import com.spacekiller.util.member.UserRegistry;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class AbstractUserRegistry
implements UserRegistry {
    private Map members = new HashMap();
    private Map credentials = new HashMap();

    @Override
    public Member getMember(String name) throws Exception {
        return (Member)this.members.get(name);
    }

    @Override
    public User getUser(String name) throws Exception {
        return (User)this.getMember(name);
    }

    @Override
    public Group getGroup(String name) throws Exception {
        return (Group)this.getMember(name);
    }

    public Iterator getMembers() throws Exception {
        return this.members.values().iterator();
    }

    protected int getMemberId(Member m) throws Exception {
        return ((AbstractMember)m).getId();
    }

    @Override
    public Group[] getGroupsFor(Member member, boolean recursive) throws Exception {
        HashSet groups = new HashSet();
        this.getGroupsFor(member, recursive, groups);
        Group[] rc = new Group[groups.size()];
        rc = groups.toArray(rc);
        return rc;
    }

    protected void getGroupsFor(Member member, boolean recursive, Set dstGroups) {
        AbstractMember m = (AbstractMember)member;
        Iterator i = m.getGroups();
        while (i.hasNext()) {
            Group g = (Group)i.next();
            if (!dstGroups.add(g) || !recursive) continue;
            this.getGroupsFor(g, true, dstGroups);
        }
    }

    @Override
    public Member[] getGroupMembers(Group group, boolean recursive) throws Exception {
        HashSet set = new HashSet();
        this.getGroupMembers(group, recursive, set);
        Member[] rc = new Member[set.size()];
        rc = set.toArray(rc);
        return rc;
    }

    protected void getGroupMembers(Group group, boolean recursive, Set dstMembers) throws Exception {
        DefaultGroup g = (DefaultGroup)group;
        Iterator i = g.getMembers();
        while (i.hasNext()) {
            Member m = (Member)i.next();
            if (!dstMembers.add(m) || !recursive || !(m instanceof Group)) continue;
            this.getGroupMembers((Group)m, true, dstMembers);
        }
    }

    @Override
    public boolean isGroupMember(Group group, Member member) throws Exception {
        HashSet loop = new HashSet();
        return this.isGroupMember(group, member, loop);
    }

    protected boolean isGroupMember(Group group, Member member, Set loop) throws Exception {
        DefaultGroup g = (DefaultGroup)group;
        Iterator i = g.getMembers();
        while (i.hasNext()) {
            Member m = (Member)i.next();
            if (!loop.add(m)) continue;
            if (m == member) {
                return true;
            }
            if (!(m instanceof Group) || !this.isGroupMember((Group)m, member, loop)) continue;
            return true;
        }
        return false;
    }

    protected synchronized void addMember(Member member) throws Exception {
        String name = member.getName();
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.members.containsKey(name)) {
            throw new Exception("Member already exists: " + name);
        }
        this.members.put(name, member);
        this.memberAdded(member);
    }

    protected synchronized void removeMember(Member member) throws Exception {
        String name = member.getName();
        if (name == null) {
            return;
        }
        Object test = this.members.get(name);
        if (test == member) {
            this.members.remove(name);
        }
        this.memberRemoved(member);
    }

    public synchronized void setCredentials(User user, Properties properties) throws Exception {
        if (!this.isMember(user)) {
            throw new Exception("The specified user is not a member: " + user);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)properties);
        Properties cred = this.encryptCredentials(props);
        this.credentials.put(user, cred);
        this.credentialsChanged(user);
    }

    protected void loadCredentials(User user, Properties cred) throws Exception {
        this.credentials.put(user, cred);
    }

    protected Properties getCredentials(User user) throws Exception {
        return (Properties)this.credentials.get(user);
    }

    @Override
    public synchronized User authenticate(Properties properties) throws Exception {
        String userName = properties.getProperty("user");
        Member member = this.getMember(userName);
        if (member != null && member instanceof User) {
            User user = (User)member;
            if (user.isRevoked()) {
                throw new SecurityException("User account is revoked: " + userName);
            }
            Properties cred = this.getCredentials(user);
            if (cred != null) {
                if (this.checkCredentials(cred, properties)) {
                    return user;
                }
                throw new SecurityException("Authentication failed for user: " + userName);
            }
        }
        throw new SecurityException("Authentication failed for user: " + userName);
    }

    protected boolean checkCredentials(Properties cred, Properties cred2) throws Exception {
        String user1 = cred.getProperty("user");
        if (user1 != null) {
            String user2 = cred2.getProperty("user");
            if (user2 == null) {
                return false;
            }
            if (!user1.equals(user2)) {
                return false;
            }
            String pass1 = cred.getProperty("pass");
            if (pass1 == null) {
                return false;
            }
            String plain = cred2.getProperty("pass");
            if (plain == null) {
                return false;
            }
            String pass2 = this.encryptPassword(plain);
            return pass1.equals(pass2);
        }
        return false;
    }

    protected String encryptPassword(String plain) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(plain.getBytes("UTF-8"));
        byte[] raw = md.digest();
        String hash = Base64Util.getEncoder().encodeToString(raw);
        return hash;
    }

    protected Properties encryptCredentials(Properties props) throws Exception {
        Properties rc = new Properties();
        String user = props.getProperty("user");
        if (user == null) {
            throw new Exception("Missing property: user");
        }
        rc.put("user", user);
        String plain = props.getProperty("pass");
        if (plain == null) {
            throw new Exception("Missing property: pass");
        }
        String pass = this.encryptPassword(plain);
        rc.put("pass", pass);
        return rc;
    }

    protected boolean validatePassword(String password) {
        return true;
    }

    @Override
    public boolean isMember(Member member) throws Exception {
        if (member == null) {
            return false;
        }
        String name = member.getName();
        if (name == null) {
            return false;
        }
        Object test = this.members.get(name);
        return test == member;
    }

    public synchronized void addGroupMember(Group g, Member m) throws Exception {
        DefaultGroup group = (DefaultGroup)g;
        if (!this.isMember(group)) {
            throw new Exception("Unknown group: " + g);
        }
        AbstractMember member = (AbstractMember)m;
        if (!this.isMember(member)) {
            throw new Exception("Unknown member: " + member);
        }
        group.addMember(member);
        this.groupMemberAdded(g, m);
    }

    public synchronized void removeGroupMember(Group g, Member m) throws Exception {
        DefaultGroup group = (DefaultGroup)g;
        if (!this.isMember(group)) {
            throw new Exception("Unknown group: " + g);
        }
        AbstractMember member = (AbstractMember)m;
        group.removeMember(member);
        this.groupMemberRemoved(g, m);
    }

    public synchronized void setMemberName(Member member, String name) throws Exception {
        AbstractMember m = (AbstractMember)member;
        String oldName = m.getName();
        Member old = this.getMember(oldName);
        if (old != member) {
            throw new Exception("Invalid member: " + member);
        }
        if (this.members.containsKey(name)) {
            throw new Exception("Member already exists: " + name);
        }
        this.members.remove(oldName);
        m.setName(name);
        this.members.put(name, m);
        this.memberChanged(m);
    }

    public synchronized User createUser(String name, String descr, String email, boolean revoked) throws Exception {
        int id = this.generateMemberId();
        DefaultUser user = new DefaultUser(id, name);
        user.setDescription(descr);
        user.setEmail(email);
        user.setRevoked(revoked);
        this.addMember(user);
        return user;
    }

    public synchronized Group createGroup(String name, String descr) throws Exception {
        int id = this.generateMemberId();
        DefaultGroup group = new DefaultGroup(id, name);
        group.setDescription(descr);
        this.addMember(group);
        return group;
    }

    public synchronized void removeUser(User user) throws Exception {
        this.removeMember(user);
    }

    public synchronized void removeGroup(Group group) throws Exception {
        this.removeMember(group);
    }

    protected synchronized int generateMemberId() throws Exception {
        int id;
        boolean ok;
        block0: do {
            id = (int)(Math.random() * 2.147483647E9) + 1;
            ok = true;
            for (Member m : this.members.values()) {
                int x = this.getMemberId(m);
                if (x != id) continue;
                ok = false;
                continue block0;
            }
        } while (!ok);
        return id;
    }

    public synchronized void setMemberDescription(Member member, String descr) throws Exception {
        ((AbstractMember)member).setDescription(descr);
        this.memberChanged(member);
    }

    public synchronized void setUserEmail(User user, String email) throws Exception {
        ((DefaultUser)user).setEmail(email);
        this.memberChanged(user);
    }

    public synchronized void setUserRevoked(User user, boolean revoke) throws Exception {
        ((DefaultUser)user).setRevoked(revoke);
        this.memberChanged(user);
    }

    protected abstract void memberAdded(Member var1) throws Exception;

    protected abstract void memberChanged(Member var1) throws Exception;

    protected abstract void memberRemoved(Member var1) throws Exception;

    protected abstract void groupMemberAdded(Group var1, Member var2) throws Exception;

    protected abstract void groupMemberRemoved(Group var1, Member var2) throws Exception;

    protected abstract void credentialsChanged(User var1) throws Exception;
}

