/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.member;

import com.spacekiller.util.Data;
import com.spacekiller.util.member.AbstractMember;
import com.spacekiller.util.member.AbstractUserRegistry;
import com.spacekiller.util.member.DefaultGroup;
import com.spacekiller.util.member.DefaultUser;
import com.spacekiller.util.member.Group;
import com.spacekiller.util.member.Member;
import com.spacekiller.util.member.User;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class FileUserRegistry
extends AbstractUserRegistry {
    public static final int UREG_FORMAT_MAGIC = 2122549511;
    public static final int UREG_END_TAG = -1871240193;
    public static final int UREG_VERSION = 0;
    public static final String PROPERTY_USER_REGISTRY_FILE = "user.registry.file";
    public static final String DEFAULT_USER_REGISTRY_FILENAME = "mm.members";
    private boolean initialized = false;
    private File registryFile;
    private boolean ignoreSave = false;
    private static final Logger logger = Logger.getLogger(FileUserRegistry.class.getName());

    public FileUserRegistry() throws Exception {
        this.initialized = false;
    }

    public FileUserRegistry(File file) throws Exception {
        this.initialize(file);
    }

    protected File getRegistryFile() {
        return this.registryFile;
    }

    protected void setRegistryFile(File registryFile) {
        this.registryFile = registryFile;
    }

    @Override
    protected void memberAdded(Member member) throws Exception {
        if (!this.ignoreSave) {
            this.saveFileUserRegistry();
        }
    }

    @Override
    protected void memberChanged(Member member) throws Exception {
        if (!this.ignoreSave) {
            this.saveFileUserRegistry();
        }
    }

    @Override
    protected void memberRemoved(Member member) throws Exception {
        if (!this.ignoreSave) {
            this.saveFileUserRegistry();
        }
    }

    @Override
    protected void groupMemberAdded(Group group, Member member) throws Exception {
        if (!this.ignoreSave) {
            this.saveFileUserRegistry();
        }
    }

    @Override
    protected void groupMemberRemoved(Group group, Member member) throws Exception {
        if (!this.ignoreSave) {
            this.saveFileUserRegistry();
        }
    }

    @Override
    protected void credentialsChanged(User user) throws Exception {
        if (!this.ignoreSave) {
            this.saveFileUserRegistry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void saveFileUserRegistry() throws Exception {
        FileOutputStream fout = new FileOutputStream(this.registryFile);
        DataOutputStream dout = new DataOutputStream(fout);
        try {
            this.writeFileUserRegistry(dout);
        }
        finally {
            dout.close();
            fout.close();
        }
    }

    protected void writeFileUserRegistry(DataOutput dout) throws Exception {
        dout.writeInt(2122549511);
        dout.writeInt(0);
        ArrayList<Member> groups = new ArrayList<Member>();
        ArrayList<Member> users = new ArrayList<Member>();
        Iterator i = this.getMembers();
        while (i.hasNext()) {
            Member member = (Member)i.next();
            if (member instanceof User) {
                users.add(member);
                continue;
            }
            if (member instanceof Group) {
                groups.add(member);
                continue;
            }
            throw new Exception("Unknown member type: " + member);
        }
        int numUsers = users.size();
        dout.writeInt(numUsers);
        for (int c = 0; c < numUsers; ++c) {
            User user = (User)users.get(c);
            dout.writeInt(this.getMemberId(user));
            dout.writeUTF(user.getName());
            dout.writeLong(user.getCreatedMillis());
            dout.writeUTF(user.getDescription());
            dout.writeUTF(user.getEmail());
            dout.writeBoolean(user.isRevoked());
            Properties cred = this.getCredentials(user);
            Properties copy = new Properties();
            if (cred != null) {
                copy.putAll((Map<?, ?>)cred);
            }
            this.writeCredentials(copy, dout);
        }
        int numGroups = groups.size();
        dout.writeInt(numGroups);
        for (int c = 0; c < numGroups; ++c) {
            Group group = (Group)groups.get(c);
            dout.writeInt(this.getMemberId(group));
            dout.writeUTF(group.getName());
            dout.writeLong(group.getCreatedMillis());
            dout.writeUTF(group.getDescription());
            Member[] groupMembers = this.getGroupMembers(group, false);
            int n = groupMembers == null ? 0 : groupMembers.length;
            dout.writeInt(n);
            for (int x = 0; x < n; ++x) {
                int mid = this.getMemberId(groupMembers[x]);
                dout.writeInt(mid);
            }
        }
        dout.writeInt(-1871240193);
    }

    protected void writeCredentials(Properties cred, DataOutput out) throws Exception {
        int num = cred.size();
        out.writeInt(num);
        for (Map.Entry<Object, Object> entry : cred.entrySet()) {
            out.writeUTF(String.valueOf(entry.getKey()));
            out.writeUTF(String.valueOf(entry.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadFileUserRegistry() throws Exception {
        FileInputStream fin = new FileInputStream(this.registryFile);
        DataInputStream din = new DataInputStream(fin);
        try {
            this.readFileUserRegistry(din);
        }
        finally {
            din.close();
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void readFileUserRegistry(DataInput din) throws Exception {
        int c;
        int magic = din.readInt();
        if (magic != 2122549511) {
            throw new StreamCorruptedException("Invalid user registry magic: " + magic + " != " + 2122549511);
        }
        int ver = din.readInt();
        if (ver != 0) {
            throw new StreamCorruptedException("Invalid user registry version: " + ver + " != " + 0);
        }
        int numUsers = din.readInt();
        HashMap<Integer, AbstractMember> memberMap = new HashMap<Integer, AbstractMember>();
        for (int c2 = 0; c2 < numUsers; ++c2) {
            int id = din.readInt();
            String name = din.readUTF();
            long created = din.readLong();
            String descr = din.readUTF();
            String email = din.readUTF();
            boolean revoked = din.readBoolean();
            Properties cred = this.readCredentials(din);
            DefaultUser user = new DefaultUser(id, name);
            user.setCreatedMillis(created);
            user.setDescription(descr);
            user.setEmail(email);
            user.setRevoked(revoked);
            try {
                this.ignoreSave = true;
                this.addMember(user);
                memberMap.put(Data.toInteger((int)id), user);
                this.loadCredentials(user, cred);
                continue;
            }
            finally {
                this.ignoreSave = false;
            }
        }
        int numGroups = din.readInt();
        ArrayList<DefaultGroup> theGroups = new ArrayList<DefaultGroup>();
        ArrayList<int[]> theGroupMemberIds = new ArrayList<int[]>();
        for (c = 0; c < numGroups; ++c) {
            int id = din.readInt();
            String name = din.readUTF();
            long created = din.readLong();
            String descr = din.readUTF();
            int numGroupMembers = din.readInt();
            int[] mids = new int[numGroupMembers];
            for (int x = 0; x < numGroupMembers; ++x) {
                mids[x] = din.readInt();
            }
            DefaultGroup group = new DefaultGroup(id, name);
            group.setCreatedMillis(created);
            group.setDescription(descr);
            try {
                this.ignoreSave = true;
                this.addMember(group);
                theGroups.add(group);
                theGroupMemberIds.add(mids);
                memberMap.put(Data.toInteger((int)id), group);
                continue;
            }
            finally {
                this.ignoreSave = false;
            }
        }
        for (c = 0; c < numGroups; ++c) {
            Group group = (Group)theGroups.get(c);
            int[] mids = (int[])theGroupMemberIds.get(c);
            for (int x = 0; x < mids.length; ++x) {
                int mid = mids[x];
                Member member = (Member)memberMap.get(Data.toInteger((int)mid));
                if (member == null) continue;
                try {
                    this.ignoreSave = true;
                    this.addGroupMember(group, member);
                    continue;
                }
                finally {
                    this.ignoreSave = false;
                }
            }
        }
        int endTag = din.readInt();
        if (endTag != -1871240193) {
            throw new StreamCorruptedException("Invalid user registry end tag: " + endTag + " != " + -1871240193);
        }
    }

    protected Properties readCredentials(DataInput in) throws Exception {
        Properties cred = new Properties();
        int num = in.readInt();
        for (int c = 0; c < num; ++c) {
            String key = in.readUTF();
            String value = in.readUTF();
            cred.put(key, value);
        }
        return cred;
    }

    @Override
    public void initialize(Properties config) throws Exception {
        String registryFilePath = config.getProperty(PROPERTY_USER_REGISTRY_FILE);
        if (registryFilePath == null) {
            File f = new File(DEFAULT_USER_REGISTRY_FILENAME);
            registryFilePath = f.getAbsolutePath();
        }
        File file = new File(registryFilePath);
        file = file.getAbsoluteFile();
        this.initialize(file);
    }

    protected void initialize(File file) throws Exception {
        if (this.initialized) {
            throw new Exception("User registry already initialized: " + this);
        }
        logger.fine("User registry file: " + file);
        this.setRegistryFile(file);
        this.initialized = true;
        if (file.exists()) {
            this.loadFileUserRegistry();
        } else {
            logger.fine("Creating system user-registry: " + file);
            String userName = System.getProperty("user.name");
            logger.fine("Registering default user: " + userName);
            User user1 = this.createUser(userName, "", "", false);
            Properties cred1 = new Properties();
            cred1.setProperty("user", userName);
            cred1.setProperty("pass", "");
            this.setCredentials(user1, cred1);
        }
    }
}

