/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.crypto;

import com.spacekiller.util.crypto.CipherStub;
import com.spacekiller.util.crypto.CipherStubPbeMd5Des;
import com.spacekiller.util.crypto.CipherStubPbeMd5TripleDes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CipherTest {
    private static final Logger logger = Logger.getLogger(CipherTest.class.getName());

    public static void main(String[] args) {
        try {
            logger.fine("Running CipherTest..");
            char[] key = "secretpassword".toCharArray();
            byte[] data = new byte[6789];
            for (int c = 0; c < data.length; ++c) {
                data[c] = (byte)(Math.random() * 255.0);
            }
            logger.fine("Source: " + data.length);
            CipherTest test = new CipherTest();
            byte[] enc1 = test.encrypt(new CipherStubPbeMd5Des(), data, key);
            byte[] dec1 = test.decrypt(new CipherStubPbeMd5Des(), enc1, key);
            test.compare(data, dec1);
            byte[] enc2 = test.encrypt(new CipherStubPbeMd5TripleDes(), data, key);
            byte[] dec2 = test.decrypt(new CipherStubPbeMd5TripleDes(), enc2, key);
            test.compare(data, dec2);
            byte[] dec3 = test.decrypt(new CipherStubPbeMd5Des(), enc2, key);
            test.compare(data, dec3);
            throw new Exception("OOPS!!! NOT TripleDES !!!!!");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            System.exit(0);
            return;
        }
    }

    public byte[] encrypt(CipherStub cipher, byte[] data, char[] key) throws Exception {
        logger.fine("Testing Cipher: " + cipher);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStream cout = cipher.getCipherOutputStream(bout, key);
        cout.write(data);
        cout.flush();
        cout.close();
        bout.flush();
        byte[] encrypted = bout.toByteArray();
        logger.fine("Encrypted: " + encrypted.length);
        return encrypted;
    }

    public byte[] decrypt(CipherStub cipher, byte[] encrypted, char[] key) throws Exception {
        int num;
        ByteArrayInputStream bin = new ByteArrayInputStream(encrypted);
        InputStream cin = cipher.getCipherInputStream(bin, key);
        ByteArrayOutputStream dout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((num = cin.read(buf, 0, buf.length)) >= 0) {
            dout.write(buf, 0, num);
        }
        dout.flush();
        byte[] decrypted = dout.toByteArray();
        logger.fine("Number of bytes decrypted: " + decrypted.length);
        cin.close();
        bin.close();
        return decrypted;
    }

    public void compare(byte[] data, byte[] decrypted) throws Exception {
        if (data.length != decrypted.length) {
            throw new Exception("Invalid bytes decrypted: " + decrypted.length + " != " + data.length);
        }
        int errors = 0;
        for (int c = 0; c < data.length; ++c) {
            if (data[c] == decrypted[c]) continue;
            ++errors;
        }
        if (errors != 0) {
            throw new Exception("Decryption failed: " + errors + " invalid bytes.");
        }
        logger.fine("Decryption was successful.");
    }
}

