/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Clock;
import com.spacekiller.util.ConfigInjector;
import com.spacekiller.util.ConfigNode;
import com.spacekiller.util.DefaultPlugin;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.FileListener;
import com.spacekiller.util.FileManager;
import com.spacekiller.util.FileTypeRegistry;
import com.spacekiller.util.Injection;
import com.spacekiller.util.InjectionFactory;
import com.spacekiller.util.PlatformBase;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.PluginDescriptor;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.DefaultBeansToolkit;
import com.spacekiller.util.platform.DefaultExecutionManager;
import com.spacekiller.util.platform.DefaultFileManager;
import com.spacekiller.util.platform.DefaultFileTypeRegistry;
import com.spacekiller.util.platform.DefaultInjectionFactory;
import com.spacekiller.util.platform.DefaultPreferencesRegistry;
import com.spacekiller.util.platform.DefaultThreadManager;
import com.spacekiller.util.platform.PluginInjection;
import com.spacekiller.util.platform.PluginLoader;
import com.spacekiller.util.platform.RuntimeExtension;
import com.spacekiller.util.platform.RuntimeExtensionPoint;
import com.spacekiller.util.platform.RuntimePluginDescriptor;
import com.spacekiller.util.platform.SupportClock;
import com.spacekiller.util.platform.SupportPluginLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPlatform
extends PlatformBase {
    private static final Logger logger = Logger.getLogger(AbstractPlatform.class.getName());
    public static final String DEFAULT_PREFERENCES_REGISTRY_FILENAME = "preferences.properties";
    private File homeDir;
    private File dataDir;
    private File configDir;
    private File logDir;
    private File tempDir;
    private Map mapPluginDescr = new HashMap();
    private Map mapPlugins = new HashMap();
    private Map mapExtensionPoints = new HashMap();
    private Map mapExtensions = new HashMap();
    private ClassLoader platformClassLoader;
    private InjectionFactory injectionFactory;
    private PluginLoader pluginLoader;
    private List postStartupHooks = new ArrayList();
    private List shutdownHooks = new ArrayList();
    private boolean shutdownInProgress;
    private Clock clock;
    private Timer timer;
    private ExecutionManager executionManager;
    private ThreadManager threadManager;
    private BeansToolkit beansToolkit;
    private FileTypeRegistry fileTypeRegistry;
    private FileListener fileListener;
    private FileManager fileManager;
    private PreferencesRegistry preferencesRegistry;

    public AbstractPlatform() {
        DefaultInjectionFactory infectionInjectionFactory = new DefaultInjectionFactory();
        this.injectionFactory = infectionInjectionFactory;
    }

    protected final ClassLoader getPlatformClassLoader() {
        return this.platformClassLoader;
    }

    protected void setPlatformClassLoader(ClassLoader platformClassLoader) {
        this.platformClassLoader = platformClassLoader;
    }

    static final Iterator lookupServicesImpl(Class type, Iterator serviceIter) {
        LinkedList serviceList = new LinkedList();
        while (serviceIter.hasNext()) {
            Object service;
            try {
                service = serviceIter.next();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            if (service == null) continue;
            if (!type.isInstance(service)) {
                String msg = "Invalid Service: " + service;
                logger.log(Level.SEVERE, msg);
                continue;
            }
            serviceList.add(service);
        }
        int serviceCount = serviceList.size();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("lookupServices: type=" + type + ", count=" + serviceCount);
        }
        return serviceList.iterator();
    }

    protected Iterator lookupServices(Class type, Iterator serviceIter) {
        return AbstractPlatform.lookupServicesImpl(type, serviceIter);
    }

    public Iterator getServices(Class type) throws Exception {
        PluginLoader pluginLoader = this.getPluginLoader();
        Iterator pluginIter = pluginLoader.load(type);
        Iterator serviceIter = this.lookupServices(type, pluginIter);
        return serviceIter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PluginLoader getPluginLoader() {
        PluginLoader pluginLoader = this.pluginLoader;
        if (pluginLoader == null) {
            AbstractPlatform abstractPlatform = this;
            synchronized (abstractPlatform) {
                pluginLoader = this.pluginLoader;
                if (pluginLoader == null) {
                    pluginLoader = this.createPluginLoader();
                    this.setPluginLoader(pluginLoader);
                }
            }
        }
        return pluginLoader;
    }

    protected synchronized void setPluginLoader(PluginLoader pluginLoader) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setPluginLoader: " + pluginLoader);
        }
        this.pluginLoader = pluginLoader;
    }

    protected PluginLoader createPluginLoader() {
        ClassLoader[] loaders = new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()};
        return this.createPluginLoader(loaders);
    }

    protected PluginLoader createPluginLoader(ClassLoader[] loaders) {
        return SupportPluginLoader.createPluginLoader(loaders);
    }

    protected Object getExtensionInstance(String extensionId) throws Exception {
        RuntimeExtension ext = this.getExtension(extensionId);
        if (ext == null) {
            throw new RuntimeException("Extension not found: id=" + extensionId);
        }
        return this.getExtensionInstance(ext);
    }

    public InjectionFactory getInjectionFactory() {
        return this.injectionFactory;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    protected synchronized void setHomeDir(File homeDir) {
        this.homeDir = homeDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    protected synchronized void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    protected synchronized void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    public File getLogDir() {
        return this.logDir;
    }

    protected synchronized void setLogDir(File logDir) {
        this.logDir = logDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    protected synchronized void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clock getClock() {
        Clock clock = this.clock;
        if (clock == null) {
            AbstractPlatform abstractPlatform = this;
            synchronized (abstractPlatform) {
                clock = this.clock;
                if (clock == null) {
                    clock = this.createClock();
                    this.setClock(clock);
                }
            }
        }
        return clock;
    }

    protected synchronized void setClock(Clock clock) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setClock: " + clock);
        }
        this.clock = clock;
    }

    protected Clock createClock() {
        return SupportClock.createClock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getTimer() {
        Timer timer = this.timer;
        if (timer == null) {
            AbstractPlatform abstractPlatform = this;
            synchronized (abstractPlatform) {
                timer = this.timer;
                if (timer == null) {
                    timer = this.createTimer();
                    this.setTimer(timer);
                }
            }
        }
        return timer;
    }

    protected synchronized void setTimer(Timer timer) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setTimer: " + timer);
        }
        this.timer = timer;
    }

    protected Timer createTimer() {
        return new Timer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionManager getExecutionManager() {
        ExecutionManager executionManager = this.executionManager;
        if (executionManager == null) {
            AbstractPlatform abstractPlatform = this;
            synchronized (abstractPlatform) {
                executionManager = this.executionManager;
                if (executionManager == null) {
                    executionManager = this.createExecutionManager();
                    this.setExecutionManager(executionManager);
                }
            }
        }
        return executionManager;
    }

    protected synchronized void setExecutionManager(ExecutionManager executionManager) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setExecutionManager: " + executionManager);
        }
        this.executionManager = executionManager;
    }

    protected ExecutionManager createExecutionManager() {
        return new DefaultExecutionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadManager getThreadManager() {
        ThreadManager threadManager = this.threadManager;
        if (threadManager == null) {
            AbstractPlatform abstractPlatform = this;
            synchronized (abstractPlatform) {
                threadManager = this.threadManager;
                if (threadManager == null) {
                    threadManager = this.createThreadManager();
                    this.setThreadManager(threadManager);
                }
            }
        }
        return threadManager;
    }

    protected synchronized void setThreadManager(ThreadManager threadManager) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setThreadManager: " + threadManager);
        }
        this.threadManager = threadManager;
    }

    protected ThreadManager createThreadManager() {
        return new DefaultThreadManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeansToolkit getBeansToolkit() {
        BeansToolkit beansToolkit = this.beansToolkit;
        if (beansToolkit == null) {
            AbstractPlatform abstractPlatform = this;
            synchronized (abstractPlatform) {
                beansToolkit = this.beansToolkit;
                if (beansToolkit == null) {
                    beansToolkit = this.createBeansToolkit();
                    this.setBeansToolkit(beansToolkit);
                }
            }
        }
        return beansToolkit;
    }

    protected synchronized void setBeansToolkit(BeansToolkit beansToolkit) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setBeansToolkit: " + beansToolkit);
        }
        this.beansToolkit = beansToolkit;
    }

    protected BeansToolkit createBeansToolkit() {
        ClassRegistry classRegistry = this.getClassRegistry();
        return new DefaultBeansToolkit(classRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileTypeRegistry getFileTypeRegistry() {
        FileTypeRegistry fileTypeRegistry = this.fileTypeRegistry;
        if (fileTypeRegistry == null) {
            AbstractPlatform abstractPlatform = this;
            synchronized (abstractPlatform) {
                fileTypeRegistry = this.fileTypeRegistry;
                if (fileTypeRegistry == null) {
                    fileTypeRegistry = this.createFileTypeRegistry();
                    this.setFileTypeRegistry(fileTypeRegistry);
                }
            }
        }
        return fileTypeRegistry;
    }

    protected synchronized void setFileTypeRegistry(FileTypeRegistry fileTypeRegistry) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setFileTypeRegistry: " + fileTypeRegistry);
        }
        this.fileTypeRegistry = fileTypeRegistry;
    }

    protected FileTypeRegistry createFileTypeRegistry() {
        return new DefaultFileTypeRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileListener getFileListener() {
        FileListener fileListener = this.fileListener;
        if (fileListener == null) {
            AbstractPlatform abstractPlatform = this;
            synchronized (abstractPlatform) {
                fileListener = this.fileListener;
                if (fileListener == null) {
                    fileListener = this.createFileListener();
                    this.setFileListener(fileListener);
                }
            }
        }
        return fileListener;
    }

    protected synchronized void setFileListener(FileListener fileListener) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setFileListener: " + fileListener);
        }
        this.fileListener = fileListener;
    }

    protected FileListener createFileListener() {
        DefaultFileManager fileManager = (DefaultFileManager)this.getFileManager();
        return fileManager.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileManager getFileManager() {
        FileManager fileManager = this.fileManager;
        if (fileManager == null) {
            AbstractPlatform abstractPlatform = this;
            synchronized (abstractPlatform) {
                fileManager = this.fileManager;
                if (fileManager == null) {
                    fileManager = this.createFileManager();
                    this.setFileManager(fileManager);
                }
            }
        }
        return fileManager;
    }

    protected synchronized void setFileManager(FileManager fileManager) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setFileManager: " + fileManager);
        }
        this.fileManager = fileManager;
    }

    protected DefaultFileManager createFileManager() {
        return new DefaultFileManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreferencesRegistry getPreferencesRegistry() {
        PreferencesRegistry reg = this.preferencesRegistry;
        if (reg == null) {
            AbstractPlatform abstractPlatform = this;
            synchronized (abstractPlatform) {
                reg = this.preferencesRegistry;
                if (reg == null) {
                    reg = this.createPreferencesRegistry();
                    this.setPreferencesRegistry(reg);
                }
            }
        }
        return reg;
    }

    protected synchronized void setPreferencesRegistry(PreferencesRegistry preferencesRegistry) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setPreferencesRegistry: " + preferencesRegistry);
        }
        this.preferencesRegistry = preferencesRegistry;
    }

    protected PreferencesRegistry createPreferencesRegistry() {
        String fileName = DEFAULT_PREFERENCES_REGISTRY_FILENAME;
        File indexFile = new File(this.configDir, fileName);
        DefaultPreferencesRegistry reg = new DefaultPreferencesRegistry(indexFile);
        try {
            reg.initialize();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostStartupHook(Thread hook) {
        if (hook == null) {
            return;
        }
        List list = this.postStartupHooks;
        synchronized (list) {
            this.postStartupHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePostStartupHook(Thread hook) {
        List list = this.postStartupHooks;
        synchronized (list) {
            this.postStartupHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void postStartup() throws Exception {
        Thread[] hooks;
        List list = this.postStartupHooks;
        synchronized (list) {
            if (this.postStartupHooks.isEmpty()) {
                return;
            }
            hooks = this.postStartupHooks.toArray(new Thread[this.postStartupHooks.size()]);
            this.postStartupHooks.clear();
        }
        for (int i = 0; i < hooks.length; ++i) {
            try {
                hooks[i].start();
                continue;
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
    }

    protected abstract void handleException(Throwable var1);

    public synchronized void addShutdownHook(Thread hook) {
        if (this.shutdownHooks == null) {
            return;
        }
        if (hook != null) {
            this.shutdownHooks.add(hook);
        }
    }

    public synchronized void removeShutdownHook(Thread hook) {
        if (this.shutdownHooks == null) {
            return;
        }
        this.shutdownHooks.remove(hook);
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    protected synchronized void setShutdownInProgress(boolean shutdownInProgress) {
        this.shutdownInProgress = shutdownInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        List shutdownHooks;
        Timer timer = this.timer;
        if (timer != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Stopping platform timer...");
            }
            timer.cancel();
            this.timer = null;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Platform timer stopped.");
            }
        }
        AbstractPlatform abstractPlatform = this;
        synchronized (abstractPlatform) {
            shutdownHooks = this.shutdownHooks;
            this.shutdownHooks = null;
        }
        if (shutdownHooks == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Running shutdown hooks...");
        }
        for (Thread t : shutdownHooks) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(" - running: " + t);
            }
            t.start();
        }
        for (Thread t : shutdownHooks) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(" - waiting... " + t);
            }
            t.join();
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer(" - completed: " + t);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Shutdown hooks completed.");
        }
        ArrayList<RuntimePluginDescriptor> activePluginDescr = new ArrayList<RuntimePluginDescriptor>();
        for (RuntimePluginDescriptor descr : this.mapPluginDescr.values()) {
            if (!descr.isPluginStarted()) continue;
            activePluginDescr.add(descr);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Shutdown plugins: " + activePluginDescr.size());
        }
        for (RuntimePluginDescriptor descr : activePluginDescr) {
            String pluginId = descr.getId();
            Plugin plugin = this.getPlugin(pluginId, false);
            if (plugin == null) continue;
            this.shutdownPlugin(plugin);
        }
    }

    public String[] getPluginIds() throws Exception {
        Set ids = this.mapPluginDescr.keySet();
        return ids.toArray(new String[ids.size()]);
    }

    public final Plugin getPlugin(String pluginId) throws Exception {
        return this.getPlugin(pluginId, true);
    }

    protected Plugin getPlugin(String pluginId, boolean initialize) throws Exception {
        RuntimePluginDescriptor descr;
        Plugin plugin;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            // empty if block
        }
        if ((plugin = (Plugin)this.mapPlugins.get(pluginId)) == null && initialize && (descr = (RuntimePluginDescriptor)this.getPluginDescriptor(pluginId)) != null) {
            plugin = this.getPluginInternal(pluginId, descr);
        }
        return plugin;
    }

    protected synchronized Plugin getPluginInternal(String pluginId, RuntimePluginDescriptor descr) throws Exception {
        Plugin plugin = (Plugin)this.mapPlugins.get(pluginId);
        if (plugin != null) {
            return plugin;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Initializing plugin: " + pluginId);
        }
        boolean finer = logger.isLoggable(Level.FINER);
        try {
            int injectionResourceCount;
            plugin = this.createPlugin(descr);
            if (plugin == null) {
                return null;
            }
            ClassLoader pluginLoader = plugin.getClass().getClassLoader();
            if (finer) {
                logger.finer("Plugin ClassLoader: " + pluginLoader);
            }
            this.mapPlugins.put(pluginId, plugin);
            PluginInjection injection = null;
            String[] injectionResources = descr.getInjectionResources();
            int n = injectionResourceCount = injectionResources == null ? 0 : injectionResources.length;
            if (finer) {
                logger.finer("Loading plugin injection resources: " + injectionResourceCount);
            }
            for (int i = 0; i < injectionResourceCount; ++i) {
                URL configURL;
                String resource = injectionResources[i];
                if (finer) {
                    logger.finer("Loading injection resource: " + resource);
                }
                if ((configURL = pluginLoader.getResource(resource)) == null) {
                    throw new IOException("Injection configuration resource not found: " + resource);
                }
                injection = this.injectionFactory.createInjection(configURL, pluginLoader, (Injection)injection);
            }
            if (injection == null) {
                injection = new PluginInjection(new Injection[0]);
            }
            ConfigInjectorImpl injector = new ConfigInjectorImpl(pluginLoader, injection);
            this.initPlugin(plugin, descr, injector, injection);
            ExtensionPoint[] points = descr.getExtensionPoints();
            for (int c = 0; c < points.length; ++c) {
                Extension[] exts;
                RuntimeExtensionPoint point = (RuntimeExtensionPoint)points[c];
                if (finer) {
                    logger.finer("Loading extension point: " + point.getId());
                }
                if ((exts = point.getExtensions()) == null) continue;
                for (int x = 0; x < exts.length; ++x) {
                    Extension ext = exts[x];
                    if (ext == null) continue;
                    if (finer) {
                        logger.finer("Loading extension: " + ext.getId());
                    }
                    this.fireExtensionAvailable(plugin, point, ext);
                }
            }
            this.startupPlugin(plugin);
            descr.setPluginStarted(true);
            return plugin;
        }
        catch (Exception e) {
            throw new Exception("Error while loading plugin: " + pluginId, e);
        }
    }

    protected Plugin createPlugin(PluginDescriptor descr) throws Exception {
        String className = descr.getPluginClassName();
        Class clazz = null;
        if (className == null || className.length() < 1) {
            clazz = DefaultPlugin.class;
            className = clazz.getName();
        } else {
            ClassLoader classLoader = this.getPlatformClassLoader();
            clazz = classLoader.loadClass(className);
        }
        if (!Plugin.class.isAssignableFrom(clazz)) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("!! OOPS: Plugin class not compatible with interface: " + clazz);
            }
            Class superClass = clazz;
            do {
                Class sup;
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("!! OOPS: class " + superClass + " >> @" + System.identityHashCode(clazz));
                }
                if ((sup = clazz.getSuperclass()) == superClass) {
                    sup = null;
                }
                if ((superClass = sup) != Object.class) continue;
                superClass = null;
            } while (superClass != null);
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("!! OOPS: interface=" + System.identityHashCode(Plugin.class));
            }
            throw new Exception("Incompatible plugin class: " + clazz);
        }
        Plugin plugin = (Plugin)Tools.newInstance(clazz);
        this.debugReference(plugin);
        return plugin;
    }

    public PluginDescriptor getPluginDescriptor(String pluginId) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            // empty if block
        }
        return (PluginDescriptor)this.mapPluginDescr.get(pluginId);
    }

    public PluginDescriptor getPluginDescriptor(Plugin plugin) throws Exception {
        PluginDescriptor pd = super.getPluginDescriptor(plugin);
        if (pd == null) {
            return null;
        }
        String id = pd.getId();
        return this.getPluginDescriptor(id);
    }

    protected synchronized void registerPluginDescriptorInternal(String pluginId, RuntimePluginDescriptor descr) throws Exception {
        this.mapPluginDescr.put(pluginId, descr);
    }

    protected synchronized void registerExtensionPoint(PluginDescriptor descr, ExtensionPoint point) throws Exception {
        RuntimeExtensionPoint runtime = new RuntimeExtensionPoint((RuntimePluginDescriptor)descr, point);
        this.registerExtensionPointInternal((RuntimePluginDescriptor)descr, runtime);
    }

    protected synchronized void registerExtensionPointInternal(RuntimePluginDescriptor descr, RuntimeExtensionPoint point) throws Exception {
        String pid = point.getId();
        if (this.mapExtensionPoints.containsKey(pid)) {
            throw new RuntimeException("Extension point already exists: id=" + pid);
        }
        this.mapExtensionPoints.put(pid, point);
    }

    protected synchronized void unregisterExtensionPoint(PluginDescriptor descr, ExtensionPoint point) throws Exception {
        logger.fine("TODO: Platform.unregisterExtensionPoint: descr=" + descr + ", point=" + point);
    }

    protected synchronized void registerExtension(PluginDescriptor descr, Extension extension) throws Exception {
        String pid = extension.getExtensionPointId();
        RuntimeExtensionPoint point = this.getExtensionPoint(pid);
        if (point == null) {
            throw new RuntimeException("ExtensionPoint not found: point=" + pid + ", extension=" + extension);
        }
        ConfigNode config = extension.getConfigNode();
        RuntimeExtension runtime = new RuntimeExtension((RuntimePluginDescriptor)descr, extension, config, point);
        this.registerExtensionInternal((RuntimePluginDescriptor)descr, runtime);
    }

    protected synchronized void registerExtensionInternal(RuntimePluginDescriptor descr, RuntimeExtension extension) throws Exception {
        String pluginId;
        Plugin plugin;
        String xid = extension.getId();
        if (this.mapExtensions.containsKey(xid)) {
            throw new RuntimeException("Extension already exists: id=" + xid);
        }
        String pid = extension.getExtensionPointId();
        RuntimeExtensionPoint point = this.getExtensionPoint(pid);
        if (point == null) {
            throw new RuntimeException("ExtensionPoint not found: point=" + pid + ", extension=" + extension);
        }
        this.mapExtensions.put(xid, extension);
        point.addExtension(extension);
        RuntimePluginDescriptor pointPluginDescr = (RuntimePluginDescriptor)point.getDeclaringPluginDescriptor();
        if (pointPluginDescr != null && pointPluginDescr.isPluginStarted() && (plugin = this.getPlugin(pluginId = pointPluginDescr.getId(), false)) != null) {
            this.fireExtensionAvailable(plugin, point, extension);
        }
    }

    protected synchronized void unregisterExtension(PluginDescriptor descr, Extension extension) throws Exception {
        logger.fine("TODO: Platform.unregisterExtension: descr=" + descr + ", ext=" + extension);
    }

    protected RuntimeExtensionPoint getExtensionPoint(String pid) {
        return (RuntimeExtensionPoint)this.mapExtensionPoints.get(pid);
    }

    protected RuntimeExtension getExtension(String xid) {
        return (RuntimeExtension)this.mapExtensions.get(xid);
    }

    protected void initPlugins(RuntimePluginDescriptor[] pluginDescriptors) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Plugins: " + pluginDescriptors.length);
        }
        for (int c = 0; c < pluginDescriptors.length; ++c) {
            String pid;
            RuntimePluginDescriptor pd = pluginDescriptors[c];
            if (pd == null || (pid = pd.getId()) == null) continue;
            this.registerPluginDescriptorInternal(pid, pd);
        }
        int totalPoints = 0;
        for (int c = 0; c < pluginDescriptors.length; ++c) {
            ExtensionPoint[] points;
            RuntimePluginDescriptor pd = pluginDescriptors[c];
            if (pd == null || (points = pd.getExtensionPoints()) == null) continue;
            for (int k = 0; k < points.length; ++k) {
                RuntimeExtensionPoint point = (RuntimeExtensionPoint)points[k];
                if (point == null) continue;
                this.registerExtensionPointInternal(pd, point);
                ++totalPoints;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ExtensionPoints: " + totalPoints);
        }
        int totalExtensions = 0;
        for (int c = 0; c < pluginDescriptors.length; ++c) {
            Extension[] exts;
            RuntimePluginDescriptor pd = pluginDescriptors[c];
            if (pd == null || (exts = pd.getExtensions()) == null) continue;
            for (int k = 0; k < exts.length; ++k) {
                RuntimeExtension ext = (RuntimeExtension)exts[k];
                if (ext == null) continue;
                try {
                    this.registerExtensionInternal(pd, ext);
                    ++totalExtensions;
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error while initializing extension: plugin=" + pd + ", extension=" + ext, e);
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Extensions: " + totalExtensions);
        }
    }

    protected void startPlugins() throws Exception {
        for (PluginDescriptor descr : this.mapPluginDescr.values()) {
            if (!descr.isAutostart()) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Autostart plugin: " + descr.getName());
            }
            Plugin plugin = this.getPlugin(descr);
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Plugin started: " + plugin);
        }
    }

    protected class ConfigInjectorImpl
    extends ConfigInjector {
        private Injection injection;

        public ConfigInjectorImpl(ClassLoader classLoader, Injection injection) {
            super(classLoader);
            this.injection = injection;
        }

        protected Object lookupExtension(ConfigNode node, String extension) throws Exception {
            boolean finer = logger.isLoggable(Level.FINER);
            if (finer) {
                logger.entering(ConfigInjectorImpl.class.getName(), "lookupExtension", new Object[]{node, extension});
            }
            Object rc = AbstractPlatform.this.getExtensionInstance(extension);
            if (finer) {
                logger.exiting(ConfigInjectorImpl.class.getName(), "lookupExtension", rc);
            }
            return rc;
        }

        protected Object lookupBean(ConfigNode node, String bean) throws Exception {
            boolean finer = logger.isLoggable(Level.FINEST);
            if (finer) {
                logger.entering(ConfigInjectorImpl.class.getName(), "lookupBean", new Object[]{node, bean});
            }
            Object rc = this.injection.getBean(bean);
            if (finer) {
                logger.exiting(ConfigInjectorImpl.class.getName(), "lookupBean", rc);
            }
            return rc;
        }
    }
}

