/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.EventListenerList;
import com.spacekiller.util.FileContext;
import com.spacekiller.util.FileListener;
import com.spacekiller.util.FileManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultFileManager
implements FileManager {
    private static final int DEFAULT_GARBAGE_BUFFER_SIZE = 65536;
    private static final int DEFAULT_SHRED_ITERATIONS = 1;
    private static final Logger logger = Logger.getLogger(DefaultFileManager.class.getName());
    private Map entries = new HashMap();
    private String sep = File.separator;
    private int sepLen = this.sep.length();
    private EventListenerList fileListeners = new EventListenerList();
    private Handler handler = new Handler();

    public synchronized void registerFileContext(FileContext context) {
        if (context != null) {
            String path = this.getAbsolutePath(context);
            WeakReference<FileContext> ref = new WeakReference<FileContext>(context);
            Entry e = (Entry)this.entries.get(path);
            if (e == null) {
                e = new Entry(ref);
                this.entries.put(path, e);
            } else {
                while (true) {
                    if (e.ref.get() == null) {
                        e.ref = ref;
                        return;
                    }
                    Entry n = e.next;
                    if (n == null) {
                        n = new Entry(ref);
                        e.next = n;
                        return;
                    }
                    e = n;
                }
            }
        }
    }

    public synchronized void unregisterFileContext(FileContext context) {
        block2: {
            String path;
            Entry e;
            if (context == null || (e = (Entry)this.entries.get(path = this.getAbsolutePath(context))) == null) break block2;
            do {
                Object o;
                if ((o = e.ref.get()) == null) {
                    // empty if block
                }
                if (o != context) continue;
            } while ((e = e.next) != null);
        }
    }

    protected synchronized void fileChanged(String path) {
        int i;
        path = this.getAbsolutePath(path);
        int from = 0;
        while ((i = path.indexOf(this.sep, from)) >= 0) {
            String p = from == 0 ? path.substring(0, i + this.sep.length()) : path.substring(0, i);
            Entry e = (Entry)this.entries.get(p);
            while (e != null) {
                FileContext fc = (FileContext)e.ref.get();
                if (fc != null) {
                    logger.fine("fileChanged => " + fc);
                    fc.fileChanged(path);
                }
                e = e.next;
            }
            from = i + this.sepLen;
        }
        this.fireFileChanged(path);
    }

    protected synchronized void fileInserted(String path) {
        int i;
        path = this.getAbsolutePath(path);
        int from = 0;
        while ((i = path.indexOf(this.sep, from)) >= 0) {
            String p = from == 0 ? path.substring(0, i + this.sep.length()) : path.substring(0, i);
            Entry e = (Entry)this.entries.get(p);
            while (e != null) {
                FileContext fc = (FileContext)e.ref.get();
                if (fc != null) {
                    logger.fine("fileInserted => " + fc);
                    fc.fileInserted(path);
                } else {
                    logger.fine("TODO remove garbage-entry: " + e);
                }
                e = e.next;
            }
            from = i + this.sepLen;
        }
        this.fireFileInserted(path);
    }

    protected synchronized void fileRemoved(String path) {
        int i;
        path = this.getAbsolutePath(path);
        int from = 0;
        while ((i = path.indexOf(this.sep, from)) >= 0) {
            String p = from == 0 ? path.substring(0, i + this.sep.length()) : path.substring(0, i);
            Entry e = (Entry)this.entries.get(p);
            while (e != null) {
                FileContext fc = (FileContext)e.ref.get();
                if (fc != null) {
                    logger.fine("fileRemoved => " + fc);
                    fc.fileRemoved(path);
                }
                e = e.next;
            }
            from = i + this.sepLen;
        }
        this.fireFileRemoved(path);
    }

    protected synchronized void directoryInserted(String path) {
        int i;
        path = this.getAbsolutePath(path);
        int from = 0;
        while ((i = path.indexOf(this.sep, from)) >= 0) {
            String p = from == 0 ? path.substring(0, i + this.sep.length()) : path.substring(0, i);
            Entry e = (Entry)this.entries.get(p);
            while (e != null) {
                FileContext fc = (FileContext)e.ref.get();
                if (fc != null) {
                    logger.fine("directoryInserted => " + fc);
                    fc.directoryInserted(path);
                }
                e = e.next;
            }
            from = i + this.sepLen;
        }
        this.fireDirectoryInserted(path);
    }

    protected synchronized void directoryRemoved(String path) {
        int i;
        path = this.getAbsolutePath(path);
        int from = 0;
        while ((i = path.indexOf(this.sep, from)) >= 0) {
            String p = from == 0 ? path.substring(0, i + this.sep.length()) : path.substring(0, i);
            Entry e = (Entry)this.entries.get(p);
            while (e != null) {
                FileContext fc = (FileContext)e.ref.get();
                if (fc != null) {
                    logger.fine("directoryRemoved=> " + fc);
                    fc.directoryRemoved(path);
                }
                e = e.next;
            }
            from = i + this.sepLen;
        }
        this.fireDirectoryRemoved(path);
    }

    protected String getAbsolutePath(FileContext fc) {
        return this.getAbsolutePath(fc.getPath());
    }

    protected String getAbsolutePath(String path) {
        if (path == null) {
            return "";
        }
        return path;
    }

    public void addFileListener(FileListener l) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("addFileListener: " + l);
        }
        this.fileListeners.add(FileListener.class, (EventListener)l);
    }

    public void removeFileListener(FileListener l) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("removeFileListener: " + l);
        }
        this.fileListeners.remove(FileListener.class, (EventListener)l);
    }

    protected void fireFileChanged(String path) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("fireFileChanged: " + path);
        }
        Object[] l = this.fileListeners.getListenerList();
        for (int i = 1; i < l.length; i += 2) {
            ((FileListener)l[i]).fileChanged(path);
        }
    }

    protected void fireFileInserted(String path) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("fireFileInserted: " + path);
        }
        Object[] l = this.fileListeners.getListenerList();
        for (int i = 1; i < l.length; i += 2) {
            logger.fine(" - fireFileInserted >> " + l[i]);
            ((FileListener)l[i]).fileInserted(path);
        }
    }

    protected void fireFileRemoved(String path) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("fireFileRemoved: " + path);
        }
        Object[] l = this.fileListeners.getListenerList();
        for (int i = 1; i < l.length; i += 2) {
            ((FileListener)l[i]).fileRemoved(path);
        }
    }

    protected void fireDirectoryInserted(String path) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("fireDirectoryInserted: " + path);
        }
        Object[] l = this.fileListeners.getListenerList();
        for (int i = 1; i < l.length; i += 2) {
            ((FileListener)l[i]).directoryInserted(path);
        }
    }

    protected void fireDirectoryRemoved(String path) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("fireDirectoryRemoved: " + path);
        }
        Object[] l = this.fileListeners.getListenerList();
        for (int i = 1; i < l.length; i += 2) {
            ((FileListener)l[i]).directoryRemoved(path);
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public boolean renameFile(File file, File dest) throws IOException {
        return file.renameTo(dest);
    }

    public boolean deleteFile(File file) throws IOException {
        return file.delete();
    }

    public boolean destroyFile(File file) throws IOException {
        return this.destroyFile(file, 1, 65536);
    }

    protected boolean destroyFile(File file, int iterations, int garbageBufferSize) throws IOException {
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        File dest = this.rename(file);
        if (dest == null) {
            return false;
        }
        if (file.exists()) {
            return false;
        }
        if (!dest.exists()) {
            return false;
        }
        if (iterations < 1) {
            iterations = 1;
        }
        byte[][] garbage = DefaultFileManager.makeGarbage(iterations, garbageBufferSize);
        return this.destroyFileImpl(dest, garbage);
    }

    private static byte[][] makeGarbage(int count, int bufferSize) {
        Random random = new Random();
        byte[][] arrs = new byte[count][];
        for (int i = 0; i < count; ++i) {
            byte[] buf = new byte[bufferSize];
            random.nextBytes(buf);
            arrs[i] = buf;
        }
        return arrs;
    }

    private File rename(File file) throws IOException {
        String prefix = "shr";
        String suffix = ".grb";
        File dir = file.getParentFile();
        int loops = 1000;
        for (int i = 0; i < loops; ++i) {
            int rand = (int)(Math.random() * 100000.0);
            String newName = prefix + rand + suffix;
            File dest = new File(dir, newName);
            if (dest.exists()) continue;
            if (file.renameTo(dest)) {
                return dest;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean destroyFileImpl(File file, byte[][] garbage) throws IOException {
        String mode = "rws";
        for (int i = 0; i < garbage.length; ++i) {
            RandomAccessFile raf = new RandomAccessFile(file, mode);
            try {
                int n;
                raf.seek(0L);
                byte[] buf = garbage[i];
                int bufSize = buf.length;
                for (long left = raf.length(); left > 0L; left -= (long)n) {
                    n = (int)Math.min(left, (long)bufSize);
                    raf.write(buf, 0, n);
                }
                continue;
            }
            finally {
                raf.close();
            }
        }
        RandomAccessFile raf = new RandomAccessFile(file, mode);
        try {
            raf.seek(0L);
            raf.setLength(0L);
        }
        finally {
            raf.close();
        }
        return file.delete();
    }

    protected class Handler
    implements FileListener {
        protected Handler() {
        }

        public void directoryInserted(String path) {
            DefaultFileManager.this.directoryInserted(path);
        }

        public void directoryRemoved(String path) {
            DefaultFileManager.this.directoryRemoved(path);
        }

        public void fileChanged(String path) {
            DefaultFileManager.this.fileChanged(path);
        }

        public void fileInserted(String path) {
            DefaultFileManager.this.fileInserted(path);
        }

        public void fileRemoved(String path) {
            DefaultFileManager.this.fileRemoved(path);
        }
    }

    protected static class Entry {
        private Reference ref;
        private Entry next;

        public Entry(Reference ref) {
            this.ref = ref;
        }
    }
}

