/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.buffer.Base64Util;
import com.spacekiller.util.platform.DefaultPropertySupport;
import com.spacekiller.util.platform.PropertyReader;
import com.spacekiller.util.platform.ZOldMuellerObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultPropertyReader
implements PropertyReader {
    protected static final StringReader stringReader = new StringReader();
    protected static final ObjectReader objectReader = new ObjectReader();
    protected Map<String, PropertyReader> readers = new HashMap<String, PropertyReader>();

    public DefaultPropertyReader() {
        this.initializeReaders(this.readers);
    }

    protected void initializeReaders(Map<String, PropertyReader> map) {
        this.initializeDefaultReaders(map);
    }

    protected void initializeDefaultReaders(Map<String, PropertyReader> map) {
        map.put("object", objectReader);
        map.put("rectangle", DefaultPropertySupport.rectangleReader);
    }

    @Override
    public void read(Properties props, String key, String value, Map<String, Object> map) throws IOException, ClassNotFoundException {
        if (value == null) {
            return;
        }
        int keyLen = key.length();
        if (keyLen > 0) {
            char c = key.charAt(keyLen - 1);
            switch (c) {
                case ')': {
                    String type;
                    PropertyReader reader;
                    int x = key.lastIndexOf(40);
                    if (x < 0 || (reader = this.readers.get(type = key.substring(x + 1, keyLen - 1))) == null) break;
                    key = key.substring(0, x);
                    reader.read(props, key, value, map);
                    return;
                }
                case '@': {
                    String type;
                    PropertyReader reader;
                    int x = key.lastIndexOf(".@");
                    if (x < 0 || (reader = this.readers.get(type = key.substring(x + 2, keyLen - 1))) == null) break;
                    key = key.substring(0, x);
                    reader.read(props, key, value, map);
                    return;
                }
            }
        }
        stringReader.read(props, key, value, map);
    }

    protected static class ObjectReader
    implements PropertyReader {
        protected ObjectReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read(Properties props, String key, String value, Map<String, Object> map) throws IOException, ClassNotFoundException {
            byte[] arr;
            try {
                arr = Base64Util.getDecoder().decode(value);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(arr);
            try {
                ZOldMuellerObjectInputStream ois = new ZOldMuellerObjectInputStream(bais);
                try {
                    Object o = ois.readObject();
                    if (o != null) {
                        map.put(key, o);
                    }
                }
                finally {
                    ois.close();
                }
            }
            finally {
                bais.close();
            }
        }
    }

    protected static class StringReader
    implements PropertyReader {
        protected StringReader() {
        }

        @Override
        public void read(Properties props, String key, String value, Map<String, Object> map) throws IOException, ClassNotFoundException {
            map.put(key, value);
        }
    }
}

