/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.EventListenerList;
import com.spacekiller.util.ThreadListener;
import com.spacekiller.util.ThreadManager;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultThreadManager
implements ThreadManager {
    private static final Logger logger = Logger.getLogger(DefaultThreadManager.class.getName());
    private Set threads = new HashSet();
    private List threadList = new LinkedList();
    private EventListenerList listeners = new EventListenerList();

    public synchronized void registerThread(Thread thread) {
        if (thread == null) {
            return;
        }
        if (this.threads.add(thread)) {
            this.threadList.add(thread);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Thread registered: " + thread);
            }
            this.fireThreadRegistered(thread);
        }
    }

    public synchronized void unregisterThread(Thread thread) {
        if (thread == null) {
            return;
        }
        if (this.threads.remove(thread)) {
            this.threadList.remove(thread);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Thread unregistered: " + thread);
            }
            this.fireThreadUnregistered(thread);
        }
    }

    public synchronized int getThreadCount() {
        return this.threadList.size();
    }

    public synchronized Thread[] getThreads() {
        return this.threadList.toArray(new Thread[this.threadList.size()]);
    }

    public synchronized void addThreadListener(ThreadListener listener) {
        this.listeners.add(ThreadListener.class, (EventListener)listener);
    }

    public synchronized void removeThreadListener(ThreadListener listener) {
        this.listeners.remove(ThreadListener.class, (EventListener)listener);
    }

    protected synchronized void fireThreadRegistered(Thread thread) {
        Object[] l = this.listeners.getListenerList();
        for (int i = 1; i < l.length; i += 2) {
            ((ThreadListener)l[i]).threadRegistered(thread);
        }
    }

    protected synchronized void fireThreadUnregistered(Thread thread) {
        Object[] l = this.listeners.getListenerList();
        for (int i = 1; i < l.length; i += 2) {
            ((ThreadListener)l[i]).threadUnregistered(thread);
        }
    }
}

