/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.ConfigNode;
import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.PluginDescriptor;
import com.spacekiller.util.PluginPrerequisite;
import com.spacekiller.util.platform.AbstractPlatform;
import com.spacekiller.util.platform.RuntimeConfigNode;
import com.spacekiller.util.platform.RuntimeExtension;
import com.spacekiller.util.platform.RuntimeExtensionPoint;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;

public class RuntimePluginDescriptor
implements PluginDescriptor {
    private AbstractPlatform platform;
    private PluginDescriptor peer;
    private PluginPrerequisite[] prerequisites;
    private Extension[] extensions;
    private ExtensionPoint[] extensionPoints;
    private Map extensionsByExtensionPoint = new HashMap();
    private String[] injectionResources;
    private boolean pluginStarted = false;

    public RuntimePluginDescriptor(AbstractPlatform platform, PluginDescriptor pluginDescriptor) {
        this.setPlatform(platform);
        this.setPeer(pluginDescriptor);
        this.initRuntimePluginDescriptor();
    }

    protected Reference createPluginReference(Plugin plugin) throws Exception {
        return new WeakReference<Plugin>(plugin);
    }

    protected RuntimeExtension createRuntimeExtension(Extension ext, ConfigNode config) {
        return new RuntimeExtension(this, ext, config, null);
    }

    protected RuntimeExtensionPoint createRuntimeExtensionPoint(ExtensionPoint ep) {
        return new RuntimeExtensionPoint(this, ep);
    }

    public String getDescription() {
        return this.peer.getDescription();
    }

    public Extension getExtension(String id) {
        if (this.extensions != null) {
            for (int c = 0; c < this.extensions.length; ++c) {
                if (!id.equals(this.extensions[c].getId())) continue;
                return this.extensions[c];
            }
        }
        return null;
    }

    public ExtensionPoint getExtensionPoint(String id) {
        if (this.extensionPoints != null) {
            for (int c = 0; c < this.extensionPoints.length; ++c) {
                if (!id.equals(this.extensionPoints[c].getId())) continue;
                return this.extensionPoints[c];
            }
        }
        return null;
    }

    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints;
    }

    public Extension[] getExtensions() {
        return this.extensions;
    }

    public Icon getIcon() {
        return this.peer.getIcon();
    }

    public final String getId() {
        return this.peer.getId();
    }

    public String getName() {
        return this.peer.getName();
    }

    protected final PluginDescriptor getPeer() {
        return this.peer;
    }

    protected final AbstractPlatform getPlatform() {
        return this.platform;
    }

    public final String getPluginClassName() {
        return this.peer.getPluginClassName();
    }

    public final boolean isAutostart() {
        return this.peer.isAutostart();
    }

    public PluginPrerequisite[] getPrerequisites() {
        return this.prerequisites;
    }

    protected Extension[] getRuntimeExtensions(ExtensionPoint point) {
        Collection coll = (Collection)this.extensionsByExtensionPoint.get(point);
        int count = coll == null ? 0 : coll.size();
        Extension[] rc = new Extension[count];
        if (count > 0) {
            rc = coll.toArray(rc);
        }
        return rc;
    }

    public String getTooltip() {
        return this.peer.getTooltip();
    }

    public String getProvider() {
        return this.peer.getProvider();
    }

    public String getVersion() {
        return this.peer.getVersion();
    }

    protected void initRuntimePluginDescriptor() {
        String[] thisResources;
        if (this.peer == null) {
            return;
        }
        this.setPrerequisites(this.peer.getPrerequisites());
        ExtensionPoint[] peerEP = this.peer.getExtensionPoints();
        ExtensionPoint[] thisEP = new ExtensionPoint[peerEP == null ? 0 : peerEP.length];
        for (int c = 0; c < thisEP.length; ++c) {
            thisEP[c] = this.createRuntimeExtensionPoint(peerEP[c]);
        }
        this.setExtensionPoints(thisEP);
        Extension[] peerEX = this.peer.getExtensions();
        Extension[] thisEX = new Extension[peerEX == null ? 0 : peerEX.length];
        for (int c = 0; c < thisEX.length; ++c) {
            Extension ext = peerEX[c];
            ConfigNode configNode = ext.getConfigNode();
            RuntimeConfigNode runtimeConfig = new RuntimeConfigNode(configNode);
            thisEX[c] = this.createRuntimeExtension(ext, runtimeConfig);
        }
        this.setExtensions(thisEX);
        String[] peerResources = this.peer.getInjectionResources();
        String[] stringArray = thisResources = peerResources == null ? new String[]{} : new String[peerResources.length];
        if (thisResources.length > 0) {
            System.arraycopy(peerResources, 0, thisResources, 0, thisResources.length);
        }
        this.setInjectionResources(thisResources);
    }

    protected void registerRuntimeExtension(ExtensionPoint point, Extension extension) {
        if (point == null || extension == null) {
            return;
        }
        Vector<Extension> coll = (Vector<Extension>)this.extensionsByExtensionPoint.get(point);
        if (coll == null) {
            coll = new Vector<Extension>();
            this.extensionsByExtensionPoint.put(point, coll);
        }
        coll.add(extension);
    }

    protected void setExtensionPoints(ExtensionPoint[] newExtensionPoints) {
        this.extensionPoints = newExtensionPoints;
    }

    protected void setExtensions(Extension[] newExtensions) {
        this.extensions = newExtensions;
    }

    private void setPeer(PluginDescriptor newPeer) {
        this.peer = newPeer;
    }

    private void setPlatform(AbstractPlatform newPlatform) {
        this.platform = newPlatform;
    }

    protected void setPrerequisites(PluginPrerequisite[] newPrerequisites) {
        this.prerequisites = newPrerequisites;
    }

    public String toString() {
        return "RuntimePluginDescriptor[" + this.getId() + "]";
    }

    protected boolean isPluginStarted() {
        return this.pluginStarted;
    }

    protected void setPluginStarted(boolean pluginStarted) {
        this.pluginStarted = pluginStarted;
    }

    public String[] getInjectionResources() {
        return this.injectionResources;
    }

    protected void setInjectionResources(String[] injectionResources) {
        this.injectionResources = injectionResources;
    }
}

