/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import com.spacekiller.util.status.StatusBar;
import com.spacekiller.util.tooling.AbstractToolGroup;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;

public class TStatusBar
extends AbstractToolGroup {
    private int separatorPosition = 4;
    private int height = 20;
    private static final Logger logger = Logger.getLogger(TStatusBar.class.getName());

    protected Component createChildComponent(Component statusComponent) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new GridLayout(1, 1));
        panel.add(statusComponent);
        panel.setBorder(new StatusToolBorder(new Color(1.0f, 1.0f, 1.0f, 0.5f), new Color(0.0f, 0.0f, 0.0f, 0.5f)));
        return panel;
    }

    public Object createInstance(ToolContext context, Class type) {
        if (type != null && !type.isAssignableFrom(StatusBar.class)) {
            return null;
        }
        StatusBar rc = new StatusBar();
        rc.setOpaque(false);
        rc.setBackgroundPaint(new Color(0.0f, 0.0f, 0.0f, 0.2f));
        rc.setBorder(new StatusBarBorder(new Color(0.0f, 0.0f, 0.0f, 0.5f)));
        rc.setMinimumSize(new Dimension(0, this.height));
        rc.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.height));
        this.addInstance(rc, context);
        this.refreshInstance(rc);
        this.installContainerChildren(rc, null);
        return rc;
    }

    protected void handleChildrenAdded(ToolEvent ev) {
        this.handleStatusChildrenAdded(ev, null);
    }

    protected void handleChildrenRemoved(ToolEvent ev) {
        this.handleStatusChildrenRemoved(ev);
    }

    protected void handleStatusChildrenAdded(ToolEvent ev, Class childType) {
        Iterator i = this.getInstances();
        while (i.hasNext()) {
            Container cont = (Container)i.next();
            if (cont == null) continue;
            ToolContext ctx = this.getToolContext(cont);
            int count = ev.getChildCount();
            if (count <= 0) continue;
            for (int j = 0; j < count; ++j) {
                Component cc = (Component)ev.getChild(j).createInstance(ctx, childType);
                if (cc == null) {
                    logger.fine("OOPS, no component available for tool!");
                    logger.fine(" - Tool=" + ev.getChild(j));
                    logger.fine(" - Type=" + childType);
                    continue;
                }
                logger.fine("StatusBar: child=" + cc);
                cc = this.createChildComponent(cc);
                cont.add(cc, ev.getChildIndex(j));
            }
            cont.validate();
            cont.repaint();
        }
    }

    protected void handleStatusChildrenRemoved(ToolEvent ev) {
        Iterator i = this.getInstances();
        while (i.hasNext()) {
            int count;
            Container cont = (Container)i.next();
            if (cont == null || (count = ev.getChildCount()) <= 0) continue;
            for (int j = count - 1; j >= 0; --j) {
                cont.remove(ev.getChildIndex(j));
            }
            cont.validate();
            cont.repaint();
        }
    }

    protected void refreshInstance(Object o) {
        try {
            if (o instanceof JComponent) {
                JComponent c = (JComponent)o;
                c.setName(this.getName());
                c.setToolTipText(this.getTooltip());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void installContainerChildren(Container container, Class childType) {
        int count = this.getChildCount();
        ToolContext ctx = this.getToolContext(container);
        for (int c = 0; c < count; ++c) {
            Tool tool = this.getChildAt(c);
            Object obj = tool.createInstance(ctx, childType);
            Component comp = null;
            if (obj instanceof Component) {
                comp = (Component)obj;
            }
            if (comp != null) {
                Component cc = this.createChildComponent(comp);
                container.add(cc, c);
                continue;
            }
            logger.fine("Warning: No component available: tool=" + this.getChildAt(c) + ", type=" + childType);
            JPanel dummy = new JPanel();
            dummy.setOpaque(false);
            container.add((Component)dummy, c);
        }
    }

    public int getSeparatorPosition() {
        return this.separatorPosition;
    }

    public void setSeparatorPosition(int separatorPosition) {
        this.separatorPosition = separatorPosition;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    protected class StatusToolBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 4805956300387766181L;
        private Color highlight = Color.white;
        private Color shadow = Color.black;

        public StatusToolBorder(Color highlight, Color shadow) {
            this.highlight = highlight;
            this.shadow = shadow;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 0;
            insets.top = 0;
            insets.right = 0;
            insets.bottom = 0;
            switch (TStatusBar.this.separatorPosition) {
                case 2: {
                    insets.left = 2;
                    break;
                }
                case 4: {
                    insets.right = 2;
                }
            }
            return insets;
        }

        @Override
        public Rectangle getInteriorRectangle(Component c, int x, int y, int width, int height) {
            return StatusToolBorder.getInteriorRectangle(c, this, x + 1, y, width - 2, height);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            super.paintBorder(c, g, x, y, width, height);
            switch (TStatusBar.this.separatorPosition) {
                case 2: {
                    g.setColor(this.shadow);
                    g.drawLine(x, y + 1, x, y + height - 1);
                    g.setColor(this.highlight);
                    g.drawLine(x + 1, y + 1, x + 1, y + height - 1);
                    break;
                }
                case 4: {
                    g.setColor(this.shadow);
                    g.drawLine(x + width - 2, y + 1, x + width - 2, y + height - 1);
                    g.setColor(this.highlight);
                    g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
                }
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    protected class StatusBarBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -3169556060202252473L;
        private Color color = Color.black;

        public StatusBarBorder(Color color) {
            this.color = color;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 0;
            insets.top = 1;
            insets.right = 0;
            insets.bottom = 0;
            return insets;
        }

        @Override
        public Rectangle getInteriorRectangle(Component c, int x, int y, int width, int height) {
            return StatusBarBorder.getInteriorRectangle(c, this, x, y + 1, width, height - 1);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            super.paintBorder(c, g, x, y, width, height);
            g.setColor(this.color);
            g.drawLine(x, y, x + width, y);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

