/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.service;

import com.spacekiller.util.EventListenerList;
import com.spacekiller.util.service.Service;
import com.spacekiller.util.service.ServiceListener;
import java.util.EventListener;

public abstract class AbstractService
implements Service {
    private String name = this.getClass().getName();
    private String description;
    private String tooltip;
    private int startupMode = 0;
    private volatile int status = 0;
    private EventListenerList serviceListeners = new EventListenerList();

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    protected synchronized void setStatus(int newStatus) {
        if (this.status == newStatus) {
            return;
        }
        this.status = newStatus;
        switch (this.status) {
            case 1: {
                this.fireServiceStarted();
                break;
            }
            case 0: {
                this.fireServiceStopped();
                break;
            }
            case 2: {
                this.fireServiceStarting();
                break;
            }
            case 3: {
                this.fireServiceStopping();
            }
        }
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    public synchronized void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        this.fireServiceUpdated();
    }

    @Override
    public void addServiceListener(ServiceListener l) {
        if (l == null) {
            return;
        }
        this.serviceListeners.add(ServiceListener.class, (EventListener)l);
    }

    @Override
    public void removeServiceListener(ServiceListener l) {
        this.serviceListeners.remove(ServiceListener.class, (EventListener)l);
    }

    protected synchronized void fireServiceStarted() {
        Object[] list = this.serviceListeners.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ServiceListener)list[i]).serviceStarted(this);
        }
    }

    protected synchronized void fireServiceStopped() {
        Object[] list = this.serviceListeners.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ServiceListener)list[i]).serviceStopped(this);
        }
    }

    protected synchronized void fireServiceStarting() {
        Object[] list = this.serviceListeners.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ServiceListener)list[i]).serviceStarting(this);
        }
    }

    protected synchronized void fireServiceStopping() {
        Object[] list = this.serviceListeners.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ServiceListener)list[i]).serviceStopping(this);
        }
    }

    protected synchronized void fireServiceUpdated() {
        Object[] list = this.serviceListeners.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ServiceListener)list[i]).serviceUpdated(this);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
        this.fireServiceUpdated();
    }

    @Override
    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    @Override
    public int getStartupMode() {
        return this.startupMode;
    }

    @Override
    public synchronized void setStartupMode(int newStartupMode) {
        if (this.startupMode == newStartupMode) {
            return;
        }
        this.startupMode = newStartupMode;
        this.fireServiceUpdated();
    }

    protected synchronized void save() {
        this.fireServiceUpdated();
    }
}

