/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;

public class FontOutline {
    public static final BasicStroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    private static FontRenderContext DEFAULT_FONT_RENDER_CONTEXT;
    private char[] text;
    private Font font;
    private Stroke outlineStroke = DEFAULT_OUTLINE_STROKE;
    private Shape textShape;
    private boolean valid;
    private FontRenderContext fontRenderContext;

    public FontOutline(Font font, char[] text) {
        this.setFont(font);
        this.setText(text);
        this.setFontRenderContext(FontOutline.getDefaultFontRenderContext());
    }

    public static FontRenderContext getDefaultFontRenderContext() {
        FontRenderContext ctx = DEFAULT_FONT_RENDER_CONTEXT;
        if (ctx == null) {
            boolean isAntiAliased = true;
            boolean usesFractionalMetrics = true;
            DEFAULT_FONT_RENDER_CONTEXT = ctx = new FontRenderContext(null, isAntiAliased, usesFractionalMetrics);
        }
        return ctx;
    }

    public void drawText(Graphics2D g, int x, int y, Paint fillPaint, Paint outlinePaint) {
        Shape shape = this.getTextShape();
        Paint oldPaint = g.getPaint();
        g.translate(x, y);
        if (fillPaint != null) {
            g.setPaint(fillPaint);
            g.fill(shape);
        }
        if (outlinePaint != null) {
            Stroke oldStroke = g.getStroke();
            g.setPaint(outlinePaint);
            g.setStroke(this.outlineStroke);
            g.draw(shape);
            g.setStroke(oldStroke);
        }
        g.translate(-x, -y);
        g.setPaint(oldPaint);
    }

    public void validate() {
        GlyphVector gv = this.font.createGlyphVector(this.fontRenderContext, this.text);
        Shape shape = gv.getOutline();
        this.setTextShape(shape);
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    public char[] getText() {
        return this.text;
    }

    public void setText(char[] text) {
        this.text = text;
        this.setValid(false);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (this.font == font) {
            return;
        }
        this.font = font;
        this.setValid(false);
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public void setFontRenderContext(FontRenderContext fontRenderContext) {
        this.fontRenderContext = fontRenderContext;
        this.setValid(false);
    }

    public Shape getTextShape() {
        if (!this.valid) {
            this.validate();
        }
        return this.textShape;
    }

    protected void setTextShape(Shape textShape) {
        this.textShape = textShape;
    }

    public static Color paler(Color c) {
        float[] hsb = new float[3];
        hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsb);
        hsb[1] = hsb[1] / 2.0f;
        int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        int alpha = c.getAlpha() / 2;
        int rgba = rgb & 0xFFFFFF | alpha << 24;
        return new Color(rgba, true);
    }
}

