/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import com.spacekiller.util.render.ScalablePane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;

public class ScalableRepaintManager
extends RepaintManager {
    static ScalableRepaintManager defaultScalableRepaintManager = null;
    Vector scalablePanes = new Vector();
    int painting = 0;
    private static final Logger logger = Logger.getLogger(ScalableRepaintManager.class.getName());

    private ScalableRepaintManager() {
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        if (this.painting > 0) {
            return;
        }
        if (c == null) {
            return;
        }
        if (w < 1 || h < 1) {
            return;
        }
        ScalablePane pane = this.getScalablePane(c);
        if (pane != null) {
            Rectangle bounds = this.translate(c, new Rectangle(x, y, w, h), pane);
            pane.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            return;
        }
        super.addDirtyRegion(c, x, y, w, h);
    }

    @Override
    public void addInvalidComponent(JComponent invalidComponent) {
        if (this.painting > 0) {
            return;
        }
        if (invalidComponent == null) {
            return;
        }
        ScalablePane pane = this.getScalablePane(invalidComponent);
        if (pane != null) {
            Rectangle rect = this.translate(invalidComponent, new Rectangle(0, 0, invalidComponent.getWidth(), invalidComponent.getHeight()), pane);
            logger.fine("invalid component: " + rect + " => " + invalidComponent.getName());
        }
        super.addInvalidComponent(invalidComponent);
    }

    public void addScalablePane(ScalablePane pane) {
        if (this.scalablePanes.indexOf(pane) >= 0) {
            return;
        }
        this.scalablePanes.addElement(pane);
    }

    public static ScalableRepaintManager getDefaultScalableRepaintManager() {
        if (defaultScalableRepaintManager == null) {
            defaultScalableRepaintManager = new ScalableRepaintManager();
            RepaintManager.setCurrentManager(defaultScalableRepaintManager);
        }
        return defaultScalableRepaintManager;
    }

    private ScalablePane getScalablePane(JComponent c) {
        if (c == null) {
            return null;
        }
        Enumeration en = this.scalablePanes.elements();
        while (en.hasMoreElements()) {
            JComponent scaleComp;
            ScalablePane pane = (ScalablePane)en.nextElement();
            if (!pane.isScaled() || (scaleComp = pane.getScaleComponent()) == null) continue;
            if (scaleComp == c || scaleComp.isAncestorOf(c)) {
                return pane;
            }
            if (!pane.eventHandlerFrame.isAncestorOf(c)) continue;
            logger.fine("repaint-Anchestor is FRAME!!");
        }
        return null;
    }

    @Override
    public void paintDirtyRegions() {
        ++this.painting;
        try {
            super.paintDirtyRegions();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        --this.painting;
    }

    public void removeScalablePane(ScalablePane pane) {
        if (this.scalablePanes.indexOf(pane) < 0) {
            return;
        }
        this.scalablePanes.removeElement(pane);
    }

    private Rectangle translate(JComponent c, Rectangle r, ScalablePane sp) {
        for (Container comp = c; !(comp == null || comp instanceof ScalablePane.ScaleComponent || comp instanceof ScalablePane.ScaleFrame || comp instanceof JRootPane); comp = comp.getParent()) {
            r.x += ((Component)comp).getX();
            r.y += ((Component)comp).getY();
        }
        double scaleX = sp.getScaleX();
        double scaleY = sp.getScaleY();
        r.x = (int)((double)r.x * scaleX);
        r.y = (int)((double)r.y * scaleY);
        r.width = (int)Math.round((double)r.width * scaleX);
        r.height = (int)Math.round((double)r.height * scaleY);
        return r;
    }
}

