/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import com.spacekiller.util.render.ScalablePane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScaleControl
extends JPanel {
    private static final long serialVersionUID = 735406505943926922L;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JComboBox ivjJComboBox1 = null;
    private ScalablePane fieldScalable = null;
    private static final Logger logger = Logger.getLogger(ScaleControl.class.getName());

    public ScaleControl() {
        this.initialize();
    }

    public ScaleControl(LayoutManager layout) {
        super(layout);
    }

    public ScaleControl(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public ScaleControl(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    private void action_Scale() {
        ScalablePane pane = this.getScalable();
        if (pane == null) {
            return;
        }
        Object item = this.getJComboBox1().getSelectedItem();
        if (item == null) {
            return;
        }
        String s = item.toString();
        int i = Integer.parseInt(s.trim());
        double scale = (double)i / 100.0;
        if (scale < 0.01) {
            scale = 0.01;
        }
        pane.setScaleX(scale);
        pane.setScaleY(scale);
        pane.validate();
        pane.repaint();
    }

    private void connEtoC1(ItemEvent arg1) {
        try {
            this.action_Scale();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(PropertyChangeEvent arg1) {
        try {
            this.scaleControl_Scalable(this.getScalable());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.scaleControl_Initialize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JComboBox getJComboBox1() {
        if (this.ivjJComboBox1 == null) {
            try {
                this.ivjJComboBox1 = new JComboBox();
                this.ivjJComboBox1.setName("JComboBox1");
                this.ivjJComboBox1.setOpaque(false);
                this.ivjJComboBox1.setEditable(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJComboBox1;
    }

    public ScalablePane getScalable() {
        return this.fieldScalable;
    }

    private void handleException(Throwable exception) {
        logger.fine("--------- UNCAUGHT EXCEPTION ---------");
        logger.log(Level.SEVERE, exception.getMessage(), exception);
    }

    private void initConnections() throws Exception {
        this.getJComboBox1().addItemListener(this.ivjEventHandler);
        this.addPropertyChangeListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ScaleControl");
            this.setLayout(new GridBagLayout());
            this.setSize(201, 46);
            GridBagConstraints constraintsJComboBox1 = new GridBagConstraints();
            constraintsJComboBox1.gridx = 0;
            constraintsJComboBox1.gridy = 0;
            constraintsJComboBox1.fill = 1;
            constraintsJComboBox1.weightx = 1.0;
            constraintsJComboBox1.weighty = 1.0;
            this.add((Component)this.getJComboBox1(), constraintsJComboBox1);
            this.initConnections();
            this.connEtoC3();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            ScaleControl aScaleControl = new ScaleControl();
            frame.setContentPane(aScaleControl);
            frame.setSize(aScaleControl.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void scaleControl_Initialize() {
        this.getJComboBox1().addItem("25");
        this.getJComboBox1().addItem("50");
        this.getJComboBox1().addItem("75");
        this.getJComboBox1().addItem("100");
        this.getJComboBox1().addItem("150");
        this.getJComboBox1().addItem("200");
        this.getJComboBox1().setSelectedItem("100");
    }

    private void scaleControl_Scalable(ScalablePane arg1) {
        if (arg1 == null) {
            return;
        }
        this.action_Scale();
    }

    public void setScalable(ScalablePane scalable) {
        ScalablePane oldValue = this.fieldScalable;
        this.fieldScalable = scalable;
        this.firePropertyChange("scalable", oldValue, scalable);
    }

    class IvjEventHandler
    implements ItemListener,
    PropertyChangeListener {
        IvjEventHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == ScaleControl.this.getJComboBox1()) {
                ScaleControl.this.connEtoC1(e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == ScaleControl.this && evt.getPropertyName().equals("scalable")) {
                ScaleControl.this.connEtoC2(evt);
            }
        }
    }
}

