/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.help;

import com.spacekiller.util.help.HelpNode;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public class DefaultHelpNode
implements HelpNode {
    private String parent;
    private String key;
    private String url;
    private String name;
    private Vector children;

    public DefaultHelpNode(String key, String name, String url) {
        if (key == null || url == null) {
            throw new NullPointerException("null is not allowed");
        }
        this.setKey(key);
        this.setName(name);
        this.setUrl(url);
    }

    @Override
    public void addChild(String h) {
        this.insertChildAt(h, this.getChildCount());
    }

    @Override
    public String getChildAt(int index) {
        return (String)this.children.get(index);
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public String getURL() {
        return this.getUrl();
    }

    @Override
    public void insertChildAt(String h, int i) {
        if (h == null) {
            return;
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        if (this.children.contains(h)) {
            return;
        }
        this.children.insertElementAt(h, i);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte ver = in.readByte();
        this.setKey(in.readUTF());
        this.setName(in.readUTF());
        this.setUrl(in.readUTF());
        int count = in.readInt();
        for (int c = 0; c < count; ++c) {
            this.addChild(in.readUTF());
        }
        if (ver < 1) {
            return;
        }
    }

    @Override
    public void removeChild(String h) {
        if (this.children == null) {
            return;
        }
        if (h == null) {
            return;
        }
        this.children.removeElement(h);
    }

    @Override
    public void removeChildAt(int i) {
        if (this.children == null) {
            return;
        }
        String h = this.getChildAt(i);
        this.removeChild(h);
    }

    protected void setKey(String newKey) {
        this.key = newKey;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public void setParent(String newParent) {
        this.parent = newParent;
    }

    public void setUrl(String newUrl) {
        this.url = newUrl;
    }

    @Override
    public void setURL(String newUrl) {
        this.setUrl(newUrl);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeUTF(this.getKey());
        out.writeUTF(this.getName());
        out.writeUTF(this.getUrl());
        int count = this.getChildCount();
        out.writeInt(count);
        for (int c = 0; c < count; ++c) {
            out.writeUTF(this.getChildAt(c));
        }
    }
}

