/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.CollisionDetector;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.Scene;
import java.util.Set;

public abstract class AbstractCollisionGroup
implements CollisionGroup {
    private Scene scene;
    private CollisionDetector detector;
    private Set enemyGroups;

    public AbstractCollisionGroup(Scene scene, CollisionDetector detector, Set enemyGroups) {
        this.scene = scene;
        this.detector = detector;
        this.enemyGroups = enemyGroups;
    }

    @Override
    public boolean isCollision(Element e, Element o) {
        CollisionGroup og = o.getCollisionGroup();
        if (og == this || og == null) {
            return false;
        }
        return this.enemyGroups.contains(og);
    }

    @Override
    public void handleCollision(Element e, Element o) {
        Actor ca;
        if (this.isCollision(e, o) && (ca = this.createCollisionActor(e, o)) != null) {
            this.scene.addActor(ca);
        }
    }

    protected abstract Actor createCollisionActor(Element var1, Element var2);

    public CollisionDetector getDetector() {
        return this.detector;
    }

    protected void setDetector(CollisionDetector detector) {
        this.detector = detector;
    }
}

