/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Clock;
import com.spacekiller.game2d.ClockType;
import com.spacekiller.game2d.DefaultEngine;
import com.spacekiller.game2d.DefaultSurface;
import com.spacekiller.game2d.Engine;
import com.spacekiller.game2d.Environment;
import com.spacekiller.game2d.Game;
import com.spacekiller.game2d.GameConfig;
import com.spacekiller.game2d.InputBinder;
import com.spacekiller.game2d.InputManager;
import com.spacekiller.game2d.InputMap;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.SurfaceType;
import com.spacekiller.game2d.config.PersistenceManager;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioPlayer;
import com.spacekiller.util.swing.DisplayModePropertyEditor;
import com.spacekiller.util.swing.GraphicsDevicePropertyEditor;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;

public abstract class AbstractGame
implements Game {
    private static final int DEFAULT_AUDIO_BUFFER_POOL_SIZE = 0x400000;
    private Environment environment;
    private GameConfig config;
    private Clock clock;
    private Engine engine;
    private Surface surface;
    private ResourceRegistry registry;
    private AudioPlayer audioPlayer;
    private AudioBufferPool audioBufferPool;
    private PersistenceManager persistenceManager;
    private InputManager inputManager;
    private InputMap inputMap;
    private String title;
    private Image iconImage;
    private Rectangle windowBounds;
    private boolean initialized = false;
    private boolean running = false;

    public AbstractGame() {
        this.setTitle("New Game");
        this.setWindowBounds(new Rectangle(100, 100, 600, 600));
    }

    @Override
    public AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    @Override
    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public InputMap getInputMap() {
        return this.inputMap;
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public ResourceRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public Surface getSurface() {
        return this.surface;
    }

    protected void setAudioPlayer(AudioPlayer player) {
        this.audioPlayer = player;
    }

    protected void setEngine(Engine engine) {
        this.engine = engine;
    }

    protected void setInputMap(InputMap map) {
        this.inputMap = map;
    }

    protected void setPersistenceManager(PersistenceManager manager) {
        this.persistenceManager = manager;
    }

    protected void setRegistry(ResourceRegistry registry) {
        this.registry = registry;
    }

    protected void setSurface(Surface surface) {
        this.surface = surface;
    }

    @Override
    public GameConfig getConfig() {
        return this.config;
    }

    protected void setConfig(GameConfig config) {
        this.config = config;
    }

    @Override
    public void init() throws Exception {
        if (this.isInitialized()) {
            throw new Exception("Game already initialized!");
        }
        if (this.environment == null) {
            throw new NullPointerException("environment==null");
        }
        this.initSurface();
        Surface surface = this.getSurface();
        int surfaceW = surface.getWidth();
        int surfaceH = surface.getHeight();
        System.out.println("Surface resolution: " + surfaceW + "x" + surfaceH);
        this.initAudioBufferPool();
        this.initAudioPlayer();
        this.initInputManager();
        InputManager inputManager = this.getInputManager();
        System.out.println("InputManager: " + inputManager);
        this.initInputMap();
        InputMap inputMap = this.getInputMap();
        System.out.println("InputMap: " + inputMap);
        this.initClock();
        Clock clock = this.getClock();
        System.out.println("Clock: " + clock);
        this.initEngine();
        Engine engine = this.getEngine();
        System.out.println("Engine: " + engine);
        surface.setEngine(engine);
        this.setInitialized(true);
        System.out.println("------------------------------");
        System.out.println("Game initialized successfully.");
        System.out.println("------------------------------");
    }

    protected void initEngine() throws Exception {
        Clock clock = this.getClock();
        if (clock == null) {
            throw new NullPointerException("clock==null");
        }
        Surface surface = this.getSurface();
        if (surface == null) {
            throw new NullPointerException("surface==null");
        }
        DefaultEngine engine = new DefaultEngine(clock);
        engine.addSurface(surface);
        this.setEngine(engine);
    }

    protected void initSurface() throws Exception {
        SurfaceType surfaceType = null;
        String surfaceTypeId = this.config.getProperty("bufferStrategy");
        if (surfaceTypeId != null) {
            surfaceType = this.environment.getSurfaceType(surfaceTypeId);
        }
        if (surfaceType == null) {
            if (this.environment.getSurfaceTypeCount() < 1) {
                throw new Exception("No SurfaceType(s) available");
            }
            surfaceType = this.environment.getSurfaceTypeAt(0);
        }
        System.out.println("SurfaceType: " + surfaceType);
        String surfaceMode = this.config.getProperty("surface");
        String displayDeviceId = this.config.getProperty("displayDevice");
        GraphicsDevice displayDevice = null;
        if (displayDeviceId != null && displayDeviceId.length() > 0) {
            displayDevice = GraphicsDevicePropertyEditor.parseDisplayDevice((String)displayDeviceId);
        }
        if (displayDevice == null) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            displayDevice = env.getDefaultScreenDevice();
        }
        System.out.println("Display device: " + displayDeviceId + " => " + displayDevice);
        String displayModeId = this.config.getProperty("displayMode");
        DisplayMode displayMode = null;
        if (displayModeId != null) {
            displayMode = DisplayModePropertyEditor.parseDisplayMode((GraphicsDevice)displayDevice, (String)displayModeId);
        }
        System.out.println("Display mode: " + displayModeId + " => " + displayMode);
        this.surface = (DefaultSurface)surfaceType.createSurface("" + this.title, this.iconImage, surfaceMode, displayDevice, displayMode, this.windowBounds);
        System.out.println("Surface: " + this.surface);
        this.surface.initialize();
        this.surface.render();
        this.setSurface(this.surface);
    }

    protected void initClock() throws Exception {
        String clockTypeId = this.config.getProperty("clockStrategy");
        ClockType clockType = null;
        if (clockTypeId != null) {
            clockType = this.environment.getClockType(clockTypeId);
        }
        if (clockType == null) {
            if (this.environment.getClockTypeCount() < 1) {
                throw new Exception("No ClockType(s) available");
            }
            clockType = this.environment.getClockTypeAt(0);
        }
        Clock clock = clockType.createClock();
        System.out.println("ClockStrategy: " + clockType + " => " + clock);
        this.setClock(clock);
    }

    protected void initInputManager() throws Exception {
        String inputManagerId = this.config.getProperty("inputManager");
        InputManager inputManager = null;
        if (inputManagerId != null) {
            inputManager = this.environment.getInputManager(inputManagerId);
        }
        if (inputManager == null) {
            if (this.environment.getInputManagerCount() < 1) {
                throw new Exception("No InputManager(s) available");
            }
            inputManager = this.environment.getInputManagerAt(0);
        }
        System.out.println("InputManager: " + inputManager);
        inputManager.setEngine(this.engine);
        inputManager.setSurface(this.surface);
        inputManager.activate();
        this.setInputManager(inputManager);
    }

    protected void initInputMap() throws Exception {
        String inputBinderId = this.config.getProperty("inputBinder");
        InputBinder binder = null;
        if (inputBinderId != null) {
            binder = this.environment.getInputBinder(inputBinderId);
        }
        if (binder == null) {
            if (this.environment.getInputBinderCount() < 1) {
                throw new Exception("No InputBinder(s) available");
            }
            binder = this.environment.getInputBinderAt(0);
        }
        System.out.println("InputBinder: " + binder);
        if (this.inputManager == null) {
            throw new NullPointerException("inputManager==null");
        }
        InputMap inputMap = binder.bind(this.inputManager);
        System.out.println("InputMap: " + inputMap);
        if (inputMap == null) {
            throw new NullPointerException("inputMap==null");
        }
        this.setInputMap(inputMap);
    }

    protected InputBinder instantiateInputBinder(String inputBinderClassName) throws Exception {
        Class<?> inputBinderClass = Class.forName(inputBinderClassName);
        if (!InputBinder.class.isAssignableFrom(inputBinderClass)) {
            throw new ClassCastException("Invalid InputBinder class: " + inputBinderClass);
        }
        return (InputBinder)inputBinderClass.newInstance();
    }

    protected void initAudioPlayer() throws Exception {
        if (this.audioPlayer == null) {
            this.setAudioPlayer(new AudioPlayer());
        }
    }

    protected void initAudioBufferPool() throws Exception {
        if (this.audioBufferPool == null) {
            AudioBufferPool abp = new AudioBufferPool(0x400000);
            this.setAudioBufferPool(abp);
        }
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    protected void setClock(Clock clock) {
        this.clock = clock;
    }

    @Override
    public InputManager getInputManager() {
        return this.inputManager;
    }

    protected void setInputManager(InputManager inputManager) {
        this.inputManager = inputManager;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    protected void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Image getIconImage() {
        return this.iconImage;
    }

    protected void setIconImage(Image iconImage) {
        this.iconImage = iconImage;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    public Rectangle getWindowBounds() {
        return this.windowBounds;
    }

    protected void setWindowBounds(Rectangle windowBounds) {
        this.windowBounds = windowBounds;
    }

    @Override
    public void dispose() throws Exception {
        if (!this.isInitialized()) {
            return;
        }
        System.out.println("" + this + ".dispose()");
        this.disposeSurface();
        this.disposeAudioPlayer();
        this.disposeInputManager();
        this.setInitialized(false);
    }

    protected void disposeSurface() throws Exception {
        Surface surface = this.getSurface();
        if (surface != null) {
            surface.dispose();
            this.setSurface(null);
        }
    }

    protected void disposeInputManager() throws Exception {
        InputManager manager = this.getInputManager();
        if (manager != null) {
            manager.deactivate();
            this.setInputManager(null);
        }
    }

    protected void disposeAudioPlayer() throws Exception {
        AudioPlayer player = this.getAudioPlayer();
        if (player != null) {
            player.stop();
            this.setAudioPlayer(null);
        }
    }

    @Override
    public AudioBufferPool getAudioBufferPool() {
        return this.audioBufferPool;
    }

    protected void setAudioBufferPool(AudioBufferPool audioBufferPool) {
        this.audioBufferPool = audioBufferPool;
    }
}

