/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Actor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ActorList {
    private static Actor DUMMY_LAST_ACTOR = new DummyActor();
    Actor first;
    Actor last;
    int size = 0;
    private Actor next;
    private List newActors;

    public ActorList() {
        this.initActorList();
    }

    protected void initActorList() {
        this.newActors = new ArrayList();
    }

    void prepend(Actor a) {
        if (a.list == this) {
            return;
        }
        if (a.list != null) {
            a.list.remove(a);
        }
        if (this.first == null) {
            a.prev = null;
            a.next = null;
            this.first = a;
            this.last = a;
        } else {
            a.prev = null;
            a.next = this.first;
            this.first.prev = a;
            this.first = a;
        }
        a.list = this;
        ++this.size;
    }

    public void add(Actor a) {
        ActorList aList = a.list;
        if (aList == this) {
            return;
        }
        if (aList != null) {
            if (aList == this.newActors) {
                return;
            }
            aList.remove(a);
        }
        if (this.next == null) {
            if (this.first == null) {
                a.prev = null;
                a.next = null;
                this.first = a;
                this.last = a;
            } else {
                a.prev = this.last;
                a.next = null;
                this.last.next = a;
                this.last = a;
            }
            a.list = this;
            ++this.size;
        } else {
            this.newActors.add(a);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(Actor a) {
        ActorList aList = a.list;
        if (aList != this) {
            if (aList != this.newActors) return;
            this.newActors.remove(a);
            return;
        }
        if (a.prev == null) {
            if (a != this.first) return;
            this.first = a.next;
        } else {
            a.prev.next = a.next;
        }
        if (a.next == null) {
            if (a != this.last) return;
            this.last = a.prev;
        } else {
            a.next.prev = a.prev;
        }
        --this.size;
        if (a == this.next) {
            this.next = this.next.next;
            if (this.next == null) {
                this.next = DUMMY_LAST_ACTOR;
            }
        }
        a.list = null;
        a.next = null;
        a.prev = null;
    }

    public int size() {
        return this.size;
    }

    public void invoke(long ms) {
        this.next = this.first;
        while (this.next != null) {
            this.next.invoke(ms);
            this.next = this.next.next;
        }
        int num = this.newActors.size();
        if (num > 0) {
            for (int c = 0; c < num; ++c) {
                this.add((Actor)this.newActors.get(c));
            }
            this.newActors.clear();
        }
    }

    protected Iterator iterator() {
        return new ActorIterator();
    }

    public class ActorIterator
    implements Iterator {
        private Actor n;

        public ActorIterator() {
            this.reset();
        }

        public void reset() {
            this.n = ActorList.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.n != null;
        }

        public Object next() {
            Actor a = this.n;
            this.n = this.n.next;
            return a;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class NewActorList
    extends ActorList {
        private NewActorList() {
        }

        @Override
        protected void initActorList() {
        }
    }

    private static class DummyActor
    extends Actor {
        private DummyActor() {
        }

        @Override
        public void invoke(long ms) {
        }
    }
}

