/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.ActorList;
import java.util.LinkedList;

public class ActorSequence
extends Actor {
    private LinkedList sequence = new LinkedList();
    private Actor actor;
    private ActorList actorList = new ActorListImpl();

    public void add(Actor a) {
        if (a == null) {
            throw new NullPointerException("Actor is null");
        }
        this.sequence.add(a);
    }

    @Override
    public void invoke(long ms) {
        Actor a = this.actor;
        if (a == null) {
            if (this.sequence.isEmpty()) {
                this.dispose();
                return;
            }
            this.actor = a = (Actor)this.sequence.removeFirst();
            this.actorList.add(a);
        }
        a.invoke(ms);
    }

    protected void handleActorRemoved(Actor a) {
        if (a == this.actor) {
            this.actor = null;
        }
    }

    protected class ActorListImpl
    extends ActorList {
        protected ActorListImpl() {
        }

        @Override
        public void remove(Actor a) {
            super.remove(a);
            ActorSequence.this.handleActorRemoved(a);
        }
    }
}

