/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.AbstractElementType;
import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.AnimationElement;
import com.spacekiller.game2d.AnimationRenderer;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.Scene;

public class AnimationElementType
extends AbstractElementType {
    private Animation animation;
    private int loops;
    private boolean autoDispose;

    public AnimationElementType(String id, Animation ani, int loops, boolean autoDispose) {
        super(id);
        this.setAnimation(ani);
        this.setLoops(loops);
        this.setAutoDispose(autoDispose);
    }

    protected AnimationRenderer createAnimationRenderer() {
        return new AnimationRenderer(this.animation, this.loops, this.autoDispose);
    }

    @Override
    public Element createElement(Object id, double x, double y, double w, double h) throws Exception {
        AnimationRenderer renderer = this.createAnimationRenderer();
        AnimationElement el = new AnimationElement(id, x, y, this.animation.getWidth(), this.animation.getHeight(), this, renderer);
        renderer.setElement(el);
        return el;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public int getLoops() {
        return this.loops;
    }

    public void setLoops(int i) {
        this.loops = i;
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setAutoDispose(boolean b) {
        this.autoDispose = b;
    }

    @Override
    public void setupBehavior(Scene scene, ElementModel model, Element element, MoveActor moveActor) {
    }
}

