/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.AnimationImage;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.View;
import java.awt.Graphics;

public class AnimationRenderer
extends Actor
implements Renderer,
Cloneable {
    private Element element;
    private Animation animation;
    private int images;
    private int loops;
    private boolean autoDispose;
    private int loopIndex;
    private int imageIndex;
    private long ems;
    private long ims;
    private AnimationImage animage;

    public AnimationRenderer(Animation animation, int loops, boolean autoDispose) {
        this.setAnimation(animation);
        this.setLoops(loops);
        this.setAutoDispose(autoDispose);
        this.reset();
    }

    public void reset() {
        this.loopIndex = 0;
        this.imageIndex = 0;
        this.ems = 0L;
        this.ims = 0L;
        if (this.animation != null) {
            this.images = this.animation.getAnimationImageCount();
            if (this.images > 0) {
                this.animage = this.animation.getAnimationImageAt(0);
                this.ims = this.animage.getTime();
            }
        }
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public void paint(Object o, View v, Graphics g) {
        this.animage.paint(g);
    }

    @Override
    public void invoke(long ms) {
        this.ems += ms;
        if (this.ems < this.ims) {
            return;
        }
        this.ems = 0L;
        int newIndex = this.imageIndex + 1;
        if (newIndex >= this.images) {
            newIndex = 0;
            ++this.loopIndex;
            if (this.loopIndex >= this.loops && this.loops >= 0) {
                this.dispose();
                if (this.autoDispose && this.element != null) {
                    this.element.dispose();
                }
                return;
            }
        }
        this.imageIndex = newIndex;
        this.animage = this.animation.getAnimationImageAt(this.imageIndex);
        this.ims = this.animage.getTime();
    }

    public int getLoops() {
        return this.loops;
    }

    public void setLoops(int i) {
        this.loops = i;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public void setImageIndex(int i) {
        this.imageIndex = i;
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setAutoDispose(boolean b) {
        this.autoDispose = b;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String toString() {
        return "AnimationRenderer[" + this.element + "]";
    }

    public Renderer cloneRenderer() throws Exception {
        return (Renderer)this.clone();
    }
}

