/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.CollisionDetector;
import com.spacekiller.game2d.Element;

public abstract class CollisionActor
extends Actor {
    protected Element e;
    protected Element o;
    protected CollisionDetector cd;

    public CollisionActor(Element e, Element o, CollisionDetector cd) {
        this.e = e;
        this.o = o;
        this.cd = cd;
    }

    @Override
    public void invoke(long ms) {
        if (this.e.model == null || this.o.model == null) {
            this.dispose();
            return;
        }
        if (!this.e.intersects(this.o)) {
            this.dispose();
            return;
        }
        if (this.cd.checkCollision(this.e, this.o)) {
            this.handleCollision(ms);
        } else {
            this.handleIntersection(ms);
        }
    }

    protected abstract void handleCollision(long var1);

    protected abstract void handleIntersection(long var1);
}

