/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.RectUtil;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CollisionBounds
implements Shape {
    private Rectangle bounds;
    private Rectangle[] rects;

    public CollisionBounds(Rectangle bounds, Rectangle[] rects) {
        this.bounds = bounds;
        this.rects = rects;
    }

    public CollisionBounds(Rectangle[] rects) {
        this.bounds = this.computeBounds(rects);
        this.rects = rects;
    }

    protected Rectangle computeBounds(Rectangle[] rects) {
        int count = rects.length;
        if (count < 1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int minX = rects[0].x;
        int minY = rects[0].y;
        int maxX = minX + rects[0].width;
        int maxY = minY + rects[0].height;
        for (int c = 1; c < count; ++c) {
            Rectangle r = rects[c];
            if (r.x < minX) {
                minX = r.x;
            }
            if (r.y < minY) {
                minY = r.y;
            }
            if (r.x + r.width > maxX) {
                maxX = r.x + r.width;
            }
            if (r.y + r.height <= maxY) continue;
            maxY = r.y + r.height;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(x, y, 1.0, 1.0);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY(), 1.0, 1.0);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        if (RectUtil.intersects(this.bounds, x, y, w, h)) {
            int count = this.rects.length;
            for (int c = 0; c < count; ++c) {
                if (!RectUtil.intersects(this.rects[c], x, y, w, h)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersects(Rectangle2D.Double r) {
        return this.intersects(r.x, r.y, r.width, r.height);
    }

    public boolean intersects(Rectangle2D.Float r) {
        return this.intersects(r.x, r.y, r.width, r.height);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(CollisionBounds cb, int transX, int transY) {
        for (Rectangle r : this.rects) {
            if (!cb.intersects(r.x + transX, r.y + transY, r.width, r.height)) continue;
            return true;
        }
        return false;
    }

    public int getRectCount() {
        return this.rects.length;
    }

    public Rectangle getRectAt(int i) {
        return new Rectangle(this.rects[i]);
    }

    public void intersect(Rectangle rect, Rectangle dest) {
        dest.setRect(0.0, 0.0, 0.0, 0.0);
        if (RectUtil.intersects(this.bounds, rect)) {
            Rectangle inter = new Rectangle();
            int count = this.rects.length;
            for (int c = 0; c < count; ++c) {
                RectUtil.intersect(this.rects[c], rect, inter);
                if (inter.isEmpty()) continue;
                if (dest.isEmpty()) {
                    dest.setRect(inter);
                    continue;
                }
                dest.add(inter);
            }
        }
    }
}

