/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.AbstractElementType;
import com.spacekiller.game2d.BehaviorType;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.Scene;

public class DefaultElementType
extends AbstractElementType
implements Cloneable {
    protected Renderer renderer;
    protected double elementWidth;
    protected double elementHeight;
    protected CollisionBounds collisionBounds;
    protected CollisionGroup collisionGroup;
    protected BehaviorType behaviorType;

    public DefaultElementType(String id) {
        super(id);
    }

    public DefaultElementType(String id, Renderer renderer, double elementWidth, double elementHeight, CollisionBounds cb, CollisionGroup cg) {
        this(id);
        this.setRenderer(renderer);
        this.setElementWidth(elementWidth);
        this.setElementHeight(elementHeight);
        this.setCollisionBounds(cb);
        this.setCollisionGroup(cg);
    }

    @Override
    public Element createElement(Object id, double x, double y, double w, double h) throws Exception {
        Element el = new Element(id, x, y, this.elementWidth < 0.0 ? w : this.elementWidth, this.elementHeight < 0.0 ? h : this.elementHeight, this, this.renderer);
        el.setCollisionBounds(this.collisionBounds);
        el.setCollisionGroup(this.collisionGroup);
        return el;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public double getElementHeight() {
        return this.elementHeight;
    }

    public double getElementWidth() {
        return this.elementWidth;
    }

    public void setElementHeight(double d) {
        this.elementHeight = d;
    }

    public void setElementWidth(double d) {
        this.elementWidth = d;
    }

    public CollisionBounds getCollisionBounds() {
        return this.collisionBounds;
    }

    public void setCollisionBounds(CollisionBounds bounds) {
        this.collisionBounds = bounds;
    }

    public CollisionGroup getCollisionGroup() {
        return this.collisionGroup;
    }

    public void setCollisionGroup(CollisionGroup group) {
        this.collisionGroup = group;
    }

    public BehaviorType getBehaviorType() {
        return this.behaviorType;
    }

    public void setBehaviorType(BehaviorType behaviorType) {
        this.behaviorType = behaviorType;
    }

    @Override
    public void setupBehavior(Scene scene, ElementModel model, Element element, MoveActor moveActor) {
        BehaviorType bt = this.behaviorType;
        if (bt == null) {
            return;
        }
        bt.setupBehavior(scene, model, element, moveActor);
    }

    protected DefaultElementType cloneElementType() throws Exception {
        return (DefaultElementType)this.clone();
    }
}

