/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Clock;
import com.spacekiller.game2d.DefaultScene;
import com.spacekiller.game2d.DefaultSurface;
import com.spacekiller.game2d.EndOfSceneException;
import com.spacekiller.game2d.Engine;
import com.spacekiller.game2d.EngineListener;
import com.spacekiller.game2d.Surface;
import java.awt.AWTKeyStroke;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultEngine
implements Engine {
    private static final byte CONTINUE = 0;
    private static final byte PAUSE = 1;
    private static final byte STOP = 2;
    private static final Logger logger = Logger.getLogger(DefaultEngine.class.getName());
    private Surface[] surfaces;
    private DefaultScene[] scenes;
    private boolean running = false;
    private boolean paused = false;
    private byte signal = 0;
    private SceneRunner sceneRunner;
    private ComponentHandler componentHandler = new ComponentHandler();
    private WindowHandler windowHandler = new WindowHandler();
    private KeyHandler keyHandler = new KeyHandler();
    private Map keyListeners = new HashMap();
    private boolean reset = false;
    private long frames = 0L;
    private long ms = 0L;
    private Clock clock;
    private long[] fpsMs;
    private int fpsIndex;
    private long fpsTotal = 0L;
    private float fpsFactor = 0.0f;
    private long delta = 0L;
    private long maxFrameMillis = 100L;
    private LinkedList<EngineListener> engineListeners = new LinkedList();

    public DefaultEngine(Clock clock) {
        this.scenes = new DefaultScene[0];
        this.surfaces = new Surface[0];
        this.registerDefaultKeyStrokes();
        this.fpsMs = new long[100];
        this.fpsFactor = (float)this.fpsMs.length * 1000.0f;
        this.setClock(clock);
    }

    @Override
    public int getSurfaceCount() {
        return this.surfaces.length;
    }

    public synchronized void addSurface(Surface surface) {
        if (surface == null) {
            return;
        }
        Surface[] newSurfaces = new Surface[this.surfaces.length + 1];
        System.arraycopy(this.surfaces, 0, newSurfaces, 0, this.surfaces.length);
        newSurfaces[this.surfaces.length] = surface;
        this.surfaces = newSurfaces;
        Window win = surface.getWindow();
        if (win != null) {
            win.addComponentListener(this.componentHandler);
            win.addWindowListener(this.windowHandler);
            win.addKeyListener(this.keyHandler);
        }
    }

    public synchronized void addScene(DefaultScene scene) {
        if (scene == null) {
            return;
        }
        DefaultScene[] newScenes = new DefaultScene[this.scenes.length + 1];
        System.arraycopy(this.scenes, 0, newScenes, 0, this.scenes.length);
        newScenes[this.scenes.length] = scene;
        this.scenes = newScenes;
    }

    public synchronized void removeScene(DefaultScene scene) {
        int i = -1;
        for (int c = 0; c < this.scenes.length; ++c) {
            if (this.scenes[c] != scene) continue;
            i = c;
            break;
        }
        if (i < 0) {
            return;
        }
        DefaultScene[] newScenes = new DefaultScene[this.scenes.length - 1];
        System.arraycopy(this.scenes, 0, newScenes, 0, i);
        System.arraycopy(this.scenes, i + 1, newScenes, i, this.scenes.length - i - 1);
        this.scenes = newScenes;
    }

    public synchronized void clearScenes() {
        this.scenes = new DefaultScene[0];
    }

    protected URL getResource(String name) throws Exception {
        return this.getClass().getResource(name);
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    protected void registerDefaultKeyStrokes() {
        this.addKeyListener(81, new SystemExitKeyListener());
        this.addKeyListener(82, new SurfaceRefreshKeyListener());
        this.addKeyListener(27, new EngineStopKeyListener());
        this.addKeyListener(19, new EnginePauseKeyListener());
    }

    protected void addKeyListener(int keyCode, KeyListener l) {
        AWTKeyStroke k = AWTKeyStroke.getAWTKeyStroke(keyCode, 0);
        this.keyListeners.put(k, l);
    }

    protected void removeKeyListener(int keyCode, KeyListener l) {
        AWTKeyStroke k = AWTKeyStroke.getAWTKeyStroke(keyCode, 0);
        if (this.keyListeners.get(k) == l) {
            this.keyListeners.remove(k);
        }
    }

    protected KeyListener getKeyListener(int keyCode) {
        AWTKeyStroke k = AWTKeyStroke.getAWTKeyStroke(keyCode, 0);
        return this.getKeyListener(k);
    }

    protected KeyListener getKeyListener(AWTKeyStroke k) {
        KeyListener rc = (KeyListener)this.keyListeners.get(k);
        if (rc == null) {
            DefaultScene[] sc = this.scenes;
            for (int c = 0; c < sc.length && (rc = sc[c].getKeyListener(k)) == null; ++c) {
            }
        }
        return rc;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        if (this.running) {
            throw new Exception("Engine already started.");
        }
        try {
            SceneRunner srun;
            this.running = true;
            this.signal = 0;
            this.engineStateChanged(1);
            this.sceneRunner = srun = new SceneRunner();
            Thread sthread = new Thread(srun);
            sthread.start();
            Thread.sleep(50L);
            Clock clk = this.getClock();
            clk.reset();
            long ms1 = clk.millis();
            this.delta = 0L;
            this.fpsIndex = 0;
            this.fpsTotal = 0L;
            Arrays.fill(this.fpsMs, 0L);
            while (true) {
                byte sign;
                if ((sign = this.signal) != 0) {
                    if (sign == 2) {
                        break;
                    }
                    if (sign == 1) {
                        DefaultEngine defaultEngine = this;
                        synchronized (defaultEngine) {
                            this.paused = true;
                            logger.info("Engine paused.");
                            this.engineStateChanged(2);
                            this.wait();
                            logger.info("Engine resume..");
                            this.paused = false;
                            this.engineStateChanged(1);
                            ms1 = clk.millis();
                        }
                    }
                }
                Surface[] su = this.surfaces;
                for (int c = 0; c < su.length; ++c) {
                    su[c].render();
                }
                long ms2 = clk.millis();
                this.delta = ms2 - ms1;
                ms1 = ms2;
                this.fpsTotal += this.delta - this.fpsMs[this.fpsIndex];
                this.fpsMs[this.fpsIndex] = this.delta;
                if (++this.fpsIndex >= this.fpsMs.length) {
                    this.fpsIndex = 0;
                }
                if (this.delta > this.maxFrameMillis) {
                    this.debug("!! Engine hangs: frame=#" + this.frames + " => delta=" + this.delta + " > " + this.maxFrameMillis + " ms.");
                    this.delta = this.maxFrameMillis;
                }
                this.ms += this.delta;
                ++this.frames;
                if (this.reset) {
                    this.reset = false;
                    this.reinitializeSurfaces();
                    clk.reset();
                    ms1 = clk.millis();
                }
                Thread.yield();
            }
        }
        finally {
            this.running = false;
            this.engineStateChanged(0);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("===============================");
                logger.fine("Engine stopped.");
                logger.fine("===============================");
                logger.fine("  Current FPS:  " + (int)this.getFPS());
                long totalMillis = this.getMillis();
                long totalFrames = this.getFrames();
                logger.fine("  Total millis: " + totalMillis);
                logger.fine("  Total frames: " + totalFrames);
                double totalFPS = DefaultEngine.framesPerSecond(totalFrames, totalMillis);
                logger.fine("  Total FPS:    " + (int)totalFPS);
                logger.fine("===============================");
                for (int c = 0; c < this.surfaces.length; ++c) {
                    if (!(this.surfaces[c] instanceof DefaultSurface)) continue;
                    ((DefaultSurface)this.surfaces[c]).dump(logger, Level.FINE);
                }
            }
        }
    }

    @Override
    public void stop() {
        if (this.signal < 2) {
            this.signal = (byte)2;
        }
    }

    @Override
    public void pause() {
        logger.fine("PAUSE!");
        if (this.signal < 1) {
            this.signal = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        logger.fine("RESUME: " + this.paused + " && " + this.signal);
        if (this.paused) {
            Object object = this;
            synchronized (object) {
                this.signal = 0;
                this.notify();
            }
            if (this.sceneRunner != null) {
                object = this.sceneRunner;
                synchronized (object) {
                    this.sceneRunner.notify();
                }
            }
        }
    }

    @Override
    public long getMillis() {
        return this.ms;
    }

    @Override
    public int getSceneCount() {
        return this.scenes.length;
    }

    @Override
    public float getFPS() {
        return this.fpsTotal < 1L ? 0.0f : this.fpsFactor / (float)this.fpsTotal;
    }

    @Override
    public long getFrames() {
        return this.frames;
    }

    public static final double framesPerSecond(long frames, long millis) {
        return (double)frames * 1000.0 / (double)millis;
    }

    protected void reinitializeSurfaces() {
        Surface[] sf = this.surfaces;
        for (int c = 0; c < sf.length; ++c) {
            sf[c].initialize();
        }
    }

    public Clock getClock() {
        return this.clock;
    }

    protected void setClock(Clock clock) {
        this.clock = clock;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    protected void setPaused(boolean paused) {
        this.paused = paused;
    }

    public long getMaxFrameMillis() {
        return this.maxFrameMillis;
    }

    public void setMaxFrameMillis(long maxFrameMillis) {
        this.maxFrameMillis = maxFrameMillis;
    }

    protected void debug(String s) {
        logger.fine(s);
    }

    @Override
    public void reset() {
        if (this.running) {
            throw new RuntimeException("Engine already running!");
        }
        this.ms = 0L;
        this.frames = 0L;
    }

    @Override
    public void addEngineListener(EngineListener l) {
        if (this.engineListeners.contains(l)) {
            return;
        }
        this.engineListeners.add(l);
    }

    @Override
    public void removeEngineListener(EngineListener l) {
        this.engineListeners.remove(l);
    }

    protected void engineStateChanged(int newState) {
        for (EngineListener l : this.engineListeners) {
            l.engineStateChanged(this, newState);
        }
    }

    protected class SceneRunner
    implements Runnable {
        protected SceneRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long f = 0L;
                block6: while (true) {
                    byte sign;
                    if ((sign = DefaultEngine.this.signal) != 0) {
                        if (sign == 2) break;
                        if (sign == 1) {
                            SceneRunner sceneRunner = this;
                            synchronized (sceneRunner) {
                                this.wait();
                            }
                        }
                    }
                    if (f != DefaultEngine.this.frames) {
                        f = DefaultEngine.this.frames;
                        DefaultScene[] sc = DefaultEngine.this.scenes;
                        int c = 0;
                        while (true) {
                            if (c >= sc.length) continue block6;
                            sc[c].invoke(DefaultEngine.this.delta);
                            ++c;
                        }
                    }
                    Thread.yield();
                }
            }
            catch (EndOfSceneException e) {
                logger.log(Level.INFO, e.getMessage(), e);
                DefaultEngine.this.stop();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                DefaultEngine.this.stop();
            }
        }
    }

    protected class SurfaceRefreshKeyListener
    extends KeyAdapter {
        protected SurfaceRefreshKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if ((ev.getModifiers() & 2) != 0 && (ev.getModifiers() & 8) != 0) {
                DefaultEngine.this.reset = true;
            }
        }
    }

    protected class EnginePauseKeyListener
    extends KeyAdapter {
        protected EnginePauseKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (!DefaultEngine.this.paused) {
                DefaultEngine.this.pause();
            } else {
                DefaultEngine.this.resume();
            }
        }
    }

    protected class EngineStopKeyListener
    extends KeyAdapter {
        protected EngineStopKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            DefaultEngine.this.stop();
            if (DefaultEngine.this.paused) {
                DefaultEngine.this.resume();
            }
        }
    }

    protected class SystemExitKeyListener
    extends KeyAdapter {
        protected SystemExitKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if ((ev.getModifiers() & 2) != 0 && (ev.getModifiers() & 8) != 0) {
                System.exit(0);
            }
        }
    }

    protected class KeyHandler
    implements KeyListener {
        protected KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            KeyListener l = DefaultEngine.this.getKeyListener(ev.getKeyCode());
            if (l != null) {
                l.keyPressed(ev);
            }
        }

        @Override
        public void keyReleased(KeyEvent ev) {
            KeyListener l = DefaultEngine.this.getKeyListener(ev.getKeyCode());
            if (l != null) {
                l.keyReleased(ev);
            }
        }

        @Override
        public void keyTyped(KeyEvent ev) {
            KeyListener l = DefaultEngine.this.getKeyListener(ev.getKeyCode());
            if (l != null) {
                l.keyTyped(ev);
            }
        }
    }

    protected class WindowHandler
    implements WindowListener {
        protected WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            logger.fine("surface.activated: " + e);
            DefaultEngine.this.reinitializeSurfaces();
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            logger.fine("surface.deactivated: " + e);
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        protected ComponentHandler() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            logger.fine("surface.hidden: " + e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            logger.fine("surface.shown: " + e);
        }
    }
}

