/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.ClockType;
import com.spacekiller.game2d.DefaultSurfaceType;
import com.spacekiller.game2d.Environment;
import com.spacekiller.game2d.InputBinder;
import com.spacekiller.game2d.InputManager;
import com.spacekiller.game2d.InputProvider;
import com.spacekiller.game2d.SurfaceType;
import com.spacekiller.game2d.surface.BeneBlitSurfaceType;
import com.spacekiller.game2d.surface.BeneFlipSurfaceType;
import com.spacekiller.game2d.surface.DefaultBlitSurfaceType;
import com.spacekiller.game2d.surface.DefaultFlipSurfaceType;
import java.awt.DisplayMode;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultEnvironment
implements Environment {
    private static final Logger logger = Logger.getLogger(DefaultEnvironment.class.getName());
    private static final String[] DEFAULT_CLOCK_TYPES = new String[]{"com.spacekiller.game2d.ext.clock.Java15ClockType", "com.spacekiller.game2d.ext.clock.Java3DClockType", "com.spacekiller.game2d.clock.FuzzyClockType", "com.spacekiller.game2d.clock.Java11ClockType"};
    private static final String[] DEFAULT_INPUT_PROVIDERS = new String[]{"com.spacekiller.game2d.ext.jinput.JInputInputProvider", "com.spacekiller.game2d.input.AWTInputProvider"};
    private List<SurfaceType> surfaceTypes = new ArrayList<SurfaceType>();
    private List<ClockType> clockTypes = new ArrayList<ClockType>();
    private List<InputManager> inputManagers = new ArrayList<InputManager>();
    private List<InputBinder> inputBinders = new ArrayList<InputBinder>();

    public DefaultEnvironment() throws Exception {
        this.initEnvironment();
    }

    protected void initEnvironment() throws Exception {
        this.initClockTypes();
        this.initSurfaceTypes();
        this.initInputManagers();
    }

    protected void initInputManagers() throws Exception {
        String[] inputProviders = DEFAULT_INPUT_PROVIDERS;
        for (int c = 0; c < inputProviders.length; ++c) {
            try {
                logger.fine("Loading input provider: " + inputProviders[c]);
                Class<?> inputProviderClass = Class.forName(inputProviders[c]);
                InputProvider inputProvider = (InputProvider)inputProviderClass.newInstance();
                InputManager[] managers = inputProvider.getInputManagers();
                if (managers == null) continue;
                for (int x = 0; x < managers.length; ++x) {
                    try {
                        InputManager manager = managers[x];
                        if (manager == null) continue;
                        logger.finer(" - InputManager: " + manager);
                        if (manager.isSupported()) {
                            logger.fine("InputManager is supported: " + manager);
                            this.addInputManager(manager);
                            logger.info("InputManager registered: " + manager);
                            continue;
                        }
                        logger.fine("InputManager not supported: " + manager);
                        continue;
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                continue;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected void initClockTypes() throws Exception {
        String[] clockTypes = DEFAULT_CLOCK_TYPES;
        for (int c = 0; c < clockTypes.length; ++c) {
            try {
                logger.fine("Loading clock type: " + clockTypes[c]);
                Class<?> clockTypeClass = Class.forName(clockTypes[c]);
                ClockType clockType = (ClockType)clockTypeClass.newInstance();
                if (clockType.isSupported()) {
                    logger.fine("ClockType is supported: " + clockType);
                    this.addClockType(clockType);
                    logger.info("ClockType registered: " + clockType);
                    continue;
                }
                logger.fine("ClockType not supported: " + clockType);
                continue;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected void initSurfaceTypes() throws Exception {
        this.addSurfaceType(new DefaultSurfaceType("default$2", "Default double-buffering (flip or blit)", 2));
        this.addSurfaceType(new DefaultSurfaceType("default$3", "Default triple-buffering (flip or blit)", 3));
        this.addSurfaceType(new DefaultBlitSurfaceType("blit$2", "Default double-blitting", 2));
        this.addSurfaceType(new DefaultBlitSurfaceType("blit$3", "Default triple-blitting", 3));
        this.addSurfaceType(new DefaultFlipSurfaceType("flip$2", "Default double-flipping (fullscreen)", 2));
        this.addSurfaceType(new DefaultFlipSurfaceType("flip$3", "Default triple-flipping (fullscreen)", 3));
        this.addSurfaceType(new BeneBlitSurfaceType("beneBlit$2", "Bene double-blitting", 2));
        this.addSurfaceType(new BeneFlipSurfaceType("beneFlip$2", "Bene double-flipping (fullscreen)", 2));
        this.addSurfaceType(new DefaultSurfaceType("default$1", "Single buffered", 1));
    }

    @Override
    public int getSurfaceTypeCount() {
        return this.surfaceTypes.size();
    }

    @Override
    public SurfaceType getSurfaceTypeAt(int i) {
        return this.surfaceTypes.get(i);
    }

    @Override
    public SurfaceType getSurfaceType(String id) {
        int count = this.getSurfaceTypeCount();
        for (int c = 0; c < count; ++c) {
            if (!id.equals(this.getSurfaceTypeAt(c).getId())) continue;
            return this.getSurfaceTypeAt(c);
        }
        return null;
    }

    public void addSurfaceType(SurfaceType type) {
        this.surfaceTypes.add(type);
    }

    public void removeSurfaceType(SurfaceType type) {
        this.surfaceTypes.remove(type);
    }

    @Override
    public int getClockTypeCount() {
        return this.clockTypes.size();
    }

    @Override
    public ClockType getClockTypeAt(int i) {
        return this.clockTypes.get(i);
    }

    @Override
    public ClockType getClockType(String id) {
        int count = this.getClockTypeCount();
        for (int c = 0; c < count; ++c) {
            if (!id.equals(this.getClockTypeAt(c).getId())) continue;
            return this.getClockTypeAt(c);
        }
        return null;
    }

    public void addClockType(ClockType type) {
        this.clockTypes.add(type);
    }

    public void removeClockType(ClockType type) {
        this.clockTypes.remove(type);
    }

    @Override
    public int getInputManagerCount() {
        return this.inputManagers.size();
    }

    @Override
    public InputManager getInputManagerAt(int i) {
        return this.inputManagers.get(i);
    }

    @Override
    public InputManager getInputManager(String id) {
        int count = this.getInputManagerCount();
        for (int c = 0; c < count; ++c) {
            if (!id.equals(this.getInputManagerAt(c).getId())) continue;
            return this.getInputManagerAt(c);
        }
        return null;
    }

    public void addInputManager(InputManager im) {
        this.inputManagers.add(im);
    }

    public void removeInputManager(InputManager im) {
        this.inputManagers.remove(im);
    }

    @Override
    public InputBinder getInputBinder(String id) {
        for (int c = 0; c < this.inputBinders.size(); ++c) {
            InputBinder m = this.getInputBinderAt(c);
            if (!id.equals(m.getId())) continue;
            return m;
        }
        return null;
    }

    @Override
    public InputBinder getInputBinderAt(int i) {
        return this.inputBinders.get(i);
    }

    @Override
    public int getInputBinderCount() {
        return this.inputBinders.size();
    }

    public void addInputBinder(InputBinder ib) {
        this.inputBinders.add(ib);
    }

    public void removeInputBinder(InputBinder ib) {
        this.inputBinders.remove(ib);
    }

    public String getDisplayModeId(DisplayMode mode) {
        return "" + mode.getWidth() + ", " + mode.getHeight() + ", " + mode.getBitDepth() + ", " + mode.getRefreshRate();
    }
}

