/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.ActorList;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.Scene;
import com.spacekiller.game2d.config.PersistenceManager;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioPlayer;
import com.spacekiller.game2d.sound.PooledAudioClip;
import java.awt.AWTKeyStroke;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.Clip;

public class DefaultScene
implements Scene {
    private String name;
    private ResourceRegistry registry;
    private PersistenceManager persistenceManager;
    private long ms = 0L;
    private ActorList actors = new ActorList();
    private Map keyListeners = new HashMap();
    private boolean paused = false;
    protected boolean audioEnabled = true;
    private AudioPlayer audioPlayer;
    private AudioBufferPool audioBufferPool;
    protected MediaTracker mediaTracker = new MediaTracker(new Panel());
    protected Set enabledEffects = new HashSet();

    protected DefaultScene() {
    }

    public DefaultScene(ResourceRegistry r) {
        this();
        this.setActors(new ActorList());
        this.setRegistry(r);
    }

    @Override
    public void addActor(Actor a) {
        if (a != null) {
            this.actors.add(a);
        }
    }

    @Override
    public int getActorCount() {
        return this.actors.size();
    }

    @Override
    public void removeActor(Actor a) {
        if (a != null) {
            this.actors.remove(a);
        }
    }

    public void invoke(long m) {
        this.ms += m;
        this.actors.invoke(m);
    }

    @Override
    public ResourceRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ResourceRegistry registry) {
        this.registry = registry;
    }

    protected ActorList getActors() {
        return this.actors;
    }

    protected void setActors(ActorList loop) {
        this.actors = loop;
    }

    @Override
    public void addKeyListener(int keyCode, KeyListener l) {
        AWTKeyStroke k = AWTKeyStroke.getAWTKeyStroke(keyCode, 0);
        this.keyListeners.put(k, l);
    }

    @Override
    public void removeKeyListener(int keyCode, KeyListener l) {
        AWTKeyStroke k = AWTKeyStroke.getAWTKeyStroke(keyCode, 0);
        if (this.keyListeners.get(k) == l) {
            this.keyListeners.remove(k);
        }
    }

    public KeyListener getKeyListener(int keyCode) {
        AWTKeyStroke k = AWTKeyStroke.getAWTKeyStroke(keyCode, 0);
        return this.getKeyListener(k);
    }

    public KeyListener getKeyListener(AWTKeyStroke k) {
        return (KeyListener)this.keyListeners.get(k);
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean b) {
        this.paused = b;
    }

    @Override
    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public void setAudioEnabled(boolean b) {
        this.audioEnabled = b;
    }

    @Override
    public void playAudioClip(Clip clip, Element el) {
        if (this.audioEnabled) {
            clip.setFramePosition(0);
            clip.start();
        }
    }

    protected Clip loadAudioClip(URL url) throws Exception {
        return new PooledAudioClip(url);
    }

    protected Image loadImage(URL url) throws Exception {
        Image image = Toolkit.getDefaultToolkit().createImage(url);
        this.mediaTracker.addImage(image, 0);
        this.mediaTracker.waitForID(0);
        this.mediaTracker.removeImage(image, 0);
        return image;
    }

    protected Image getScaledImage(Image source, int width, int height, int hints) throws Exception {
        Image scaled = source.getScaledInstance(width, height, hints);
        this.mediaTracker.addImage(scaled, 0);
        this.mediaTracker.waitForID(0);
        this.mediaTracker.removeImage(scaled, 0);
        return scaled;
    }

    @Override
    public long getMillis() {
        return this.ms;
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public void setPersistenceManager(PersistenceManager manager) {
        this.persistenceManager = manager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    public void setAudioPlayer(AudioPlayer player) {
        this.audioPlayer = player;
    }

    @Override
    public boolean isEffectEnabled(Object effect) {
        return this.enabledEffects.contains(effect);
    }

    public void setEffectEnabled(Object effect, boolean on) {
        if (on) {
            this.enabledEffects.add(effect);
        } else {
            this.enabledEffects.remove(effect);
        }
    }

    @Override
    public void dumpActors(PrintStream out) {
        out.println("--------------- Actors: " + this.actors.size() + " ---------------");
        Iterator i = this.actors.iterator();
        while (i.hasNext()) {
            out.println(" - " + i.next());
        }
        out.println("-----------------------------------------");
    }

    @Override
    public void dumpView(PrintStream out) {
    }

    public AudioBufferPool getAudioBufferPool() {
        return this.audioBufferPool;
    }

    public void setAudioBufferPool(AudioBufferPool audioBufferPool) {
        this.audioBufferPool = audioBufferPool;
    }
}

