/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Engine;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.View;
import com.spacekiller.game2d.util.ImageToolkit;
import com.spacekiller.util.swing.FullscreenSupport;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class DefaultSurface
implements Surface {
    private long msRender = 0L;
    private long msPaint = 0L;
    private long msShow = 0L;
    protected Window window;
    protected FullscreenSupport fullscreenSupport;
    protected boolean active;
    protected Engine engine;
    protected WindowHandler windowHandler = new WindowHandler();
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected BufferStrategy buffer;
    protected List views = new ArrayList();
    protected int viewCount = 0;

    public DefaultSurface(Window w) throws Exception {
        this.setWindow(w);
        this.active = true;
    }

    protected void initSurface() {
        Container component = ((JFrame)this.window).getContentPane();
        System.out.println("ContentPage: " + component);
        Point p1 = this.window.getLocationOnScreen();
        Point p2 = component.getLocationOnScreen();
        if (p1 != null && p2 != null) {
            this.x = p2.x - p1.x;
            this.y = p2.y - p1.y;
        } else {
            this.x = 0;
            this.y = 0;
        }
        this.width = component.getWidth();
        this.height = component.getHeight();
        System.out.println("Surface bounds: " + this.x + ", " + this.y + ", " + this.width + ", " + this.height);
        this.buffer = this.window.getBufferStrategy();
        System.out.println("initSurface -> BufferStrategy: " + this.buffer);
        System.out.println("Page-Flip: " + this.buffer.getCapabilities().getFlipContents());
    }

    @Override
    public void render() {
        if (!this.active) {
            return;
        }
        if (this.buffer.contentsLost()) {
            System.err.println("" + this + ".render: buffer.contentsLost!!");
        }
        Graphics g = this.buffer.getDrawGraphics();
        int sx = this.x;
        int sy = this.y;
        g.translate(sx, sy);
        long ms1 = System.currentTimeMillis();
        for (int c = 0; c < this.viewCount; ++c) {
            View v = (View)this.views.get(c);
            int vx = v.getX();
            int vy = v.getY();
            g.setClip(vx, vy, v.getWidth(), v.getHeight());
            g.translate(vx, vy);
            long msp = -System.currentTimeMillis();
            v.paint(g);
            this.msPaint += (msp += System.currentTimeMillis());
            g.translate(-vx, -vy);
        }
        long ms2 = System.currentTimeMillis();
        this.buffer.show();
        long ms3 = System.currentTimeMillis();
        this.msRender += ms2 - ms1;
        this.msShow += ms3 - ms2;
        g.translate(-sx, -sy);
    }

    @Override
    public void initialize() {
        this.initSurface();
    }

    @Override
    public void addView(View v) {
        if (!this.views.contains(v)) {
            this.views.add(v);
            ++this.viewCount;
        }
    }

    @Override
    public View getViewAt(int i) {
        return (View)this.views.get(i);
    }

    @Override
    public int getViewCount() {
        return this.viewCount;
    }

    @Override
    public void insertViewAt(View v, int i) {
        if (!this.views.contains(v)) {
            this.views.add(i, v);
            ++this.viewCount;
        }
    }

    @Override
    public void removeView(View v) {
        if (this.views.contains(v)) {
            --this.viewCount;
            this.views.remove(v);
        }
    }

    @Override
    public void removeViewAt(int i) {
        if (i >= 0 && i < this.viewCount) {
            this.views.remove(i);
            --this.viewCount;
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    protected void setHeight(int i) {
        this.height = i;
    }

    protected void setWidth(int i) {
        this.width = i;
    }

    @Override
    public Window getWindow() {
        return this.window;
    }

    protected void setWindow(Window w) {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowHandler);
        }
        this.window = w;
        this.fullscreenSupport = w instanceof Frame ? new FullscreenSupport((Frame)w) : null;
        if (this.window != null) {
            this.window.addWindowListener(this.windowHandler);
        }
    }

    public void show(String surfaceMode, GraphicsDevice displayDevice, DisplayMode displayMode) throws Exception {
        FullscreenSupport full;
        boolean windowMode = false;
        boolean exclusiveMode = false;
        if ("window".equals(surfaceMode)) {
            windowMode = true;
        }
        if ("exclusive".equals(surfaceMode)) {
            exclusiveMode = true;
        }
        if (!windowMode && (full = this.fullscreenSupport) != null && full.isFullscreenEnabled()) {
            try {
                full.setExclusiveMode(exclusiveMode);
                full.setDisplayDevice(displayDevice);
                full.setDisplayMode(displayMode);
                full.setWindowFullscreen(true);
                this.window.setIgnoreRepaint(true);
                return;
            }
            catch (Throwable e) {
                full = null;
                e.printStackTrace();
            }
        }
        this.window.dispose();
        this.window.setVisible(false);
        if (this.window instanceof Frame) {
            ((Frame)this.window).setUndecorated(false);
        }
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setUndecorated(false);
        }
        this.window.setIgnoreRepaint(false);
        this.window.setVisible(true);
    }

    @Override
    public void dispose() {
        try {
            if (this.window != null && this.window.isVisible()) {
                FullscreenSupport full = this.fullscreenSupport;
                if (full != null) {
                    full.setWindowFullscreen(false);
                }
                this.window.dispose();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void dump(Logger logger, Level level) {
        logger.log(level, "-> Dump: " + this);
        logger.log(level, "-> Buffer-Render millis:  " + this.msRender);
        logger.log(level, " +-> Paint millis:        " + this.msPaint);
        logger.log(level, "-> Buffer-Show millis:    " + this.msShow);
        int vcount = this.views.size();
        logger.log(level, "--------- Views: " + vcount + " ----------");
        for (int c = 0; c < vcount; ++c) {
            View v = (View)this.views.get(c);
            logger.log(level, " - " + v);
            v.dump(logger, level);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int i) {
        this.x = i;
    }

    public void setY(int i) {
        this.y = i;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.getWindow().setCursor(cursor);
    }

    @Override
    public void setInvisibleCursor() throws Exception {
        Cursor invisibleCursor = ImageToolkit.getInstance().createInvisibleCursor();
        if (invisibleCursor != null) {
            this.setCursor(invisibleCursor);
        }
    }

    @Override
    public void removeAllViews() {
        this.views.clear();
        this.viewCount = 0;
    }

    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.window.getFontMetrics(font);
    }

    protected class WindowHandler
    extends WindowAdapter {
        protected WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (DefaultSurface.this.engine != null && !DefaultSurface.this.active) {
                if (DefaultSurface.this.engine.isPaused()) {
                    DefaultSurface.this.engine.resume();
                }
                DefaultSurface.this.render();
                DefaultSurface.this.active = true;
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            if (DefaultSurface.this.engine != null) {
                DefaultSurface.this.engine.pause();
            }
            DefaultSurface.this.active = false;
        }
    }
}

