/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.DefaultSurface;

public class DefaultSurfaceRumbler
extends Actor {
    private DefaultSurface surface;
    private int duration;
    private int normalX;
    private int normalY;
    private int intensity;
    private int elapsed;

    public DefaultSurfaceRumbler(DefaultSurface surface, int intensity, int duration) {
        this.setSurface(surface);
        this.setIntensity(intensity);
        this.setDuration(duration);
    }

    @Override
    public void invoke(long ms) {
        this.elapsed = (int)((long)this.elapsed + ms);
        if (this.elapsed >= this.duration) {
            this.surface.x = this.normalX;
            this.surface.y = this.normalY;
            this.elapsed = 0;
            this.dispose();
            return;
        }
        this.surface.x = (int)((Math.random() - 0.5) * (double)this.intensity);
        this.surface.y = (int)((Math.random() - 0.5) * (double)this.intensity);
    }

    public DefaultSurface getSurface() {
        return this.surface;
    }

    public void setSurface(DefaultSurface surface) {
        this.surface = surface;
        if (surface != null) {
            this.normalX = surface.getX();
            this.normalY = surface.getY();
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getIntensity() {
        return this.intensity;
    }

    public void setIntensity(int intensity) {
        this.intensity = intensity;
    }
}

