/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.DefaultSurface;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.SurfaceType;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferStrategy;
import javax.swing.JFrame;

public class DefaultSurfaceType
implements SurfaceType {
    private String id;
    private String name;
    private int bufferCount = 2;

    protected DefaultSurfaceType() {
    }

    public DefaultSurfaceType(String id, String name, int bufferCount) {
        this.setId(id);
        this.setName(name);
        this.setBufferCount(bufferCount);
    }

    protected JFrame createFrame() throws Exception {
        JFrame frame = new JFrame();
        return frame;
    }

    protected void initFrame(JFrame frame, String title, Image iconImage) throws Exception {
        frame.setTitle(title);
        frame.setIconImage(iconImage);
        frame.setResizable(false);
        frame.setDefaultCloseOperation(0);
    }

    protected void initBufferStrategy(Window w) throws Exception {
        JFrame frame = (JFrame)w;
        frame.createBufferStrategy(this.bufferCount);
    }

    protected DefaultSurface createSurface(Window w) throws Exception {
        return new DefaultSurface(w);
    }

    @Override
    public Surface createSurface(String title, Image iconImage, String surfaceMode, GraphicsDevice displayDevice, DisplayMode displayMode, Rectangle windowBounds) throws Exception {
        DisplayMode oldMode;
        System.out.println("Creating surface: " + this);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        System.out.println(" - GraphicsEnvironment: " + env);
        GraphicsDevice dev = displayDevice;
        if (dev == null) {
            dev = env.getDefaultScreenDevice();
        }
        System.out.println(" - GraphicsDevice: " + dev);
        GraphicsConfiguration cfg = dev.getDefaultConfiguration();
        System.out.println(" - GraphicsConfiguration: " + cfg);
        JFrame frame = this.createFrame();
        this.initFrame(frame, title, iconImage);
        if (windowBounds == null) {
            windowBounds = cfg.getBounds();
        }
        if (windowBounds != null) {
            frame.setBounds(windowBounds);
        }
        DefaultSurface surface = this.createSurface(frame);
        if (displayMode != null && (oldMode = dev.getDisplayMode()) != null && oldMode.equals(displayMode)) {
            displayMode = null;
        }
        surface.show(surfaceMode, displayDevice, displayMode);
        this.initBufferStrategy(frame);
        BufferStrategy buffer = frame.getBufferStrategy();
        System.out.println(" - BufferStrategy: " + buffer);
        return surface;
    }

    public String toString() {
        return String.valueOf(this.getName());
    }

    public int getBufferCount() {
        return this.bufferCount;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setBufferCount(int i) {
        this.bufferCount = i;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }
}

