/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.Rect;
import com.spacekiller.game2d.Renderer;

public class Element
extends Rect
implements Cloneable {
    transient ElementModel model;
    transient Element prev;
    transient Element next;
    transient double z;
    protected Object id;
    protected ElementType type;
    protected Renderer renderer;
    protected CollisionBounds collisionBounds;
    protected CollisionGroup collisionGroup;

    protected Element() {
    }

    protected Element(double x, double y, double w, double h) {
        super(x, y, w, h);
    }

    public Element(Object id, double x, double y, double w, double h, ElementType t, Renderer r) {
        this(x, y, w, h);
        this.setId(id);
        this.setType(t);
        this.setRenderer(r);
    }

    protected void dispose() {
        if (this.model != null) {
            this.model.remove(this);
        }
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public final ElementModel getModel() {
        return this.model;
    }

    void setModel(ElementModel model) {
        this.model = model;
    }

    public CollisionBounds getCollisionBounds() {
        return this.collisionBounds;
    }

    public void setCollisionBounds(CollisionBounds bounds) {
        this.collisionBounds = bounds;
    }

    public final double getZ() {
        return this.z;
    }

    void setZ(double d) {
        this.z = d;
    }

    @Override
    public String toString() {
        return "" + this.getClass().getName() + "[bounds=" + this.getX() + "," + this.getY() + "," + this.getWidth() + "," + this.getHeight() + "]";
    }

    public Object getId() {
        return this.id;
    }

    public ElementType getType() {
        return this.type;
    }

    public void setId(Object i) {
        this.id = i;
    }

    public void setType(ElementType type) {
        this.type = type;
    }

    public Element cloneElement() throws Exception {
        Element clone = (Element)this.cloneRect();
        clone.model = null;
        clone.prev = null;
        clone.next = null;
        clone.z = 0.0;
        return clone;
    }

    public CollisionGroup getCollisionGroup() {
        return this.collisionGroup;
    }

    public void setCollisionGroup(CollisionGroup group) {
        this.collisionGroup = group;
    }

    @Override
    protected void collisionAdded(Rect r) {
        Element el;
        if (this.collisionGroup != null && r instanceof Element && (el = (Element)r) != null) {
            this.collisionGroup.handleCollision(this, el);
        }
    }

    @Override
    protected void collisionRemoved(Rect r) {
    }
}

