/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementListener;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.GridMap;
import com.spacekiller.game2d.Model;
import com.spacekiller.game2d.Rect;
import com.spacekiller.game2d.Sensor;
import com.spacekiller.game2d.View;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class ElementModel
implements Model {
    private static final double MIN_Z = -1.0E9;
    private static final double MAX_Z = 1.0E9;
    private Element first = null;
    private Element last = null;
    private int size = 0;
    private GridMap map;
    private List views = new ArrayList();
    private List sensors = new ArrayList();
    private EventListenerList elementListeners = new EventListenerList();
    private Map elementProperties = new HashMap();

    public ElementModel(double cellWidth, double cellHeight, int gridColumns, int gridRows) {
        this.setMap(this.createMap(cellWidth, cellHeight, gridColumns, gridRows));
    }

    public int getElementCount() {
        return this.size;
    }

    protected Element first() {
        return this.first;
    }

    protected Element last() {
        return this.last;
    }

    protected Element next(Element e) {
        return e.next;
    }

    protected Element prev(Element e) {
        return e.prev;
    }

    @Override
    public View getViewAt(int i) {
        return (View)this.views.get(i);
    }

    @Override
    public int getViewCount() {
        return this.views.size();
    }

    @Override
    public Iterator getViews() {
        return this.views.iterator();
    }

    public boolean add(Element e) {
        return this.insert(e, this.last);
    }

    public boolean add(Element e, double x, double y, double z) {
        if (e.model != null) {
            return false;
        }
        e.x = x;
        e.y = y;
        e.z = z;
        Element prev = this.last;
        if (prev == null) {
            e.next = this.first;
            this.first = e;
            if (this.last == null) {
                this.last = e;
            }
        } else {
            if (prev.model != this) {
                return false;
            }
            e.prev = prev;
            e.next = prev.next;
            if (e.next == null) {
                this.last = e;
            } else {
                e.next.prev = e;
            }
            prev.next = e;
        }
        e.model = this;
        ++this.size;
        this.map.add(e);
        this.fireElementAdded(e);
        return true;
    }

    public boolean insert(Element e, Element prev) {
        if (e.model != null) {
            return false;
        }
        if (prev == null) {
            e.next = this.first;
            double d = e.z = this.first == null ? 0.0 : this.first.z - 1.0;
            if (e.z < -1.0E9) {
                throw new RuntimeException("TODO: optimize z-order: " + (int)e.z + "<" + -1000000000);
            }
            this.first = e;
            if (this.last == null) {
                this.last = e;
            }
        } else {
            if (prev.model != this) {
                return false;
            }
            e.prev = prev;
            e.next = prev.next;
            if (e.next == null) {
                this.last = e;
                e.z = prev.z + 1.0;
                if (e.z > 1.0E9) {
                    throw new RuntimeException("TODO: optimize z-order: " + (int)e.z + ">" + 1000000000);
                }
            } else {
                e.next.prev = e;
                e.z = (prev.z + e.next.z) / 2.0;
                if (e.z == prev.z) {
                    throw new RuntimeException("TODO: optimize z-order: " + (int)e.z + "==" + (int)prev.z);
                }
            }
            prev.next = e;
        }
        e.model = this;
        ++this.size;
        this.map.add(e);
        this.fireElementAdded(e);
        return true;
    }

    public boolean remove(Element e) {
        if (e.model != this) {
            return false;
        }
        this.map.remove(e);
        if (e.prev == null) {
            if (e == this.first) {
                this.first = e.next;
            }
        } else {
            e.prev.next = e.next;
        }
        if (e.next == null) {
            if (e == this.last) {
                this.last = e.prev;
            }
        } else {
            e.next.prev = e.prev;
        }
        --this.size;
        e.model = null;
        e.prev = null;
        e.next = null;
        this.fireElementRemoved(e);
        return true;
    }

    public void update(Element e, double x, double y, double w, double h) {
        this.map.update(e, x, y, w, h);
    }

    public void moveTo(Element e, double x, double y) {
        this.map.moveTo(e, x, y);
    }

    public void moveBy(Element e, double x, double y) {
        this.map.moveBy(e, x, y);
    }

    protected GridMap createMap(double cellWidth, double cellHeight, int gridColumns, int gridRows) {
        return new GridMap(cellWidth, cellHeight, gridColumns, gridRows);
    }

    protected final GridMap getMap() {
        return this.map;
    }

    private void setMap(GridMap map) {
        this.map = map;
    }

    public int getMapColumns() {
        return this.map.getColumns();
    }

    public int getMapRows() {
        return this.map.getRows();
    }

    public double getMapCellWidth() {
        return this.map.getCellWidth();
    }

    public double getMapCellHeight() {
        return this.map.getCellHeight();
    }

    @Override
    public View createView(double x, double y, double w, double h) {
        ElementView v = new ElementView(this);
        this.views.add(v);
        Rect viewRect = v.getViewRect();
        this.map.add(viewRect, x, y, w, h);
        System.out.println("View created: " + v + ", " + viewRect + ", coll=" + viewRect.getCollisionCount());
        System.out.println("Model elements: " + this.size);
        return v;
    }

    @Override
    public void updateView(View v, double x, double y, double w, double h) {
        this.map.update(((ElementView)v).getViewRect(), x, y, w, h);
    }

    @Override
    public void removeView(View v) {
        if (this.views.contains(v)) {
            this.map.remove(((ElementView)v).getViewRect());
            this.views.remove(v);
        }
    }

    public Iterator getElements() {
        return new ElementIterator();
    }

    public void getElements(Collection dst) {
        Iterator i = this.getElements();
        while (i.hasNext()) {
            dst.add(i.next());
        }
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getBounds(new Rectangle2D.Double());
    }

    @Override
    public Rectangle2D getBounds(Rectangle2D dst) {
        dst.setRect(0.0, 0.0, this.map.getWidth(), this.map.getHeight());
        return dst;
    }

    public void addElementListener(ElementListener l) {
        this.elementListeners.add(ElementListener.class, l);
    }

    public void removeElementListener(ElementListener l) {
        this.elementListeners.remove(ElementListener.class, l);
    }

    protected void fireElementAdded(Element e) {
        Object[] l = this.elementListeners.getListenerList();
        for (int c = 1; c < l.length; c += 2) {
            ((ElementListener)l[c]).elementAdded(e);
        }
    }

    protected void fireElementRemoved(Element e) {
        Object[] l = this.elementListeners.getListenerList();
        for (int c = 1; c < l.length; c += 2) {
            ((ElementListener)l[c]).elementRemoved(e);
        }
    }

    public synchronized void resizeMap(int newCols, int newRows, double cellWidth, double cellHeight) {
        GridMap oldMap = this.getMap();
        GridMap newMap = this.createMap(cellWidth, cellHeight, newCols, newRows);
        Element el = this.first();
        while (el != null) {
            oldMap.remove(el);
            newMap.add(el);
            el = this.next(el);
        }
        Iterator i = this.getViews();
        while (i.hasNext()) {
            ElementView v = (ElementView)i.next();
            Rect vr = v.getViewRect();
            if (vr == null) continue;
            oldMap.remove(vr);
            newMap.add(vr);
        }
        i = this.getSensors();
        while (i.hasNext()) {
            Sensor s = (Sensor)i.next();
            oldMap.remove(s);
            newMap.add(s);
        }
        this.setMap(newMap);
    }

    public synchronized void scaleElementPositions(double factorX, double factorY) {
        GridMap map = this.getMap();
        Element el = this.first();
        while (el != null) {
            double x = el.getX() * factorX;
            double y = el.getY() * factorY;
            map.moveTo(el, x, y);
            el = this.next(el);
        }
        Iterator i = this.getSensors();
        while (i.hasNext()) {
            Sensor s = (Sensor)i.next();
            double x = s.getX() * factorX;
            double y = s.getY() * factorY;
            map.moveTo(s, x, y);
        }
    }

    public void checkConsistency() throws Exception {
        this.map.checkConsistency();
    }

    public void checkRectConsistency(Rect r) throws Exception {
        this.map.checkRectConsistency(r);
    }

    public boolean add(Sensor s) {
        if (s.model != null) {
            return false;
        }
        s.model = this;
        this.sensors.add(s);
        this.map.add(s);
        return true;
    }

    public boolean remove(Sensor s) {
        if (s.model != this) {
            return false;
        }
        this.map.remove(s);
        this.sensors.remove(s);
        s.model = null;
        return true;
    }

    public void update(Sensor s, double x, double y, double w, double h) {
        this.map.update(s, x, y, w, h);
    }

    public int getSensorCount() {
        return this.sensors.size();
    }

    public Sensor getSensorAt(int i) {
        return (Sensor)this.sensors.get(i);
    }

    public Iterator getSensors() {
        return this.sensors.iterator();
    }

    public static void resetElement(Element el, double x, double y, double w, double h) {
        if (el.model != null) {
            throw new RuntimeException("Cannot reset an element which is already part of a model: " + el);
        }
        GridMap.resetRect(el, x, y, w, h);
    }

    public Map getElementProperties(Element el) {
        return (Map)this.elementProperties.get(el);
    }

    public void setElementProperties(Element el, Map props) {
        if (props == null) {
            this.elementProperties.remove(el);
        } else {
            this.elementProperties.put(el, props);
        }
    }

    public void clearElementProperties() {
        this.elementProperties.clear();
    }

    public void moveZ(Element e, double z) {
        e.setZ(z);
    }

    protected class ElementIterator
    implements Iterator {
        private Element next;

        public ElementIterator() {
            this.next = ElementModel.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Element rc = this.next;
            this.next = this.next.next;
            return rc;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

