/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.AbstractView;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementListener;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.PositionTreeMap;
import com.spacekiller.game2d.Rect;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.Sensor;
import com.spacekiller.game2d.SensorListener;
import com.spacekiller.game2d.View;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class ElementView
extends AbstractView {
    private ElementModel model;
    private ViewRect viewRect;
    private EventListenerList elementListeners;
    private EventListenerList sensorListeners;
    private PositionTreeMap zMap;
    private PositionTreeMap.Iter zi;
    private int zmod;
    private Element[] ze = new Element[32];
    private int zn;

    protected ElementView(ElementModel m) {
        this.zMap = new PositionTreeMap();
        this.zi = this.zMap.iter();
        this.elementListeners = new EventListenerList();
        this.sensorListeners = new EventListenerList();
        this.setModel(m);
        this.setViewRect(this.createViewRect());
    }

    protected ViewRect createViewRect() {
        return new ViewRect();
    }

    @Override
    public synchronized void paint(Graphics g) {
        double vx = this.viewRect.getX();
        double vy = this.viewRect.getY();
        int tx = 0;
        int ty = 0;
        int ix = 0;
        int iy = 0;
        if (this.zmod == 0) {
            for (int i = 0; i < this.zn; ++i) {
                Element el = this.ze[i];
                Renderer rr = el.getRenderer();
                if (rr == null) continue;
                ix = (int)(el.getX() - vx);
                iy = (int)(el.getY() - vy);
                g.translate(ix - tx, iy - ty);
                tx = ix;
                ty = iy;
                rr.paint(el, this, g);
            }
        } else {
            this.zmod = 0;
            if (this.ze.length < this.zMap.size()) {
                this.ze = new Element[this.zMap.size()];
            }
            this.zn = 0;
            this.zi.reset();
            while (this.zi.hasNext()) {
                Element el;
                PositionTreeMap.Entry e = (PositionTreeMap.Entry)this.zi.next();
                this.ze[this.zn] = el = (Element)e.getValue();
                Renderer rr = el.getRenderer();
                if (rr != null) {
                    ix = (int)(el.getX() - vx);
                    iy = (int)(el.getY() - vy);
                    g.translate(ix - tx, iy - ty);
                    tx = ix;
                    ty = iy;
                    rr.paint(el, this, g);
                }
                ++this.zn;
            }
        }
        g.translate(-tx, -ty);
    }

    void paintOld1(Graphics g) {
        int vx = (int)this.viewRect.getX();
        int vy = (int)this.viewRect.getY();
        g.translate(-vx, -vy);
        Iterator i = this.zMap.iterator();
        while (i.hasNext()) {
            PositionTreeMap.Entry e = (PositionTreeMap.Entry)i.next();
            Element el = (Element)e.getValue();
            Renderer rr = el.getRenderer();
            if (rr == null) continue;
            int tx = (int)el.getX();
            int ty = (int)el.getY();
            g.translate(tx, ty);
            rr.paint(el, this, g);
            g.translate(-tx, -ty);
        }
        g.translate(vx, vy);
    }

    public Rect getViewRect() {
        return this.viewRect;
    }

    private void setViewRect(ViewRect rect) {
        this.viewRect = rect;
    }

    public ElementModel getModel() {
        return this.model;
    }

    private void setModel(ElementModel model) {
        this.model = model;
    }

    protected synchronized void addElement(Element e) {
        if (e.model != this.model) {
            return;
        }
        this.zMap.add(e, e.z);
        ++this.zmod;
        this.fireElementAdded(e);
    }

    protected synchronized void removeElement(Element e) {
        this.zMap.remove(e.z, e);
        ++this.zmod;
        this.fireElementRemoved(e);
    }

    protected synchronized void updateElement(Element e, double zOld) {
        this.zMap.remove(zOld, e);
        this.zMap.add(e, e.z);
        ++this.zmod;
    }

    public int getElementCount() {
        return this.zMap.size();
    }

    public void getElements(Collection dst) {
        Iterator i = this.zMap.iterator();
        while (i.hasNext()) {
            PositionTreeMap.Entry e = (PositionTreeMap.Entry)i.next();
            dst.add(e.getValue());
        }
    }

    public void addElementListener(ElementListener l) {
        this.elementListeners.add(ElementListener.class, l);
    }

    public void removeElementListener(ElementListener l) {
        this.elementListeners.remove(ElementListener.class, l);
    }

    protected void fireElementAdded(Element e) {
        Object[] l = this.elementListeners.getListenerList();
        for (int c = 1; c < l.length; c += 2) {
            ((ElementListener)l[c]).elementAdded(e);
        }
    }

    protected void fireElementRemoved(Element e) {
        Object[] l = this.elementListeners.getListenerList();
        for (int c = 1; c < l.length; c += 2) {
            ((ElementListener)l[c]).elementRemoved(e);
        }
    }

    @Override
    public void dump(Logger logger, Level level) {
        super.dump(logger, level);
    }

    public void addSensorListener(SensorListener l) {
        this.sensorListeners.add(SensorListener.class, l);
    }

    public void removeSensorListener(SensorListener l) {
        this.sensorListeners.remove(SensorListener.class, l);
    }

    protected void fireSensorAdded(Sensor s) {
        Object[] l = this.sensorListeners.getListenerList();
        for (int c = 1; c < l.length; c += 2) {
            ((SensorListener)l[c]).sensorAdded(s);
        }
    }

    protected void fireSensorRemoved(Sensor s) {
        Object[] l = this.sensorListeners.getListenerList();
        for (int c = 1; c < l.length; c += 2) {
            ((SensorListener)l[c]).sensorRemoved(s);
        }
    }

    protected void addSensor(Sensor s) {
        if (s.model != this.model) {
            return;
        }
        this.fireSensorAdded(s);
    }

    protected void removeSensor(Sensor s) {
        if (s.model != this.model) {
            return;
        }
        this.fireSensorRemoved(s);
    }

    public void checkConsistency() throws Exception {
        Element el;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        Rect viewRect = this.getViewRect();
        HashSet<Element> viewElements = new HashSet<Element>();
        Iterator i = this.zMap.iterator();
        while (i.hasNext()) {
            PositionTreeMap.Entry entry = (PositionTreeMap.Entry)i.next();
            Object val = entry.getValue();
            el = (Element)val;
            if (!viewRect.intersects(el)) {
                errors.add(new Exception("Invalid element in view: " + el));
            }
            viewElements.add(el);
        }
        i = this.model.getElements();
        while (i.hasNext()) {
            el = (Element)i.next();
            if (!viewRect.intersects(el) || viewElements.contains(el)) continue;
            errors.add(new Exception("Missing element in view: " + el));
        }
        if (!errors.isEmpty()) {
            int num = errors.size();
            System.out.println("ElementView errors: " + num);
            for (int c = 0; c < num; ++c) {
                System.out.println(" - " + errors.get(c));
            }
            throw new Exception("ElementView is inconsistent: " + num + " errors.");
        }
    }

    protected class ViewRect
    extends Rect {
        @Override
        protected void collisionAdded(Rect r) {
            if (r instanceof Element) {
                Element el = (Element)r;
                ElementView.this.addElement(el);
            }
            if (r instanceof Sensor) {
                Sensor s = (Sensor)r;
                ElementView.this.addSensor(s);
            }
        }

        @Override
        protected void collisionRemoved(Rect r) {
            if (r instanceof Element) {
                Element el = (Element)r;
                ElementView.this.removeElement(el);
            }
            if (r instanceof Sensor) {
                Sensor s = (Sensor)r;
                ElementView.this.removeSensor(s);
            }
        }

        public View getView() {
            return ElementView.this;
        }

        @Override
        public String toString() {
            return "ViewRect[" + super.toString() + "]";
        }
    }
}

