/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.Rect;
import com.spacekiller.game2d.RectBoundsException;

public class ElementViewScrollActor
extends Actor {
    private ElementModel elementModel;
    private ElementView elementView;
    private double speedX;
    private double speedY;
    private double viewX;
    private double viewY;
    private double viewW;
    private double viewH;

    public ElementViewScrollActor(ElementModel elementModel, ElementView elementView, double speedX, double speedY) {
        this.elementModel = elementModel;
        this.elementView = elementView;
        this.speedX = speedX;
        this.speedY = speedY;
        Rect rect = elementView.getViewRect();
        this.viewX = rect.getX();
        this.viewY = rect.getY();
        this.viewW = rect.getWidth();
        this.viewH = rect.getHeight();
    }

    @Override
    public void invoke(long ms) {
        try {
            this.viewX += (double)ms * this.speedX;
            this.viewY += (double)ms * this.speedY;
            this.elementModel.updateView(this.elementView, this.viewX, this.viewY, this.viewW, this.viewH);
        }
        catch (RectBoundsException rectBoundsException) {
            // empty catch block
        }
    }

    public double getSpeedX() {
        return this.speedX;
    }

    public void setSpeedX(double speedX) {
        this.speedX = speedX;
    }

    public double getSpeedY() {
        return this.speedY;
    }

    public void setSpeedY(double speedY) {
        this.speedY = speedY;
    }
}

