/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.PositionTreeMap;
import com.spacekiller.game2d.Rect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class GridCell {
    private double x;
    private double y;
    private double x2;
    private double y2;
    private PosTreeMap xMap;
    private PosTreeMap yMap;
    private Collection overlapX;
    private Collection overlapY;
    private Collection coll;

    public GridCell(double x, double y, double x2, double y2, Collection coll) {
        this.x = x;
        this.y = y;
        this.x2 = x2;
        this.y2 = y2;
        this.xMap = new PosTreeMap();
        this.yMap = new PosTreeMap();
        this.overlapX = new ArrayList();
        this.overlapY = new ArrayList();
        this.coll = coll;
    }

    public void addOverlapX(Rect r) {
        if (!this.overlapX.contains(r)) {
            this.overlapX.add(r);
            Iterator i = this.xMap.iterator();
            while (i.hasNext()) {
                PositionTreeMap.Entry e = (PositionTreeMap.Entry)i.next();
                Rect s = (Rect)e.getValue();
                if (!r.intersects(s) || !r.addCollision(s)) continue;
                s.addCollision(r);
                r.collisionAdded(s);
                s.collisionAdded(r);
            }
        }
    }

    public void addOverlapY(Rect r) {
        if (!this.overlapY.contains(r)) {
            this.overlapY.add(r);
            Iterator i = this.yMap.iterator();
            while (i.hasNext()) {
                PositionTreeMap.Entry e = (PositionTreeMap.Entry)i.next();
                Rect s = (Rect)e.getValue();
                if (!r.intersects(s) || !r.addCollision(s)) continue;
                s.addCollision(r);
                r.collisionAdded(s);
                s.collisionAdded(r);
            }
        }
    }

    public void removeOverlapX(Rect r) {
        this.overlapX.remove(r);
    }

    public void removeOverlapY(Rect r) {
        this.overlapY.remove(r);
    }

    public void checkOverlapRects(Rect r) {
        for (Rect n : this.overlapX) {
            if (!r.intersects(n) || !r.addCollision(n)) continue;
            n.addCollision(r);
            r.collisionAdded(n);
            n.collisionAdded(r);
        }
        for (Rect n : this.overlapY) {
            if (!r.intersects(n) || !r.addCollision(n)) continue;
            n.addCollision(r);
            r.collisionAdded(n);
            n.collisionAdded(r);
        }
    }

    public void addX(double x, Object o) {
        this.xMap.add(o, x);
    }

    public void addY(double y, Object o) {
        this.yMap.add(o, y);
    }

    public void add(double x, double y, Object o) {
        this.xMap.add(o, x);
        this.yMap.add(o, y);
    }

    public void moveX(double x, Rect o, double newX) {
        this.xMap.move(x, o, newX);
    }

    public void moveY(double y, Rect o, double newY) {
        this.yMap.move(y, o, newY);
    }

    public void move(double x, double y, Rect o, double newX, double newY) {
        this.xMap.move(x, o, newX);
        this.yMap.move(y, o, newY);
    }

    public void removeX(double x, Object o) {
        this.xMap.remove(x, o);
    }

    public void removeY(double y, Object o) {
        this.yMap.remove(y, o);
    }

    public void remove(double x, double y, Object o) {
        this.xMap.remove(x, o);
        this.yMap.remove(y, o);
    }

    public void checkX(Rect r) {
        Iterator i = this.xMap.iterator();
        while (i.hasNext()) {
            Rect r2;
            PositionTreeMap.Entry e = (PositionTreeMap.Entry)i.next();
            if (!r.intersects((Rect)e.getValue()) || !r.addCollision(r2 = (Rect)e.getValue())) continue;
            r2.addCollision(r);
            r.collisionAdded(r2);
            r2.collisionAdded(r);
        }
    }

    public void checkX(double fromX, double toX, Rect r) {
        Iterator i = this.xMap.iterator(fromX, toX);
        while (i.hasNext()) {
            Rect r2;
            PositionTreeMap.Entry e = (PositionTreeMap.Entry)i.next();
            if (!r.intersects((Rect)e.getValue()) || !r.addCollision(r2 = (Rect)e.getValue())) continue;
            r2.addCollision(r);
            r.collisionAdded(r2);
            r2.collisionAdded(r);
        }
    }

    public void checkY(Rect r) {
        Iterator i = this.yMap.iterator();
        while (i.hasNext()) {
            Rect r2;
            PositionTreeMap.Entry e = (PositionTreeMap.Entry)i.next();
            if (!r.intersects((Rect)e.getValue()) || !r.addCollision(r2 = (Rect)e.getValue())) continue;
            r2.addCollision(r);
            r.collisionAdded(r2);
            r2.collisionAdded(r);
        }
    }

    public void checkY(double fromY, double toY, Rect r) {
        Iterator i = this.yMap.iterator(fromY, toY);
        while (i.hasNext()) {
            Rect r2;
            PositionTreeMap.Entry e = (PositionTreeMap.Entry)i.next();
            if (!r.intersects((Rect)e.getValue()) || !r.addCollision(r2 = (Rect)e.getValue())) continue;
            r2.addCollision(r);
            r.collisionAdded(r2);
            r2.collisionAdded(r);
        }
    }

    public boolean contains(double px, double py) {
        return px >= this.x && py >= this.y && px < this.x2 && py < this.y2;
    }

    public boolean containsX(double px) {
        return px >= this.x && px < this.x2;
    }

    public boolean containsY(double py) {
        return py >= this.y && py < this.y2;
    }

    public String toString() {
        return "GridCell(" + this.x + "," + this.y + " - " + this.x2 + "," + this.y2 + ")";
    }

    protected void enumerateRects(Collection dst) {
        Rect r;
        PositionTreeMap.Entry e;
        Iterator i = this.xMap.iterator();
        while (i.hasNext()) {
            e = (PositionTreeMap.Entry)i.next();
            r = (Rect)e.getValue();
            if (r == null || dst.contains(r)) continue;
            dst.add(r);
        }
        i = this.yMap.iterator();
        while (i.hasNext()) {
            e = (PositionTreeMap.Entry)i.next();
            r = (Rect)e.getValue();
            if (r == null || dst.contains(r)) continue;
            dst.add(r);
        }
    }

    public void checkConsistency() throws Exception {
        this.xMap.checkConsistency();
        this.yMap.checkConsistency();
    }

    public void checkConsistency(Rect r) throws Exception {
        boolean intersects = r.x < this.x2 && r.y < this.y2 && r.x + r.w >= this.x && r.y + r.h >= this.y;
        boolean overlapsX = r.x < this.x && r.x + r.w >= this.x2 && intersects;
        boolean overlapsY = r.y < this.y && r.y + r.h >= this.y2 && intersects;
        PositionTreeMap.Entry e = this.xMap.getEntry(r.getX(), r);
        if (intersects && this.containsX(r.getX())) {
            if (e == null) {
                throw new Exception("Missing rectX=" + r.getX() + " (" + r + ") in cell (" + this + ")");
            }
        } else if (e != null) {
            throw new Exception("Invalid rectX=" + r.getX() + " (" + r + ") in cell (" + this + ")");
        }
        e = this.yMap.getEntry(r.getY(), r);
        if (intersects && this.containsY(r.getY())) {
            if (e == null) {
                throw new Exception("Missing rectY=" + r.getY() + " (" + r + ") in cell (" + this + ")");
            }
        } else if (e != null) {
            throw new Exception("Invalid rectY=" + r.getY() + " (" + r + ") in cell (" + this + ")");
        }
        e = this.xMap.getEntry(r.getX() + r.getWidth(), r);
        if (intersects && this.containsX(r.getX() + r.getWidth())) {
            if (e == null) {
                throw new Exception("Missing rect-X2 (" + r + ") in cell (" + this + ")");
            }
        } else if (e != null) {
            System.out.println("-> OOPS: intersects: " + intersects);
            throw new Exception("Invalid rect-X2 (" + r + ") in cell (" + this + ")");
        }
        e = this.yMap.getEntry(r.getY() + r.getHeight(), r);
        if (intersects && this.containsY(r.getY() + r.getHeight())) {
            if (e == null) {
                throw new Exception("Missing rect-Y2 (" + r + ") in cell (" + this + ")");
            }
        } else if (e != null) {
            throw new Exception("Invalid rect-Y2 (" + r + ") in cell (" + this + ")");
        }
        if (overlapsX) {
            if (!this.overlapX.contains(r)) {
                throw new Exception("Missing overlapX-rect (" + r + ") in cell (" + this + ")");
            }
        } else if (this.overlapX.contains(r)) {
            throw new Exception("Invalid overlapX-rect (" + r + ") in cell (" + this + ")");
        }
        if (overlapsY) {
            if (!this.overlapY.contains(r)) {
                throw new Exception("Missing overlapY-rect (" + r + ") in cell (" + this + ")");
            }
        } else if (this.overlapY.contains(r)) {
            throw new Exception("Invalid overlapY-rect (" + r + ") in cell (" + this + ")");
        }
    }

    protected class PosTreeMap
    extends PositionTreeMap {
        protected PosTreeMap() {
        }

        @Override
        protected void swapped(double pos1, Object value1, double pos2, Object value2) {
            if (value1 != value2) {
                Rect r1 = (Rect)value1;
                Rect r2 = (Rect)value2;
                if (r1.intersects(r2)) {
                    if (!r1.hasCollision(r2)) {
                        GridCell.this.coll.add(r2);
                    }
                } else if (r1.hasCollision(r2)) {
                    GridCell.this.coll.add(r2);
                }
            }
        }
    }
}

