/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.GridCell;
import com.spacekiller.game2d.Rect;
import com.spacekiller.game2d.RectBoundsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class GridMap {
    private double cellWidth;
    private double cellHeight;
    private int cols;
    private int rows;
    private List cells;
    private Collection coll;

    public GridMap(double cellWidth, double cellHeight, int columns, int rows) {
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.cols = columns;
        this.rows = rows;
        this.coll = new ArrayList(256);
        this.cells = new ArrayList(rows * this.cols);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                this.cells.add(new GridCell((double)c * cellWidth, (double)r * cellHeight, (double)(c + 1) * cellWidth, (double)(r + 1) * cellHeight, this.coll));
            }
        }
    }

    public GridCell getCell(int c, int r) {
        return (GridCell)this.cells.get(r * this.cols + c);
    }

    public GridCell getCell(double x, double y) {
        int col = (int)(x / this.cellWidth);
        int row = (int)(y / this.cellHeight);
        return (GridCell)this.cells.get(row * this.cols + col);
    }

    public void add(Rect n) {
        int c;
        GridCell cell;
        int r;
        double nx = n.x;
        double ny = n.y;
        double nx2 = nx + n.w;
        double ny2 = ny + n.h;
        int firstCol = (int)(nx / this.cellWidth);
        int lastCol = (int)(nx2 / this.cellWidth);
        int firstRow = (int)(ny / this.cellHeight);
        int lastRow = (int)(ny2 / this.cellHeight);
        if (firstCol < 0 || firstRow < 0 || lastCol >= this.cols || lastRow >= this.rows) {
            throw new RectBoundsException("Rectangle out of grid-bounds: " + n + ", cols=" + firstCol + "<>" + lastCol + ", rows=" + firstRow + "<>" + lastRow + ", bounds=" + nx + ", " + ny + " <> " + nx2 + ", " + ny2, n);
        }
        for (r = firstRow; r <= lastRow; ++r) {
            cell = this.getCell(firstCol, r);
            cell.checkX(n);
            cell.addX(nx, n);
            if (firstCol != lastCol) {
                cell = this.getCell(lastCol, r);
                cell.checkX(n);
            }
            cell.addX(nx2, n);
        }
        for (c = firstCol; c <= lastCol; ++c) {
            cell = this.getCell(c, firstRow);
            cell.checkY(n);
            cell.addY(ny, n);
            if (firstRow != lastRow) {
                cell = this.getCell(c, lastRow);
                cell.checkY(n);
            }
            cell.addY(ny2, n);
        }
        for (c = firstCol + 1; c < lastCol; ++c) {
            for (r = firstRow; r <= lastRow; ++r) {
                this.getCell(c, r).addOverlapX(n);
            }
        }
        for (r = firstRow + 1; r < lastRow; ++r) {
            for (c = firstCol; c <= lastCol; ++c) {
                this.getCell(c, r).addOverlapY(n);
            }
        }
        for (r = firstRow; r <= lastRow; ++r) {
            for (c = firstCol; c <= lastCol; ++c) {
                this.getCell(c, r).checkOverlapRects(n);
            }
        }
    }

    public void add(Rect r, double x, double y, double w, double h) {
        r.x = x;
        r.y = y;
        r.w = w;
        r.h = h;
        this.add(r);
    }

    public void remove(Rect n) {
        this.del(n);
        n.clearCollisions();
    }

    private void del(Rect n) {
        int c;
        int r;
        double nx = n.x;
        double ny = n.y;
        double nx2 = nx + n.w;
        double ny2 = ny + n.h;
        int firstCol = (int)(nx / this.cellWidth);
        int lastCol = (int)(nx2 / this.cellWidth);
        int firstRow = (int)(ny / this.cellHeight);
        int lastRow = (int)(ny2 / this.cellHeight);
        for (r = firstRow; r <= lastRow; ++r) {
            this.getCell(firstCol, r).removeX(nx, n);
        }
        for (r = firstRow; r <= lastRow; ++r) {
            this.getCell(lastCol, r).removeX(nx2, n);
        }
        for (c = firstCol; c <= lastCol; ++c) {
            this.getCell(c, firstRow).removeY(ny, n);
        }
        for (c = firstCol; c <= lastCol; ++c) {
            this.getCell(c, lastRow).removeY(ny2, n);
        }
        for (c = firstCol + 1; c < lastCol; ++c) {
            for (r = firstRow; r <= lastRow; ++r) {
                this.getCell(c, r).removeOverlapX(n);
            }
        }
        for (r = firstRow + 1; r < lastRow; ++r) {
            for (c = firstCol; c <= lastCol; ++c) {
                this.getCell(c, r).removeOverlapY(n);
            }
        }
    }

    public void moveTo(Rect r, double x, double y) {
        this.update(r, x, y, r.w, r.h);
    }

    public void moveBy(Rect r, double x, double y) {
        this.update(r, r.x + x, r.y + y, r.w, r.h);
    }

    public void update(Rect r, double x, double y, double w, double h) {
        int j;
        boolean ns;
        int i;
        double x2 = x + w;
        double y2 = y + h;
        double ox = r.getX();
        double oy = r.getY();
        double ox2 = ox + r.getWidth();
        double oy2 = oy + r.getHeight();
        int ofirstCol = (int)(ox / this.cellWidth);
        int olastCol = (int)(ox2 / this.cellWidth);
        int ofirstRow = (int)(oy / this.cellHeight);
        int olastRow = (int)(oy2 / this.cellHeight);
        int nfirstCol = (int)(x / this.cellWidth);
        int nlastCol = (int)(x2 / this.cellWidth);
        int nfirstRow = (int)(y / this.cellHeight);
        int nlastRow = (int)(y2 / this.cellHeight);
        if (ofirstCol > nlastCol || olastCol < nfirstCol || ofirstRow > nlastRow || olastRow < nfirstRow) {
            this.del(r);
            r.x = x;
            r.y = y;
            r.w = w;
            r.h = h;
            r.removeInvalidCollisions();
            this.add(r);
            return;
        }
        if (ofirstCol < 0 || ofirstRow < 0 || olastCol >= this.cols || olastRow >= this.rows || nfirstCol < 0 || nfirstRow < 0 || nlastCol >= this.cols || nlastRow >= this.rows) {
            throw new RectBoundsException("Rectangle out of grid-bounds: " + r, r);
        }
        r.setRect(x, y, w, h);
        if (ofirstCol == nfirstCol && ofirstRow == nfirstRow && olastCol == nlastCol && olastRow == nlastRow) {
            int i2;
            for (i2 = ofirstRow; i2 <= olastRow; ++i2) {
                this.getCell(ofirstCol, i2).moveX(ox, r, x);
            }
            for (i2 = ofirstRow; i2 <= olastRow; ++i2) {
                this.getCell(olastCol, i2).moveX(ox2, r, x2);
            }
            for (i2 = ofirstCol; i2 <= olastCol; ++i2) {
                this.getCell(i2, ofirstRow).moveY(oy, r, y);
            }
            for (i2 = ofirstCol; i2 <= olastCol; ++i2) {
                this.getCell(i2, olastRow).moveY(oy2, r, y2);
            }
            this.validateCollisions(r);
            return;
        }
        for (i = ofirstRow; i < nfirstRow; ++i) {
            this.getCell(ofirstCol, i).removeX(ox, r);
        }
        for (i = nlastRow + 1; i <= olastRow; ++i) {
            this.getCell(ofirstCol, i).removeX(ox, r);
        }
        for (i = nfirstRow; i < ofirstRow; ++i) {
            this.getCell(ofirstCol, i).addX(ox, r);
        }
        for (i = olastRow + 1; i <= nlastRow; ++i) {
            this.getCell(ofirstCol, i).addX(ox, r);
        }
        if (ox != x) {
            this.moveX(r, nfirstRow, nlastRow, ofirstCol, ox, nfirstCol, x);
        }
        for (i = ofirstCol; i < nfirstCol; ++i) {
            this.getCell(i, ofirstRow).removeY(oy, r);
        }
        for (i = nlastCol + 1; i <= olastCol; ++i) {
            this.getCell(i, ofirstRow).removeY(oy, r);
        }
        for (i = nfirstCol; i < ofirstCol; ++i) {
            this.getCell(i, ofirstRow).addY(oy, r);
        }
        for (i = olastCol + 1; i <= nlastCol; ++i) {
            this.getCell(i, ofirstRow).addY(oy, r);
        }
        if (oy != y) {
            this.moveY(r, nfirstCol, nlastCol, ofirstRow, oy, nfirstRow, y);
        }
        for (i = ofirstRow; i < nfirstRow; ++i) {
            this.getCell(olastCol, i).removeX(ox2, r);
        }
        for (i = nlastRow + 1; i <= olastRow; ++i) {
            this.getCell(olastCol, i).removeX(ox2, r);
        }
        for (i = nfirstRow; i < ofirstRow; ++i) {
            this.getCell(olastCol, i).addX(ox2, r);
        }
        for (i = olastRow + 1; i <= nlastRow; ++i) {
            this.getCell(olastCol, i).addX(ox2, r);
        }
        if (ox2 != x2) {
            this.moveX(r, nfirstRow, nlastRow, olastCol, ox2, nlastCol, x2);
        }
        for (i = ofirstCol; i < nfirstCol; ++i) {
            this.getCell(i, olastRow).removeY(oy2, r);
        }
        for (i = nlastCol + 1; i <= olastCol; ++i) {
            this.getCell(i, olastRow).removeY(oy2, r);
        }
        for (i = nfirstCol; i < ofirstCol; ++i) {
            this.getCell(i, olastRow).addY(oy2, r);
        }
        for (i = olastCol + 1; i <= nlastCol; ++i) {
            this.getCell(i, olastRow).addY(oy2, r);
        }
        if (oy2 != y2) {
            this.moveY(r, nfirstCol, nlastCol, olastRow, oy2, nlastRow, y2);
        }
        int osx = ofirstCol + 1;
        int osy = ofirstRow + 1;
        int osx2 = olastCol;
        int osy2 = olastRow;
        boolean os = osx < osx2 && osy < osy2;
        int nsx = nfirstCol + 1;
        int nsy = nfirstRow + 1;
        int nsx2 = nlastCol;
        int nsy2 = nlastRow;
        boolean bl = ns = nsx < nsx2 && nsy < nsy2;
        if (os && ns && nsx < osx2 && nsy < osy2 && nsx2 > osx && nsy2 > osy) {
            System.err.println("TODO: optimized-update of surrounded cells: " + r);
        }
        for (i = osx; i < osx2; ++i) {
            for (j = ofirstRow; j <= olastRow; ++j) {
                this.getCell(i, j).removeOverlapX(r);
            }
        }
        for (i = osy; i < osy2; ++i) {
            for (j = ofirstCol; j <= olastCol; ++j) {
                this.getCell(j, i).removeOverlapY(r);
            }
        }
        for (i = nsx; i < nsx2; ++i) {
            for (j = nfirstRow; j <= nlastRow; ++j) {
                this.getCell(i, j).addOverlapX(r);
            }
        }
        for (i = nsy; i < nsy2; ++i) {
            for (j = nfirstCol; j <= nlastCol; ++j) {
                this.getCell(j, i).addOverlapY(r);
            }
        }
        this.validateCollisions(r);
    }

    protected void moveX(Rect r, int firstRow, int lastRow, int oCol, double ox, int nCol, double nx) {
        if (oCol == nCol) {
            for (int i = firstRow; i <= lastRow; ++i) {
                this.getCell(oCol, i).moveX(ox, r, nx);
            }
            return;
        }
        boolean forward = oCol < nCol;
        for (int i = firstRow; i <= lastRow; ++i) {
            int j;
            GridCell cell = this.getCell(oCol, i);
            cell.moveX(ox, r, nx);
            cell.removeX(nx, r);
            if (forward) {
                for (j = oCol + 1; j < nCol; ++j) {
                    cell = this.getCell(j, i);
                    cell.addX(ox, r);
                    cell.moveX(ox, r, nx);
                    cell.removeX(nx, r);
                }
            } else {
                for (j = oCol - 1; j > nCol; --j) {
                    cell = this.getCell(j, i);
                    cell.addX(ox, r);
                    cell.moveX(ox, r, nx);
                    cell.removeX(nx, r);
                }
            }
            cell = this.getCell(nCol, i);
            cell.addX(ox, r);
            cell.moveX(ox, r, nx);
        }
    }

    protected void moveY(Rect r, int firstCol, int lastCol, int oRow, double oy, int nRow, double ny) {
        if (oRow == nRow) {
            for (int i = firstCol; i <= lastCol; ++i) {
                this.getCell(i, oRow).moveY(oy, r, ny);
            }
            return;
        }
        boolean forward = oRow < nRow;
        for (int i = firstCol; i <= lastCol; ++i) {
            int j;
            GridCell cell = this.getCell(i, oRow);
            cell.moveY(oy, r, ny);
            cell.removeY(ny, r);
            if (forward) {
                for (j = oRow + 1; j < nRow; ++j) {
                    cell = this.getCell(i, j);
                    cell.addY(oy, r);
                    cell.moveY(oy, r, ny);
                    cell.removeY(ny, r);
                }
            } else {
                for (j = oRow - 1; j > nRow; --j) {
                    cell = this.getCell(i, j);
                    cell.addY(oy, r);
                    cell.moveY(oy, r, ny);
                    cell.removeY(ny, r);
                }
            }
            cell = this.getCell(i, nRow);
            cell.addY(oy, r);
            cell.moveY(oy, r, ny);
        }
    }

    public void enumerateRects(Collection dst) {
        int num = this.cells.size();
        for (int c = 0; c < num; ++c) {
            GridCell cell = (GridCell)this.cells.get(c);
            cell.enumerateRects(dst);
        }
    }

    public void checkConsistency() throws Exception {
        Rect rect;
        int r;
        GridCell cell;
        Vector rects = new Vector();
        this.enumerateRects(rects);
        int rectCount = rects.size();
        ArrayList<Exception> errors = new ArrayList<Exception>();
        int cellCount = this.cells.size();
        for (int c = 0; c < cellCount; ++c) {
            cell = (GridCell)this.cells.get(c);
            try {
                cell.checkConsistency();
                continue;
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        for (r = 0; r < rectCount; ++r) {
            rect = (Rect)rects.get(r);
            try {
                for (int c = 0; c < cellCount; ++c) {
                    cell = (GridCell)this.cells.get(c);
                    cell.checkConsistency(rect);
                }
                continue;
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        for (r = 0; r < rectCount; ++r) {
            rect = (Rect)rects.get(r);
            try {
                this.checkRectConsistency(rect);
                continue;
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        if (errors.size() == 1) {
            throw (Exception)errors.get(0);
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Consistency errors: " + errors.size());
        Iterator i = errors.iterator();
        while (i.hasNext()) {
            msg.append("\n - " + i.next());
        }
        throw new Exception("" + msg);
    }

    public void checkRectConsistency(Rect rect) throws Exception {
        ArrayList rects = new ArrayList();
        this.enumerateRects(rects);
        for (Rect rect2 : rects) {
            if (rect == rect2) continue;
            if (rect.intersects(rect2)) {
                if (!rect.coll.contains(rect2)) {
                    throw new Exception("Missing Rect1-Collision: " + rect + " <+> " + rect2);
                }
                if (rect2.coll.contains(rect)) continue;
                throw new Exception("Missing Rect2-Collision: " + rect2 + " <+> " + rect);
            }
            if (rect.coll.contains(rect2)) {
                throw new Exception("Invalid Rect1-Collision: " + rect + " <-> " + rect2);
            }
            if (!rect2.coll.contains(rect)) continue;
            throw new Exception("Invalid Rect2-Collision: " + rect2 + " <-> " + rect);
        }
        Collection coll = rect.coll;
        for (Rect rect2 : coll) {
            if (rect.intersects(rect2)) continue;
            throw new Exception("Invalid Rect-Collision: " + rect + " <-> " + rect2);
        }
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                GridCell cell = this.getCell(c, r);
                cell.checkConsistency(rect);
            }
        }
    }

    public double getCellHeight() {
        return this.cellHeight;
    }

    public double getCellWidth() {
        return this.cellWidth;
    }

    public int getColumns() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    protected void setCellHeight(double d) {
        this.cellHeight = d;
    }

    protected void setCellWidth(double d) {
        this.cellWidth = d;
    }

    protected void setColumns(int i) {
        this.cols = i;
    }

    protected void setRows(int i) {
        this.rows = i;
    }

    public double getWidth() {
        return (double)this.cols * this.cellWidth;
    }

    public double getHeight() {
        return (double)this.rows * this.cellHeight;
    }

    protected void validateCollisions(Rect r) {
        Iterator i = this.coll.iterator();
        while (i.hasNext()) {
            Rect s = (Rect)i.next();
            i.remove();
            if (r.intersects(s)) {
                if (!r.addCollision(s)) continue;
                s.addCollision(r);
                r.collisionAdded(s);
                s.collisionAdded(r);
                continue;
            }
            if (!r.removeCollision(s)) continue;
            s.removeCollision(r);
            r.collisionRemoved(s);
            s.collisionRemoved(r);
        }
    }

    static void resetRect(Rect r, double x, double y, double w, double h) {
        r.x = x;
        r.y = y;
        r.w = w;
        r.h = h;
    }
}

