/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.GridMapTest;
import com.spacekiller.game2d.Rect;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class GridMapRecorder {
    private List rects = new ArrayList();
    private List actions = new ArrayList();

    public void rectInserted(Rect rect) {
        int i = this.rects.size();
        this.rects.add(rect);
        this.actions.add(new GridMapTest.InsertAction(i, rect.x, rect.y, rect.w, rect.h));
    }

    public void rectMoved(Rect rect) {
        int i = this.rects.indexOf(rect);
        this.actions.add(new GridMapTest.MoveAction(i, rect.x, rect.y));
    }

    public void rectRemoved(Rect rect) {
        int i = this.rects.indexOf(rect);
        this.rects.remove(i);
        this.actions.add(new GridMapTest.RemoveAction(i));
    }

    public List getActions() {
        return this.actions;
    }

    public void dumpActions(PrintStream out) {
        out.println("============= Recorded Actions =============");
        for (Object o : this.actions) {
            Object a;
            if (o instanceof GridMapTest.InsertAction) {
                a = (GridMapTest.InsertAction)o;
                out.println("  new InsertAction( " + ((GridMapTest.InsertAction)a).rect + ", " + ((GridMapTest.InsertAction)a).x + ", " + ((GridMapTest.InsertAction)a).y + ", " + ((GridMapTest.InsertAction)a).w + ", " + ((GridMapTest.InsertAction)a).h + " ), ");
                continue;
            }
            if (o instanceof GridMapTest.MoveAction) {
                a = (GridMapTest.MoveAction)o;
                out.println("  new MoveAction( " + ((GridMapTest.MoveAction)a).rect + ", " + ((GridMapTest.MoveAction)a).mx + ", " + ((GridMapTest.MoveAction)a).my + " ), ");
                continue;
            }
            if (o instanceof GridMapTest.RemoveAction) {
                a = (GridMapTest.RemoveAction)o;
                out.println("  new RemoveAction( " + ((GridMapTest.RemoveAction)a).rect + " ), ");
                continue;
            }
            throw new RuntimeException("Invalid action: " + o);
        }
        out.println("============================================");
    }
}

