/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.GridMap;
import com.spacekiller.game2d.Rect;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.util.ArrayList;

public class GridMapTest {
    public static void main(String[] args) {
        try {
            System.out.println("Testing GridMap..");
            GridMapTest.testFunctions001();
            GridMapTest.testError001();
            GridMapTest.testError002();
            GridMapTest.testError003();
            GridMapTest.testError004();
            GridMapTest.testError005();
            GridMapTest.testError006();
            GridMapTest.testError007();
            for (int c = 0; c < 1000; ++c) {
                GridMapTest.testFunctions002();
            }
            System.out.println("Test completed.");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static void testFunctions001() throws Exception {
        System.out.println(">> testFunctions001:");
        double cellWidth = 1000.0;
        double cellHeight = 1000.0;
        int columns = 100;
        int rows = 100;
        GridMap map = new GridMap(cellWidth, cellHeight, columns, rows);
        System.out.println("GridMap: " + map);
        TestRect rect1 = new TestRect();
        map.add(rect1, 50.0, 50.0, 200.0, 200.0);
        TestRect rect2 = new TestRect();
        map.add(rect2, 300.0, 300.0, 100.0, 100.0);
        map.checkConsistency();
        map.update(rect1, 150.0, 150.0, 200.0, 200.0);
        System.out.println("Collisions: " + rect1.getCollisionCount());
        map.checkConsistency();
        map.update(rect1, 450.0, 150.0, 200.0, 200.0);
        System.out.println("Collisions: " + rect1.getCollisionCount());
        map.checkConsistency();
        TestRect rect3 = new TestRect();
        map.add(rect3, 100.0, 100.0, 600.0, 600.0);
        System.out.println("Collisions: " + rect3.getCollisionCount());
        map.checkConsistency();
        map.update(rect3, 460.0, 450.0, 600.0, 600.0);
        System.out.println("Collisions: " + rect3.getCollisionCount());
        map.checkConsistency();
    }

    private static void testFunctions002() throws Exception {
        double y;
        double x;
        System.out.println(">> testFunctions002:");
        double cellWidth = 1000.0;
        double cellHeight = 1000.0;
        int columns = 5;
        int rows = 5;
        GridMap map = new GridMap(cellWidth, cellHeight, columns, rows);
        System.out.println("GridMap: " + map);
        double maxX = (double)columns * cellWidth;
        double maxY = (double)rows * cellHeight;
        int rectCount = 50;
        System.out.println("Adding rects: " + rectCount);
        ArrayList<TestRect> rects = new ArrayList<TestRect>();
        Rectangle2D[] oriRects = new Rectangle2D[rectCount];
        for (int c = 0; c < rectCount; ++c) {
            TestRect rect1 = new TestRect();
            double w = (int)(1.0 + Math.random() * (double)(c + 1) * 10.0);
            double h = (int)(1.0 + Math.random() * (double)(c + 1) * 10.0);
            x = (int)(Math.random() * (maxX - w));
            y = (int)(Math.random() * (maxY - h));
            map.add(rect1, x, y, w, h);
            rects.add(rect1);
            oriRects[c] = new Rectangle2D.Double(x, y, w, h);
        }
        try {
            map.checkConsistency();
        }
        catch (Exception e) {
            GridMapTest.dumpActions(oriRects, new Object[0], System.out);
            throw e;
        }
        ArrayList<MoveAction> actions = new ArrayList<MoveAction>();
        int moveCount = 500;
        System.out.println("Moving rects: " + moveCount);
        for (int c = 0; c < moveCount; ++c) {
            if ((c & 0xFF) == 0) {
                System.out.println(" - " + c + " / " + moveCount);
            }
            int r = (int)(Math.random() * (double)rectCount);
            Rect rect = (Rect)rects.get(r);
            if (Math.random() < 0.05 && rectCount > 60) continue;
            double mx = 0.0;
            double my = 0.0;
            if (Math.random() > 0.4) {
                mx += (double)((int)((Math.random() - 0.5) * 50.0));
            }
            if (Math.random() > 0.4) {
                my += (double)((int)((Math.random() - 0.5) * 50.0));
            }
            double ox = rect.x;
            double oy = rect.y;
            x = rect.x + mx;
            y = rect.y + my;
            double w = rect.w;
            double h = rect.h;
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
            if (x + w >= maxX) {
                x = maxX - w - 1.0;
            }
            if (y + h >= maxY) {
                y = maxY - h - 1.0;
            }
            actions.add(new MoveAction(r, x, y));
            try {
                map.moveTo(rect, x, y);
                map.checkRectConsistency(rect);
                continue;
            }
            catch (Exception e) {
                System.out.println("ERROR: " + e);
                System.out.println("#" + c + " -> MoveRect: " + rect + ", moveX=" + mx + ", moveY=" + my);
                e.printStackTrace(System.out);
                try {
                    map.checkConsistency();
                }
                catch (Exception e2) {
                    System.out.println("!! GridMap is inconsistent: " + e2);
                }
                System.out.println("Re-checking error situation [1]..");
                map.moveTo(rect, ox, oy);
                ArrayList<TestRect> rects2 = new ArrayList<TestRect>();
                GridMap testMap = new GridMap(cellWidth, cellHeight, columns, rows);
                for (int j = 0; j < rectCount; ++j) {
                    Rect rect1 = (Rect)rects.get(j);
                    TestRect rect2 = new TestRect();
                    testMap.add(rect2, rect1.x, rect1.y, rect1.w, rect1.h);
                    rects2.add(rect2);
                }
                Rect rect2 = (Rect)rects2.get(r);
                testMap.moveTo(rect2, x, y);
                try {
                    testMap.checkRectConsistency(rect);
                    System.out.println("Re-check[1] was successful !!");
                }
                catch (Exception e2) {
                    System.out.println("Re-check[1] error: " + e2);
                }
                System.out.println("Re-checking error situation [2]..");
                rects2 = new ArrayList();
                testMap = new GridMap(cellWidth, cellHeight, columns, rows);
                try {
                    GridMapTest.testActions(testMap, oriRects, actions.toArray());
                    System.out.println("Re-check[2] was successful !!");
                }
                catch (Exception e2) {
                    System.out.println("Re-check[2] error: " + e2);
                    GridMapTest.dumpActions(oriRects, actions.toArray(), System.out);
                }
                throw new Exception("Error detected: " + e);
            }
        }
        map.checkConsistency();
    }

    private static void testActions(GridMap map, Rectangle2D[] rects, Object[] actions) throws Exception {
        int c;
        ArrayList<Rect> rs = new ArrayList<Rect>();
        for (c = 0; c < rects.length; ++c) {
            Rectangle2D rect1 = rects[c];
            TestRect rect2 = new TestRect();
            map.add(rect2, rect1.getX(), rect1.getY(), rect1.getWidth(), rect1.getHeight());
            rs.add(rect2);
        }
        map.checkConsistency();
        for (c = 0; c < actions.length; ++c) {
            Rect rect2;
            Object action = actions[c];
            if (action instanceof MoveAction) {
                MoveAction move = (MoveAction)action;
                rect2 = (Rect)rs.get(move.rect);
                map.moveTo(rect2, move.mx, move.my);
                continue;
            }
            if (action instanceof InsertAction) {
                InsertAction insert = (InsertAction)action;
                rect2 = new TestRect();
                map.add(rect2, insert.x, insert.y, insert.w, insert.h);
                rs.add(rect2);
                continue;
            }
            if (action instanceof RemoveAction) {
                RemoveAction remove = (RemoveAction)action;
                map.remove((Rect)rs.get(remove.rect));
                rs.remove(remove.rect);
                continue;
            }
            throw new RuntimeException("Invalid action: " + action);
        }
        map.checkConsistency();
    }

    private static void dumpActions(Rectangle2D[] rects, Object[] actions, PrintStream out) throws Exception {
        int c;
        out.println("------------------- Error Dump START --------------------");
        out.println("Rectangle2D[] rects = new Rectangle2D[] {");
        for (c = 0; c < rects.length; ++c) {
            Rectangle2D rect1 = rects[c];
            out.print("  new Rectangle2D.Double( " + rect1.getX() + ", " + rect1.getY() + ", " + rect1.getWidth() + ", " + rect1.getHeight() + " )");
            if (c + 1 < rects.length) {
                out.print(", ");
            }
            out.println();
        }
        out.println("};");
        out.println("Object[] actions = new Object[] {");
        for (c = 0; c < actions.length; ++c) {
            Object action = actions[c];
            if (!(action instanceof MoveAction)) continue;
            MoveAction move = (MoveAction)action;
            out.print("  new MoveAction( " + move.rect + ", " + move.mx + ", " + move.my + " )");
            if (c + 1 < actions.length) {
                out.print(", ");
            }
            out.println();
        }
        out.println("};");
        out.println("------------------- Error Dump END --------------------");
    }

    private static void testError001() throws Exception {
        Rectangle2D[] rects = new Rectangle2D[]{new Rectangle2D.Double(610.0, 761.0, 15.0, 32.0), new Rectangle2D.Double(575.0, 753.0, 35.0, 45.0)};
        Object[] actions = new Object[]{new MoveAction(1, 580.0, 753.0)};
        double cellWidth = 1000.0;
        double cellHeight = 1000.0;
        int columns = 1;
        int rows = 1;
        GridMap map = new GridMap(cellWidth, cellHeight, columns, rows);
        GridMapTest.testActions(map, rects, actions);
    }

    private static void testError002() throws Exception {
        Rectangle2D[] rects = new Rectangle2D[]{new Rectangle2D.Double(297.0, 272.0, 92.0, 34.0), new Rectangle2D.Double(40.0, 51.0, 46.0, 3.0), new Rectangle2D.Double(71.0, 35.0, 19.0, 17.0), new Rectangle2D.Double(212.0, 353.0, 4.0, 98.0), new Rectangle2D.Double(850.0, 176.0, 78.0, 69.0), new Rectangle2D.Double(991.0, 639.0, 8.0, 77.0), new Rectangle2D.Double(448.0, 693.0, 69.0, 38.0), new Rectangle2D.Double(241.0, 6.0, 78.0, 32.0), new Rectangle2D.Double(300.0, 95.0, 64.0, 83.0), new Rectangle2D.Double(105.0, 470.0, 80.0, 69.0)};
        Object[] actions = new Object[]{new MoveAction(6, 446.0, 685.0), new MoveAction(0, 301.0, 264.0), new MoveAction(4, 850.0, 171.0), new MoveAction(9, 105.0, 470.0), new MoveAction(8, 295.0, 92.0), new MoveAction(0, 296.0, 262.0), new MoveAction(9, 104.0, 479.0), new MoveAction(7, 242.0, 0.0), new MoveAction(6, 446.0, 680.0), new MoveAction(3, 212.0, 362.0), new MoveAction(0, 293.0, 266.0), new MoveAction(8, 295.0, 86.0), new MoveAction(9, 104.0, 479.0), new MoveAction(8, 298.0, 81.0), new MoveAction(0, 293.0, 261.0), new MoveAction(8, 299.0, 81.0), new MoveAction(5, 991.0, 639.0), new MoveAction(2, 71.0, 35.0), new MoveAction(2, 78.0, 31.0), new MoveAction(4, 842.0, 171.0), new MoveAction(0, 297.0, 265.0), new MoveAction(0, 297.0, 265.0), new MoveAction(7, 241.0, 0.0), new MoveAction(8, 299.0, 81.0), new MoveAction(6, 443.0, 683.0), new MoveAction(3, 212.0, 357.0), new MoveAction(7, 249.0, 0.0), new MoveAction(8, 299.0, 78.0), new MoveAction(9, 96.0, 479.0), new MoveAction(8, 299.0, 78.0), new MoveAction(6, 443.0, 688.0), new MoveAction(3, 213.0, 366.0), new MoveAction(2, 78.0, 33.0), new MoveAction(9, 96.0, 486.0), new MoveAction(4, 839.0, 170.0), new MoveAction(2, 85.0, 39.0), new MoveAction(7, 256.0, 0.0), new MoveAction(8, 292.0, 86.0), new MoveAction(9, 96.0, 480.0), new MoveAction(8, 289.0, 86.0), new MoveAction(4, 839.0, 172.0), new MoveAction(2, 86.0, 43.0)};
        double cellWidth = 1000.0;
        double cellHeight = 1000.0;
        int columns = 1;
        int rows = 1;
        GridMap map = new GridMap(cellWidth, cellHeight, columns, rows);
        GridMapTest.testActions(map, rects, actions);
    }

    private static void testError003() throws Exception {
        Rectangle2D[] rects = new Rectangle2D[]{new Rectangle2D.Double(948.0, 921.0, 1441.0, 1250.0), new Rectangle2D.Double(1343.0, 1360.0, 449.0, 68.0)};
        Object[] actions = new Object[]{};
        double cellWidth = 1000.0;
        double cellHeight = 1000.0;
        int columns = 3;
        int rows = 3;
        GridMap map = new GridMap(cellWidth, cellHeight, columns, rows);
        GridMapTest.testActions(map, rects, actions);
    }

    private static void testError004() throws Exception {
        Rectangle2D[] rects = new Rectangle2D[]{new Rectangle2D.Double(860.0, 1593.0, 1465.0, 59.0), new Rectangle2D.Double(1221.0, 889.0, 599.0, 1328.0)};
        Object[] actions = new Object[]{};
        double cellWidth = 1100.0;
        double cellHeight = 1100.0;
        int columns = 3;
        int rows = 3;
        GridMap map = new GridMap(cellWidth, cellHeight, columns, rows);
        GridMapTest.testActions(map, rects, actions);
    }

    private static void testError005() throws Exception {
        Rectangle2D[] rects = new Rectangle2D[]{new Rectangle2D.Double(1013.0, 2352.0, 1019.0, 507.0)};
        Object[] actions = new Object[]{new MoveAction(0, 1006.0, 2352.0), new MoveAction(0, 999.0, 2352.0)};
        double cellWidth = 1000.0;
        double cellHeight = 1000.0;
        int columns = 3;
        int rows = 3;
        GridMap map = new GridMap(cellWidth, cellHeight, columns, rows);
        GridMapTest.testActions(map, rects, actions);
    }

    private static void testError006() throws Exception {
        Rectangle2D[] rects = new Rectangle2D[]{new Rectangle2D.Double(1153.0, 1333.0, 305.0, 449.0), new Rectangle2D.Double(953.0, 977.0, 1413.0, 1458.0)};
        Object[] actions = new Object[]{};
        double cellWidth = 1000.0;
        double cellHeight = 1000.0;
        int columns = 3;
        int rows = 3;
        GridMap map = new GridMap(cellWidth, cellHeight, columns, rows);
        GridMapTest.testActions(map, rects, actions);
    }

    private static void testError007() throws Exception {
        Rectangle2D[] rects = new Rectangle2D[]{new Rectangle2D.Double(4434.0, 63.0, 5.0, 1.0), new Rectangle2D.Double(4183.0, 828.0, 14.0, 5.0), new Rectangle2D.Double(4919.0, 494.0, 5.0, 17.0), new Rectangle2D.Double(2472.0, 2001.0, 6.0, 2.0), new Rectangle2D.Double(2343.0, 2874.0, 11.0, 9.0), new Rectangle2D.Double(839.0, 3006.0, 58.0, 7.0), new Rectangle2D.Double(953.0, 2485.0, 42.0, 34.0), new Rectangle2D.Double(692.0, 2342.0, 44.0, 34.0), new Rectangle2D.Double(339.0, 2137.0, 24.0, 68.0), new Rectangle2D.Double(4405.0, 2517.0, 19.0, 67.0), new Rectangle2D.Double(4428.0, 693.0, 101.0, 59.0), new Rectangle2D.Double(4927.0, 4832.0, 21.0, 77.0), new Rectangle2D.Double(187.0, 3597.0, 1.0, 91.0), new Rectangle2D.Double(466.0, 1531.0, 115.0, 26.0), new Rectangle2D.Double(343.0, 2743.0, 21.0, 26.0), new Rectangle2D.Double(3936.0, 4060.0, 2.0, 78.0), new Rectangle2D.Double(985.0, 1675.0, 9.0, 49.0), new Rectangle2D.Double(2841.0, 367.0, 32.0, 71.0), new Rectangle2D.Double(4574.0, 2455.0, 105.0, 112.0), new Rectangle2D.Double(1620.0, 277.0, 135.0, 24.0), new Rectangle2D.Double(1067.0, 2587.0, 40.0, 101.0), new Rectangle2D.Double(4375.0, 565.0, 211.0, 76.0), new Rectangle2D.Double(839.0, 4130.0, 136.0, 10.0), new Rectangle2D.Double(3554.0, 1914.0, 36.0, 184.0), new Rectangle2D.Double(483.0, 2804.0, 166.0, 224.0), new Rectangle2D.Double(2238.0, 193.0, 197.0, 126.0), new Rectangle2D.Double(1821.0, 2037.0, 43.0, 4.0), new Rectangle2D.Double(2574.0, 2491.0, 199.0, 233.0), new Rectangle2D.Double(1534.0, 3792.0, 71.0, 227.0), new Rectangle2D.Double(2216.0, 4213.0, 297.0, 147.0), new Rectangle2D.Double(1838.0, 3773.0, 26.0, 223.0), new Rectangle2D.Double(2968.0, 2995.0, 148.0, 11.0), new Rectangle2D.Double(4696.0, 1461.0, 207.0, 222.0), new Rectangle2D.Double(4557.0, 3183.0, 249.0, 89.0), new Rectangle2D.Double(50.0, 4628.0, 20.0, 151.0), new Rectangle2D.Double(3361.0, 2877.0, 39.0, 329.0), new Rectangle2D.Double(3547.0, 2135.0, 222.0, 8.0), new Rectangle2D.Double(4378.0, 463.0, 2.0, 246.0), new Rectangle2D.Double(3217.0, 3593.0, 263.0, 55.0), new Rectangle2D.Double(2756.0, 4643.0, 148.0, 154.0), new Rectangle2D.Double(3294.0, 3791.0, 224.0, 206.0), new Rectangle2D.Double(4364.0, 3694.0, 405.0, 161.0), new Rectangle2D.Double(1346.0, 1648.0, 2.0, 25.0), new Rectangle2D.Double(1865.0, 3650.0, 257.0, 297.0), new Rectangle2D.Double(4341.0, 4425.0, 321.0, 155.0), new Rectangle2D.Double(3791.0, 945.0, 248.0, 324.0), new Rectangle2D.Double(4800.0, 2847.0, 100.0, 205.0), new Rectangle2D.Double(898.0, 2953.0, 475.0, 131.0), new Rectangle2D.Double(1162.0, 3225.0, 395.0, 127.0), new Rectangle2D.Double(3466.0, 3324.0, 486.0, 103.0)};
        Object[] actions = new Object[]{new MoveAction(36, 3537.0, 2135.0), new MoveAction(14, 337.0, 2740.0), new MoveAction(5, 839.0, 3006.0), new MoveAction(44, 4341.0, 4406.0), new MoveAction(9, 4405.0, 2517.0), new MoveAction(25, 2227.0, 188.0), new MoveAction(17, 2823.0, 383.0), new MoveAction(43, 1844.0, 3650.0), new MoveAction(35, 3361.0, 2877.0), new MoveAction(24, 486.0, 2804.0), new MoveAction(18, 4565.0, 2436.0), new MoveAction(33, 4549.0, 3195.0), new MoveAction(33, 4567.0, 3182.0), new MoveAction(28, 1532.0, 3787.0), new MoveAction(2, 4913.0, 494.0), new MoveAction(33, 4561.0, 3182.0), new MoveAction(17, 2811.0, 400.0), new MoveAction(37, 4378.0, 463.0), new MoveAction(21, 4383.0, 565.0), new MoveAction(9, 4411.0, 2515.0), new MoveAction(16, 985.0, 1684.0), new MoveAction(32, 4696.0, 1457.0), new MoveAction(47, 891.0, 2953.0), new MoveAction(43, 1835.0, 3670.0), new MoveAction(46, 4795.0, 2840.0), new MoveAction(6, 953.0, 2473.0), new MoveAction(36, 3532.0, 2135.0), new MoveAction(25, 2227.0, 164.0), new MoveAction(26, 1821.0, 2037.0), new MoveAction(41, 4364.0, 3716.0), new MoveAction(22, 839.0, 4130.0), new MoveAction(22, 862.0, 4136.0), new MoveAction(18, 4565.0, 2436.0), new MoveAction(47, 891.0, 2935.0), new MoveAction(5, 818.0, 2992.0)};
        double cellWidth = 1000.0;
        double cellHeight = 1000.0;
        int columns = 5;
        int rows = 5;
        GridMap map = new GridMap(cellWidth, cellHeight, columns, rows);
        GridMapTest.testActions(map, rects, actions);
    }

    private static void testPerformance001() throws Exception {
        int c;
        System.out.println(">> testPerformance001:");
        double cellWidth = 1000.0;
        double cellHeight = 1000.0;
        int columns = 100;
        int rows = 100;
        GridMap map = new GridMap(cellWidth, cellHeight, columns, rows);
        System.out.println("GridMap: " + map);
        System.out.println("Testing: add rectangles..");
        Rect[] rects = new Rect[50000];
        long ms = -System.currentTimeMillis();
        for (int c2 = 0; c2 < rects.length; ++c2) {
            TestRect rect2 = new TestRect();
            double initX = Math.random() * cellWidth * (double)(columns - 2);
            double initY = Math.random() * cellHeight * (double)(rows - 2);
            double initW = Math.random() * cellWidth * 2.0;
            double initH = Math.random() * cellHeight * 2.0;
            map.add(rect2, initX, initY, initW, initH);
            rects[c2] = rect2;
        }
        double addPerf = (double)(ms += System.currentTimeMillis()) / (double)rects.length;
        System.out.println("Add-Test completed: " + ms + " ms. => " + addPerf + " ms/call.");
        System.out.println("Testing: move rectangles..");
        TestRect rect1 = new TestRect();
        map.add(rect1, 50.0, 50.0, 200.0, 200.0);
        int speedX = 7;
        int speedY = 3;
        ms = -System.currentTimeMillis();
        int loops = 10000;
        for (c = 0; c < loops; ++c) {
            map.update(rect1, rect1.getX() + (double)speedX, rect1.getY() + (double)speedY, rect1.getWidth(), rect1.getHeight());
        }
        System.out.println("Move-Test completed: " + (ms += System.currentTimeMillis()) + " ms.");
        System.out.println("Testing: remove rectangles..");
        ms = -System.currentTimeMillis();
        loops = 10000;
        for (c = 0; c < loops; ++c) {
            map.remove(rects[c]);
        }
        double removePerf = (double)(ms += System.currentTimeMillis()) / (double)loops;
        System.out.println("Remove-Test completed: " + ms + " ms. => " + removePerf + " ms/call.");
    }

    public static class RemoveAction {
        public int rect;

        public RemoveAction(int rect) {
            this.rect = rect;
        }
    }

    public static class InsertAction {
        public int rect;
        public double x;
        public double y;
        public double w;
        public double h;

        public InsertAction(int rect, double x, double y, double w, double h) {
            this.rect = rect;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }

    public static class MoveAction {
        public int rect;
        public double mx;
        public double my;

        public MoveAction(int rect, double mx, double my) {
            this.rect = rect;
            this.mx = mx;
            this.my = my;
        }
    }

    private static class TestRect
    extends Rect {
        private TestRect() {
        }

        @Override
        protected void collisionAdded(Rect r) {
        }

        @Override
        protected void collisionRemoved(Rect r) {
        }
    }
}

