/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.ImageScaleView;
import java.awt.Rectangle;

public class ImageScaleActor
extends Actor {
    private ImageScaleView imageScaleView;
    private Rectangle startImageBounds;
    private Rectangle endImageBounds;
    private long millis;
    private long elapsed = 0L;
    private Rectangle currentImageBounds = new Rectangle();

    public ImageScaleActor(ImageScaleView imageScaleView, Rectangle startImageBounds, Rectangle endImageBounds, long millis) {
        this.setMillis(millis);
        this.setImageScaleView(imageScaleView);
        this.setStartImageBounds(startImageBounds);
        this.setEndImageBounds(endImageBounds);
    }

    @Override
    public void invoke(long ms) {
        if (ms <= 0L) {
            return;
        }
        this.elapsed += ms;
        if (this.elapsed >= this.millis) {
            this.imageScaleView.setImageBounds(this.endImageBounds);
            this.dispose();
            return;
        }
        double endFactor = (double)this.elapsed / (double)this.millis;
        double startFactor = 1.0 - endFactor;
        this.currentImageBounds.x = (int)Math.round((double)this.startImageBounds.x * startFactor + (double)this.endImageBounds.x * endFactor);
        this.currentImageBounds.y = (int)Math.round((double)this.startImageBounds.y * startFactor + (double)this.endImageBounds.y * endFactor);
        this.currentImageBounds.width = (int)Math.round((double)this.startImageBounds.width * startFactor + (double)this.endImageBounds.width * endFactor);
        this.currentImageBounds.height = (int)Math.round((double)this.startImageBounds.height * startFactor + (double)this.endImageBounds.height * endFactor);
        this.imageScaleView.setImageBounds(this.currentImageBounds);
    }

    public Rectangle getEndImageBounds() {
        return this.endImageBounds;
    }

    public void setEndImageBounds(Rectangle endImageBounds) {
        this.endImageBounds = endImageBounds;
    }

    public Rectangle getStartImageBounds() {
        return this.startImageBounds;
    }

    public void setStartImageBounds(Rectangle startImageBounds) {
        this.startImageBounds = startImageBounds;
    }

    public ImageScaleView getImageScaleView() {
        return this.imageScaleView;
    }

    public void setImageScaleView(ImageScaleView imageScaleView) {
        this.imageScaleView = imageScaleView;
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }
}

