/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Action;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementActor;
import com.spacekiller.game2d.RectBoundsException;
import com.spacekiller.game2d.Speed2D;
import java.util.ArrayList;
import java.util.List;

public class MoveActor
extends ElementActor {
    private List actions = new ArrayList();
    protected long mms;
    protected double moveX;
    protected double moveY;

    public MoveActor(Element element) {
        super(element);
    }

    @Override
    public void invoke(long ms) {
        if (this.element == null || this.element.model == null) {
            this.dispose();
            return;
        }
        if (ms <= 0L) {
            return;
        }
        this.mms = ms;
        this.moveX = 0.0;
        this.moveY = 0.0;
        int count = this.actions.size();
        for (int c = 0; c < count; ++c) {
            ((Action)this.actions.get(c)).invoke(ms);
        }
        if (this.moveX != 0.0 || this.moveY != 0.0) {
            try {
                this.element.model.moveBy(this.element, this.moveX, this.moveY);
            }
            catch (RectBoundsException e) {
                this.handleRectBoundsException(e);
            }
        }
    }

    protected void handleRectBoundsException(RectBoundsException e) {
        this.dispose();
    }

    public void addAction(Action a) {
        this.actions.add(a);
    }

    public void addAction(int i, Action a) {
        this.actions.add(i, a);
    }

    public void removeActable(Action a) {
        this.actions.remove(a);
    }

    public void removeActable(int i) {
        this.actions.remove(i);
    }

    public int getActionCount() {
        return this.actions.size();
    }

    public Action getAction(int i) {
        return (Action)this.actions.get(i);
    }

    public double getMoveX() {
        return this.moveX;
    }

    public double getMoveY() {
        return this.moveY;
    }

    public void setMoveX(double d) {
        this.moveX = d;
    }

    public void setMoveY(double d) {
        this.moveY = d;
    }

    public void setMoveXY(double mx, double my) {
        this.moveX = mx;
        this.moveY = my;
    }

    public void moveX(double d) {
        this.moveX += d;
    }

    public void moveY(double d) {
        this.moveY += d;
    }

    public void move(double x, double y) {
        this.moveX += x;
        this.moveY += y;
    }

    public String toString() {
        return "MovementActor[" + this.element + "]";
    }

    public void getSpeed(Speed2D dst) {
        if (this.mms > 0L) {
            dst.setSpeed(this.moveX / (double)this.mms, this.moveY / (double)this.mms);
        } else {
            dst.setSpeed(0.0, 0.0);
        }
    }

    public double getSpeedX() {
        return this.mms > 0L ? this.moveX / (double)this.mms : 0.0;
    }

    public double getSpeedY() {
        return this.mms > 0L ? this.moveY / (double)this.mms : 0.0;
    }
}

