/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;

public class MultiRectShape
implements Shape {
    private Rectangle bounds = new Rectangle();
    private LinkedList rects = new LinkedList();

    public void clear() {
        this.rects.clear();
    }

    public void add(int x, int y, int w, int h) {
        this.add(new Rectangle(x, y, w, h));
    }

    public void add(Rectangle r) {
        int c;
        LinkedList<Rectangle> list = new LinkedList<Rectangle>();
        list.add(r);
        int num = 1;
        int count = this.rects.size();
        block0: for (c = 0; c < count; ++c) {
            r = (Rectangle)this.rects.get(c);
            for (int j = 0; j < num; ++j) {
                Rectangle r2 = (Rectangle)list.get(j);
                if (r.contains(r2)) {
                    list.remove(j--);
                    --num;
                    continue;
                }
                if (r2.contains(r)) {
                    this.rects.remove(c--);
                    --count;
                    continue block0;
                }
                if (!r2.intersects(r)) continue;
                list.remove(j--);
                --num;
                int ky = Math.max(r.y, r2.y);
                int kh = Math.min(r.y + r.height, r2.y + r2.height) - ky;
                if (r2.y < r.y) {
                    list.add(++j, new Rectangle(r2.x, r2.y, r2.width, r.y - r2.y));
                    ++num;
                }
                if (r2.y + r2.height > r.y + r.height) {
                    list.add(++j, new Rectangle(r2.x, r.y + r.height, r2.width, r2.y + r2.height - r.y - r.height));
                    ++num;
                }
                if (r2.x < r.x) {
                    list.add(++j, new Rectangle(r2.x, ky, r.x - r2.x, kh));
                    ++num;
                }
                if (r2.x + r2.width <= r.x + r.width) continue;
                list.add(++j, new Rectangle(r.x + r.width, ky, r2.x + r2.width - r.x - r.width, kh));
                ++num;
            }
        }
        for (c = 0; c < num; ++c) {
            r = (Rectangle)list.get(c);
            this.rects.add(r);
            this.bounds = this.bounds.union(r);
        }
    }

    public void remove(int x, int y, int w, int h) {
        this.remove(new Rectangle(x, y, w, h));
    }

    public void remove(Rectangle r) {
        int count = this.rects.size();
        boolean updated = false;
        for (int c = 0; c < count; ++c) {
            Rectangle r2 = (Rectangle)this.rects.get(c);
            if (r.contains(r2)) {
                this.rects.remove(c--);
                --count;
                updated = true;
                continue;
            }
            if (!r.intersects(r2)) continue;
            updated = true;
            this.rects.remove(c--);
            --count;
            int ky = Math.max(r.y, r2.y);
            int kh = Math.min(r.y + r.height, r2.y + r2.height) - ky;
            if (r2.y < r.y) {
                this.rects.add(++c, new Rectangle(r2.x, r2.y, r2.width, r.y - r2.y));
                ++count;
            }
            if (r2.y + r2.height > r.y + r.height) {
                this.rects.add(++c, new Rectangle(r2.x, r.y + r.height, r2.width, r2.y + r2.height - r.y - r.height));
                ++count;
            }
            if (r2.x < r.x) {
                this.rects.add(++c, new Rectangle(r2.x, ky, r.x - r2.x, kh));
                ++count;
            }
            if (r2.x + r2.width <= r.x + r.width) continue;
            this.rects.add(++c, new Rectangle(r.x + r.width, ky, r2.x + r2.width - r.x - r.width, kh));
            ++count;
        }
        if (updated) {
            this.bounds = this.computeBounds(this.rects);
        }
    }

    public boolean isEmpty() {
        return this.rects.isEmpty();
    }

    public int getRectCount() {
        return this.rects.size();
    }

    public Rectangle getRectAt(int i) {
        return new Rectangle((Rectangle)this.rects.get(i));
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        if (!this.bounds.contains(x, y, w, h)) {
            return false;
        }
        MultiRectShape shape = new MultiRectShape();
        shape.add((int)x, (int)y, (int)w, (int)h);
        int count = this.rects.size();
        for (int c = 0; c < count; ++c) {
            shape.remove((Rectangle)this.rects.get(c));
        }
        return shape.isEmpty();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(x, y, 1.0, 1.0);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY(), 1.0, 1.0);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        if (!this.bounds.intersects(x, y, w, h)) {
            return false;
        }
        int count = this.rects.size();
        for (int c = 0; c < count; ++c) {
            if (!((Rectangle)this.rects.get(c)).intersects(x, y, w, h)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public int getSurface() {
        int rc = 0;
        int count = this.rects.size();
        for (int c = 0; c < count; ++c) {
            Rectangle r = (Rectangle)this.rects.get(c);
            rc += r.width * r.height;
        }
        return rc;
    }

    protected Rectangle computeBounds(LinkedList rects) {
        int count = rects.size();
        if (count < 1) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = (Rectangle)rects.get(0);
        int minX = r.x;
        int minY = r.y;
        int maxX = minX + r.width;
        int maxY = minY + r.height;
        for (int c = 1; c < count; ++c) {
            r = (Rectangle)rects.get(c);
            if (r.x < minX) {
                minX = r.x;
            }
            if (r.y < minY) {
                minY = r.y;
            }
            if (r.x + r.width > maxX) {
                maxX = r.x + r.width;
            }
            if (r.y + r.height <= maxY) continue;
            maxY = r.y + r.height;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }
}

