/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

public class PositionTreeMap {
    private int size = 0;
    private Entry root = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;

    public int size() {
        return this.size;
    }

    public boolean contains(Entry e) {
        while (e != null && e != this.root) {
            e = e.parent;
        }
        return e == this.root;
    }

    public Entry add(Object value, double pos) {
        Entry t = this.root;
        if (t == null) {
            ++this.size;
            this.root = new Entry(pos, value, null);
            return this.root;
        }
        while (true) {
            if (pos < t.key) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                ++this.size;
                Entry e = new Entry(pos, value, t);
                t.left = e;
                this.fixAfterInsertion(t.left);
                return e;
            }
            if (t.right == null) break;
            t = t.right;
        }
        ++this.size;
        Entry e = new Entry(pos, value, t);
        t.right = e;
        this.fixAfterInsertion(t.right);
        return e;
    }

    protected void insert(Entry parent, Entry e) {
        double pos = e.getKey();
        Entry t = parent;
        while (true) {
            if (pos < t.key) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                ++this.size;
                e.parent = t;
                t.left = e;
                this.fixAfterInsertion(t.left);
                return;
            }
            if (t.right == null) break;
            t = t.right;
        }
        ++this.size;
        e.parent = t;
        t.right = e;
        this.fixAfterInsertion(t.right);
    }

    public void move(double oldPos, Object value, double newPos) {
        Entry e = this.getEntry(oldPos, value);
        if (e == null) {
            System.err.println("Position not found: " + oldPos + " = " + value);
            this.checkConsistency();
            throw new RuntimeException("Position not found: " + oldPos + " = " + value);
        }
        this.move(e, newPos);
    }

    public void move(Entry e, double pos) {
        Entry n = e;
        Object value = e.value;
        if (e.key < pos) {
            while ((n = this.predecessor(n)) != null && n.key == e.key) {
                this.swapped(pos, value, n.key, n.value);
            }
            while ((n = this.successor(e)) != null && !(pos < n.key)) {
                this.swapped(pos, value, n.key, n.value);
                e.key = n.key;
                e.value = n.value;
                e = n;
            }
            e.key = pos;
            e.value = value;
        } else {
            while ((n = this.successor(n)) != null && n.key == e.key) {
                this.swapped(pos, value, n.key, n.value);
            }
            while ((n = this.predecessor(e)) != null && !(pos > n.key)) {
                this.swapped(pos, value, n.key, n.value);
                e.key = n.key;
                e.value = n.value;
                e = n;
            }
            e.key = pos;
            e.value = value;
        }
    }

    protected void swapped(double pos1, Object value1, double pos2, Object value2) {
    }

    public void remove(double key, Object value) {
        Entry e = this.getEntry(key, value);
        if (e != null) {
            this.remove(e);
        }
    }

    public void remove(Entry e) {
        if (this.contains(e)) {
            this.deleteEntry(e);
        }
    }

    public Entry getRoot() {
        return this.root;
    }

    public Entry getFirst() {
        Entry t = this.root;
        Entry e = null;
        while (t != null) {
            e = t;
            t = t.left;
        }
        return e;
    }

    public Entry getLast() {
        Entry t = this.root;
        Entry e = null;
        while (t != null) {
            e = t;
            t = t.right;
        }
        return e;
    }

    public Entry getFirst(double from) {
        Entry t = this.root;
        if (t == null) {
            return null;
        }
        while (true) {
            Entry n;
            if (t.key < from) {
                n = t.right;
                if (n == null) {
                    return this.successor(t);
                }
                t = n;
                continue;
            }
            n = t.left;
            if (n == null) {
                return t;
            }
            t = n;
        }
    }

    public Entry getLast(double to) {
        Entry t = this.root;
        if (t == null) {
            return null;
        }
        while (true) {
            Entry n;
            if (t.key <= to) {
                n = t.right;
                if (n == null) {
                    return t;
                }
                t = n;
                continue;
            }
            n = t.left;
            if (n == null) {
                return this.predecessor(t);
            }
            t = n;
        }
    }

    public Entry getEntry(double pos, Object value) {
        Entry t = this.root;
        if (t == null) {
            return null;
        }
        return this.getEntry(t, pos, value);
    }

    protected Entry getEntry(Entry t, double pos, Object value) {
        do {
            Entry x;
            if (t.key != pos) continue;
            if (t.value == value) {
                return t;
            }
            if (t.left != null && (x = this.getEntry(t.left, pos, value)) != null) {
                return x;
            }
            if (t.right != null && (x = this.getEntry(t.right, pos, value)) != null) {
                return x;
            }
            return null;
        } while (!(t.key < pos ? (t = t.right) == null : (t = t.left) == null));
        return null;
    }

    private void fixAfterInsertion(Entry x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            Entry y;
            if (PositionTreeMap.parentOf(x) == PositionTreeMap.leftOf(PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)))) {
                y = PositionTreeMap.rightOf(PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)));
                if (!PositionTreeMap.colorOf(y)) {
                    PositionTreeMap.setColor(PositionTreeMap.parentOf(x), true);
                    PositionTreeMap.setColor(y, true);
                    PositionTreeMap.setColor(PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)), false);
                    x = PositionTreeMap.parentOf(PositionTreeMap.parentOf(x));
                    continue;
                }
                if (x == PositionTreeMap.rightOf(PositionTreeMap.parentOf(x))) {
                    x = PositionTreeMap.parentOf(x);
                    this.rotateLeft(x);
                }
                PositionTreeMap.setColor(PositionTreeMap.parentOf(x), true);
                PositionTreeMap.setColor(PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)), false);
                if (PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)) == null) continue;
                this.rotateRight(PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)));
                continue;
            }
            y = PositionTreeMap.leftOf(PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)));
            if (!PositionTreeMap.colorOf(y)) {
                PositionTreeMap.setColor(PositionTreeMap.parentOf(x), true);
                PositionTreeMap.setColor(y, true);
                PositionTreeMap.setColor(PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)), false);
                x = PositionTreeMap.parentOf(PositionTreeMap.parentOf(x));
                continue;
            }
            if (x == PositionTreeMap.leftOf(PositionTreeMap.parentOf(x))) {
                x = PositionTreeMap.parentOf(x);
                this.rotateRight(x);
            }
            PositionTreeMap.setColor(PositionTreeMap.parentOf(x), true);
            PositionTreeMap.setColor(PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)), false);
            if (PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)) == null) continue;
            this.rotateLeft(PositionTreeMap.parentOf(PositionTreeMap.parentOf(x)));
        }
        this.root.color = true;
    }

    private void fixAfterDeletion(Entry x) {
        while (x != this.root && PositionTreeMap.colorOf(x)) {
            Entry sib;
            if (x == PositionTreeMap.leftOf(PositionTreeMap.parentOf(x))) {
                sib = PositionTreeMap.rightOf(PositionTreeMap.parentOf(x));
                if (!PositionTreeMap.colorOf(sib)) {
                    PositionTreeMap.setColor(sib, true);
                    PositionTreeMap.setColor(PositionTreeMap.parentOf(x), false);
                    this.rotateLeft(PositionTreeMap.parentOf(x));
                    sib = PositionTreeMap.rightOf(PositionTreeMap.parentOf(x));
                }
                if (PositionTreeMap.colorOf(PositionTreeMap.leftOf(sib)) && PositionTreeMap.colorOf(PositionTreeMap.rightOf(sib))) {
                    PositionTreeMap.setColor(sib, false);
                    x = PositionTreeMap.parentOf(x);
                    continue;
                }
                if (PositionTreeMap.colorOf(PositionTreeMap.rightOf(sib))) {
                    PositionTreeMap.setColor(PositionTreeMap.leftOf(sib), true);
                    PositionTreeMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = PositionTreeMap.rightOf(PositionTreeMap.parentOf(x));
                }
                PositionTreeMap.setColor(sib, PositionTreeMap.colorOf(PositionTreeMap.parentOf(x)));
                PositionTreeMap.setColor(PositionTreeMap.parentOf(x), true);
                PositionTreeMap.setColor(PositionTreeMap.rightOf(sib), true);
                this.rotateLeft(PositionTreeMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = PositionTreeMap.leftOf(PositionTreeMap.parentOf(x));
            if (!PositionTreeMap.colorOf(sib)) {
                PositionTreeMap.setColor(sib, true);
                PositionTreeMap.setColor(PositionTreeMap.parentOf(x), false);
                this.rotateRight(PositionTreeMap.parentOf(x));
                sib = PositionTreeMap.leftOf(PositionTreeMap.parentOf(x));
            }
            if (PositionTreeMap.colorOf(PositionTreeMap.rightOf(sib)) && PositionTreeMap.colorOf(PositionTreeMap.leftOf(sib))) {
                PositionTreeMap.setColor(sib, false);
                x = PositionTreeMap.parentOf(x);
                continue;
            }
            if (PositionTreeMap.colorOf(PositionTreeMap.leftOf(sib))) {
                PositionTreeMap.setColor(PositionTreeMap.rightOf(sib), true);
                PositionTreeMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = PositionTreeMap.leftOf(PositionTreeMap.parentOf(x));
            }
            PositionTreeMap.setColor(sib, PositionTreeMap.colorOf(PositionTreeMap.parentOf(x)));
            PositionTreeMap.setColor(PositionTreeMap.parentOf(x), true);
            PositionTreeMap.setColor(PositionTreeMap.leftOf(sib), true);
            this.rotateRight(PositionTreeMap.parentOf(x));
            x = this.root;
        }
        PositionTreeMap.setColor(x, true);
    }

    private static boolean colorOf(Entry p) {
        return p == null ? true : p.color;
    }

    private static Entry parentOf(Entry p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(Entry p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static Entry leftOf(Entry p) {
        return p == null ? null : p.left;
    }

    private static Entry rightOf(Entry p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(Entry p) {
        Entry r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    private void rotateRight(Entry p) {
        Entry l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    private void deleteEntry(Entry p) {
        Entry replacement;
        --this.size;
        if (p.left != null && p.right != null) {
            Entry s = this.successor(p);
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.left = (p.right = (p.parent = null));
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private Entry successor(Entry t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private Entry predecessor(Entry t) {
        if (t == null) {
            return null;
        }
        if (t.left != null) {
            Entry p = t.left;
            while (p.right != null) {
                p = p.right;
            }
            return p;
        }
        Entry p = t.parent;
        Entry ch = t;
        while (p != null && ch == p.left) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    public void getEntries(Collection dst) {
        Entry e = this.root;
        if (e != null) {
            this.getEntries(e, dst);
        }
    }

    protected void getEntries(Entry e, Collection dst) {
        if (e.left != null) {
            this.getEntries(e.left, dst);
        }
        dst.add(e);
        if (e.right != null) {
            this.getEntries(e.right, dst);
        }
    }

    public void clear() {
        this.size = 0;
        this.root = null;
    }

    public Iterator iterator() {
        return new Iter();
    }

    public Iter iter() {
        return new Iter();
    }

    public Iterator iterator(Entry first, Entry last) {
        return new Iter(first, last);
    }

    public Iterator iterator(double from, double to) {
        Entry first = this.getFirst(from);
        Entry last = this.getLast(to);
        if (first == null || last == null) {
            first = null;
            last = null;
        } else if (first.getKey() > last.getKey()) {
            first = null;
            last = null;
        }
        return new Iter(first, last);
    }

    protected void dump(PrintStream out) {
        System.out.println("----------- " + this + " ----------");
        if (this.root != null) {
            this.dumpEntry(this.root, 0, out);
        }
        System.out.println("===============================");
    }

    protected void dumpEntry(Entry e, int parentCount, PrintStream out) {
        if (e.left != null) {
            this.dumpEntry(e.left, parentCount + 1, out);
        }
        for (int c = 0; c < parentCount; ++c) {
            out.print(" ");
        }
        out.println("" + e);
        if (e.right != null) {
            this.dumpEntry(e.right, parentCount + 1, out);
        }
    }

    public void checkConsistency() {
        double lastKey = -1.0E9;
        int count = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            double key = e.getKey();
            if (key < lastKey) {
                throw new RuntimeException("PositionTreeMap is inconsistent: " + e + " < " + lastKey);
            }
            lastKey = key;
            ++count;
        }
        if (count != this.size) {
            throw new RuntimeException("Invalid map size: " + count + " != " + this.size);
        }
    }

    public class Iter
    implements Iterator {
        private Entry e = null;
        private Entry next;
        private Entry last;

        public Iter() {
            this(positionTreeMap.getFirst(), positionTreeMap.getLast());
        }

        public Iter(Entry first, Entry last) {
            this.next = first;
            this.last = last;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            this.e = this.next;
            this.next = this.e == this.last ? null : PositionTreeMap.this.successor(this.e);
            return this.e;
        }

        @Override
        public void remove() {
        }

        public void reset() {
            this.e = null;
            this.next = PositionTreeMap.this.getFirst();
            this.last = PositionTreeMap.this.getLast();
        }
    }

    public class Entry {
        private Entry parent;
        private Entry left;
        private Entry right;
        private double key;
        private Object value;
        private boolean color = true;

        public Entry(double key, Object value, Entry parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        public String toString() {
            return "" + this.key + " = " + this.value;
        }

        public double getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

