/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.PositionTreeMap;
import java.util.ArrayList;
import java.util.Iterator;

public class PositionTreeMapTest {
    public static void main(String[] args) {
        try {
            PositionTreeMapTest.testRandom001();
            System.out.println("Test completed.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static void testFunctions001() throws Exception {
        System.out.println("Test PositionTreeMap..");
        long ms = -System.currentTimeMillis();
        PositionTreeMap map = new PositionTreeMap();
        int num = 50000;
        for (int c = 0; c < num; ++c) {
            map.add("#" + c, (int)(Math.random() * 100000.0));
        }
        System.out.println("Inserted " + map.size() + " entries in " + (ms += System.currentTimeMillis()) + " ms.");
        System.out.println("Root: " + map.getRoot());
        ArrayList entries = new ArrayList();
        map.getEntries(entries);
        int count = entries.size();
        System.out.println("Checking order of entries: " + count);
        double lastKey = -1.0E9;
        for (int c = 0; c < count; ++c) {
            PositionTreeMap.Entry x = (PositionTreeMap.Entry)entries.get(c);
            if (x.getKey() < lastKey) {
                throw new RuntimeException("OOPS!! Entry #" + c + " is inconsistent: " + x.getKey() + " < " + lastKey);
            }
            lastKey = x.getKey();
        }
        int chkNum = 10000;
        double[] checkKeys = new double[chkNum];
        for (int c = 0; c < chkNum; ++c) {
            checkKeys[c] = Math.random() * 100000.0;
        }
        PositionTreeMap.Entry[] checkFirstEntries = new PositionTreeMap.Entry[chkNum];
        ms = -System.currentTimeMillis();
        for (int c = 0; c < chkNum; ++c) {
            checkFirstEntries[c] = map.getFirst(checkKeys[c]);
        }
        System.out.println("test-getFirst() " + chkNum + " times in " + (ms += System.currentTimeMillis()) + " ms.");
        PositionTreeMap.Entry[] checkLastEntries = new PositionTreeMap.Entry[chkNum];
        ms = -System.currentTimeMillis();
        for (int c = 0; c < chkNum; ++c) {
            checkLastEntries[c] = map.getLast(checkKeys[c]);
        }
        System.out.println("test-getLast() " + chkNum + " times in " + (ms += System.currentTimeMillis()) + " ms.");
        int counter = 0;
        ms = -System.currentTimeMillis();
        Iterator i = map.iterator();
        while (i.hasNext()) {
            PositionTreeMap.Entry e = (PositionTreeMap.Entry)i.next();
            ++counter;
        }
        System.out.println("Iterator test " + counter + " entries in " + (ms += System.currentTimeMillis()) + " ms.");
        i = map.iterator(11111.0, 11222.0);
        while (i.hasNext()) {
            System.out.println(" - " + i.next());
            ++counter;
        }
        System.out.println("test move()-method..");
        PositionTreeMap.Entry e = (PositionTreeMap.Entry)entries.get(1000);
        double ePos = e.getKey();
        Object eValue = e.getValue();
        System.out.println("moving: " + e);
        ms = -System.currentTimeMillis();
        for (int c = 0; c < 10000; ++c) {
            double newPos = ePos + 1.0;
            PositionTreeMap.Entry x = map.getEntry(ePos, eValue);
            if (x == null) {
                throw new RuntimeException("Entry not found: " + ePos + ", " + eValue);
            }
            map.move(x, newPos);
            ePos = newPos;
        }
        System.out.println("Move test: " + (ms += System.currentTimeMillis()) + " ms.");
        map.checkConsistency();
    }

    private static void testRandom001() throws Exception {
        System.out.println("- testRandom001..");
        PositionTreeMap map = new PositionTreeMap();
        int num = 5000;
        Object[] objects = new Object[num];
        double[] values = new double[num];
        for (int c = 0; c < num; ++c) {
            objects[c] = new String("#");
            values[c] = (int)(Math.random() * 10.0);
            map.add(objects[c], values[c]);
        }
        map.checkConsistency();
        int moves = 10000;
        for (int c = 0; c < moves; ++c) {
            int x = (int)(Math.random() * (double)num);
            double ov = values[x];
            double nv = ov + (double)((int)(Math.random() * 2.0));
            map.move(ov, objects[x], nv);
            values[x] = nv;
            map.checkConsistency();
        }
        map.checkConsistency();
        System.out.println("Map size = " + map.size());
    }
}

