/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class Rect
implements Cloneable {
    double x;
    double y;
    double w;
    double h;
    Collection coll = this.createCollisionCollection();

    public Rect() {
    }

    protected Collection createCollisionCollection() {
        return new LinkedList();
    }

    public Rect(double x, double y, double w, double h) {
        this();
        this.setRect(x, y, w, h);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.w;
    }

    public final double getHeight() {
        return this.h;
    }

    public final boolean contains(Rect r) {
        return this.contains(r.x, r.y, r.w, r.h);
    }

    public final boolean contains(double rx, double ry, double rw, double rh) {
        return this.x <= rx && this.y <= ry && this.x + this.w >= rx + rw && this.y + this.h >= ry + rh;
    }

    public final boolean contains(double px, double py) {
        return px >= this.x && py >= this.y && px < this.x + this.w && py < this.y + this.h;
    }

    public final boolean intersects(Rect r) {
        return this.intersects(r.x, r.y, r.w, r.h);
    }

    public final boolean intersects(double rx, double ry, double rw, double rh) {
        return this.x < rx + rw && this.y < ry + rh && this.x + this.w > rx && this.y + this.h > ry;
    }

    final boolean addCollision(Rect r) {
        if (!this.coll.contains(r)) {
            this.coll.add(r);
            return true;
        }
        return false;
    }

    public final boolean hasCollision(Rect r) {
        return this.coll.contains(r);
    }

    final boolean removeCollision(Rect r) {
        return this.coll.remove(r);
    }

    void clearCollisions() {
        Iterator i = this.coll.iterator();
        while (i.hasNext()) {
            Rect r = (Rect)i.next();
            i.remove();
            r.removeCollision(this);
            this.collisionRemoved(r);
            r.collisionRemoved(this);
        }
    }

    void removeInvalidCollisions() {
        Iterator i = this.coll.iterator();
        while (i.hasNext()) {
            Rect r = (Rect)i.next();
            if (this.intersects(r)) continue;
            i.remove();
            r.removeCollision(this);
            this.collisionRemoved(r);
            r.collisionRemoved(this);
        }
    }

    public final int getCollisionCount() {
        return this.coll.size();
    }

    public final Iterator getCollisions() {
        return this.coll.iterator();
    }

    void setRect(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public String toString() {
        return "Rect(" + this.x + "," + this.y + "," + this.w + "," + this.h + ")";
    }

    protected abstract void collisionAdded(Rect var1);

    protected abstract void collisionRemoved(Rect var1);

    protected Rect cloneRect() throws Exception {
        Rect clone = (Rect)this.clone();
        clone.coll = this.createCollisionCollection();
        return clone;
    }
}

