/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class RectUtil {
    private RectUtil() {
    }

    public static boolean intersects(Rectangle a, Rectangle b) {
        int ax = a.x;
        int ay = a.y;
        int bx = b.x;
        int by = b.y;
        return ax < bx + b.width && ay < by + b.height && bx < ax + a.width && by < ay + a.height;
    }

    public static boolean intersects(Rectangle2D.Double a, Rectangle2D.Double b) {
        double ax = a.x;
        double ay = a.y;
        double bx = b.x;
        double by = b.y;
        return ax < bx + b.width && ay < by + b.height && bx < ax + a.width && by < ay + a.height;
    }

    public static boolean intersects(Rectangle2D.Float a, Rectangle2D.Float b) {
        float ax = a.x;
        float ay = a.y;
        float bx = b.x;
        float by = b.y;
        return ax < bx + b.width && ay < by + b.height && bx < ax + a.width && by < ay + a.height;
    }

    public static boolean intersects(Rectangle a, int bx, int by, int bw, int bh) {
        int ax = a.x;
        int ay = a.y;
        return ax < bx + bw && ay < by + bh && bx < ax + a.width && by < ay + a.height;
    }

    public static boolean intersects(Rectangle a, double bx, double by, double bw, double bh) {
        int ax = a.x;
        int ay = a.y;
        return (double)ax < bx + bw && (double)ay < by + bh && bx < (double)(ax + a.width) && by < (double)(ay + a.height);
    }

    public static boolean intersects(Rectangle a, float bx, float by, float bw, float bh) {
        int ax = a.x;
        int ay = a.y;
        return (float)ax < bx + bw && (float)ay < by + bh && bx < (float)(ax + a.width) && by < (float)(ay + a.height);
    }

    public static boolean intersects(Rectangle2D.Double a, double bx, double by, double bw, double bh) {
        double ax = a.x;
        double ay = a.y;
        return ax < bx + bw && ay < by + bh && bx < ax + a.width && by < ay + a.height;
    }

    public static boolean intersects(Rectangle2D.Float a, float bx, float by, float bw, float bh) {
        float ax = a.x;
        float ay = a.y;
        return ax < bx + bw && ay < by + bh && bx < ax + a.width && by < ay + a.height;
    }

    public static boolean intersects(int ax, int ay, int aw, int ah, int bx, int by, int bw, int bh) {
        return ax < bx + bw && ay < by + bh && bx < ax + aw && by < ay + ah;
    }

    public static boolean intersects(double ax, double ay, double aw, double ah, double bx, double by, double bw, double bh) {
        return ax < bx + bw && ay < by + bh && bx < ax + aw && by < ay + ah;
    }

    public static boolean intersects(float ax, float ay, float aw, float ah, float bx, float by, float bw, float bh) {
        return ax < bx + bw && ay < by + bh && bx < ax + aw && by < ay + ah;
    }

    public static void intersect(Rectangle a, Rectangle b, Rectangle dest) {
        int ax = a.x;
        int ay = a.y;
        int bx = b.x;
        int by = b.y;
        int ax2 = ax + a.width;
        int ay2 = ay + a.height;
        int bx2 = bx + b.width;
        int by2 = by + b.height;
        dest.x = ax > bx ? ax : bx;
        dest.y = ay > by ? ay : by;
        dest.width = ax2 < bx2 ? ax2 - dest.x : bx2 - dest.x;
        dest.height = ay2 < by2 ? ay2 - dest.y : by2 - dest.y;
    }

    public static void intersect(Rectangle2D.Double a, Rectangle2D.Double b, Rectangle2D.Double dest) {
        double ax = a.x;
        double ay = a.y;
        double bx = b.x;
        double by = b.y;
        double ax2 = ax + a.width;
        double ay2 = ay + a.height;
        double bx2 = bx + b.width;
        double by2 = by + b.height;
        dest.x = ax > bx ? ax : bx;
        dest.y = ay > by ? ay : by;
        dest.width = ax2 < bx2 ? ax2 - dest.x : bx2 - dest.x;
        dest.height = ay2 < by2 ? ay2 - dest.y : by2 - dest.y;
    }

    public static void intersect(Rectangle2D.Float a, Rectangle2D.Float b, Rectangle2D.Float dest) {
        float ax = a.x;
        float ay = a.y;
        float bx = b.x;
        float by = b.y;
        float ax2 = ax + a.width;
        float ay2 = ay + a.height;
        float bx2 = bx + b.width;
        float by2 = by + b.height;
        dest.x = ax > bx ? ax : bx;
        dest.y = ay > by ? ay : by;
        dest.width = ax2 < bx2 ? ax2 - dest.x : bx2 - dest.x;
        dest.height = ay2 < by2 ? ay2 - dest.y : by2 - dest.y;
    }
}

