/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.TileModel;
import com.spacekiller.game2d.TileView;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;

public class TileLoop
extends TileModel {
    public TileLoop(double tileWidth, double tileHeight, int columns, int rows) {
        super(tileWidth, tileHeight, columns, rows);
    }

    @Override
    public Renderer getTile(int col, int row) {
        return super.getTile(col % this.cols, row % this.rows);
    }

    @Override
    public void setTile(int col, int row, Renderer tile) {
        super.setTile(col % this.cols, row % this.rows, tile);
    }

    @Override
    protected void paint(TileView view, Graphics g) {
        Rectangle2D viewRect = view.getViewRect();
        double minX = viewRect.getMinX();
        double maxX = viewRect.getMaxX();
        double minY = viewRect.getMinY();
        double maxY = viewRect.getMaxY();
        int firstCol = (int)Math.floor(minX / this.tileWidth);
        int lastCol = (int)Math.floor(maxX / this.tileWidth);
        int firstRow = (int)Math.floor(minY / this.tileHeight);
        int lastRow = (int)Math.floor(maxY / this.tileHeight);
        double x1 = (double)firstCol * this.tileWidth;
        double y = (double)firstRow * this.tileHeight;
        int trax = (int)viewRect.getMinX();
        int tray = (int)viewRect.getMinY();
        int r = firstRow;
        while (r <= lastRow) {
            double x = x1;
            int c = firstCol;
            while (c <= lastCol) {
                Renderer rr = this.getTile(c, r);
                if (rr != null) {
                    int ix = (int)x;
                    int iy = (int)y;
                    g.translate(ix - trax, iy - tray);
                    trax = ix;
                    tray = iy;
                    rr.paint(null, view, g);
                }
                ++c;
                x += this.tileWidth;
            }
            ++r;
            y += this.tileHeight;
        }
        g.translate(-trax + (int)viewRect.getMinX(), -tray + (int)viewRect.getMinY());
    }
}

