/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Model;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.TileView;
import com.spacekiller.game2d.View;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class TileModel
implements Model {
    protected double tileWidth;
    protected double tileHeight;
    protected int cols;
    protected int rows;
    protected Renderer[] tiles;
    protected ArrayList views;

    public TileModel(double tileWidth, double tileHeight, int columns, int rows) {
        this.setTileWidth(tileWidth);
        this.setTileHeight(tileHeight);
        this.setColumns(columns);
        this.setRows(rows);
        this.tiles = new Renderer[columns * rows];
        this.views = new ArrayList();
    }

    public int getColumns() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public double getTileHeight() {
        return this.tileHeight;
    }

    public double getTileWidth() {
        return this.tileWidth;
    }

    private void setColumns(int i) {
        this.cols = i;
    }

    private void setRows(int i) {
        this.rows = i;
    }

    private void setTileHeight(double d) {
        this.tileHeight = d;
    }

    private void setTileWidth(double d) {
        this.tileWidth = d;
    }

    public Renderer getTile(int col, int row) {
        return this.tiles[row * this.cols + col];
    }

    public void setTile(int col, int row, Renderer tile) {
        this.tiles[row * this.cols + col] = tile;
    }

    @Override
    public View createView(double x, double y, double w, double h) {
        TileView view = new TileView(this);
        this.views.add(view);
        view.getViewRect().setRect(x, y, w, h);
        return view;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getBounds(new Rectangle2D.Double());
    }

    @Override
    public Rectangle2D getBounds(Rectangle2D dst) {
        dst.setRect(0.0, 0.0, (double)this.cols * this.tileWidth, (double)this.rows * this.tileHeight);
        return dst;
    }

    @Override
    public View getViewAt(int i) {
        return (View)this.views.get(i);
    }

    @Override
    public int getViewCount() {
        return this.views.size();
    }

    @Override
    public Iterator getViews() {
        return this.views.iterator();
    }

    @Override
    public void removeView(View v) {
        TileView tv = (TileView)v;
        if (this.views.contains(tv)) {
            this.views.remove(tv);
        }
    }

    @Override
    public void updateView(View v, double x, double y, double w, double h) {
        TileView tv = (TileView)v;
        tv.getViewRect().setRect(x, y, w, h);
    }

    protected void paint(TileView view, Graphics g) {
        Rectangle2D viewRect = view.getViewRect();
        int firstCol = (int)(viewRect.getMinX() / this.tileWidth);
        int lastCol = (int)(viewRect.getMaxX() / this.tileWidth);
        int firstRow = (int)(viewRect.getMinY() / this.tileHeight);
        int lastRow = (int)(viewRect.getMaxY() / this.tileHeight);
        firstCol = Math.max(0, Math.min(firstCol, this.cols - 1));
        lastCol = Math.max(0, Math.min(lastCol, this.cols - 1));
        firstRow = Math.max(0, Math.min(firstRow, this.rows - 1));
        lastRow = Math.max(0, Math.min(lastRow, this.rows - 1));
        double x1 = (double)firstCol * this.tileWidth;
        double y = (double)firstRow * this.tileHeight;
        int trax = (int)viewRect.getMinX();
        int tray = (int)viewRect.getMinY();
        int r = firstRow;
        while (r <= lastRow) {
            double x = x1;
            int t = r * this.cols + firstCol;
            int c = firstCol;
            while (c <= lastCol) {
                Renderer rr;
                if ((rr = this.tiles[t++]) != null) {
                    int ix = (int)x;
                    int iy = (int)y;
                    g.translate(ix - trax, iy - tray);
                    trax = ix;
                    tray = iy;
                    rr.paint(null, view, g);
                }
                ++c;
                x += this.tileWidth;
            }
            ++r;
            y += this.tileHeight;
        }
        g.translate(-trax + (int)viewRect.getMinX(), -tray + (int)viewRect.getMinY());
    }
}

