/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d;

import com.spacekiller.game2d.Action;
import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.Scene;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class Timer
extends Actor {
    private Scene scene;
    private boolean active = false;
    private long ems = 0L;
    private long nms = -1L;
    private SortedSet set = new TreeSet(new ActionComparator());
    private volatile boolean invoking = false;

    public Timer(Scene scene) {
        this.setScene(scene);
    }

    @Override
    public void invoke(long ms) {
        this.ems += ms;
        if (this.ems < this.nms) {
            return;
        }
        if (this.nms < 0L) {
            this.active = false;
            this.dispose();
            return;
        }
        this.nms = -1L;
        this.invoking = true;
        Iterator i = this.set.iterator();
        while (i.hasNext()) {
            long ams;
            TimeAction a = (TimeAction)i.next();
            this.nms = ams = a.ms;
            if (ams > this.ems) break;
            i.remove();
            long xms = this.nms;
            a.invoke(this.ems - ams);
            if (this.nms == xms) continue;
            i = this.set.iterator();
            xms = this.nms;
        }
        this.invoking = false;
    }

    public void put(long delay, TimeAction action) {
        if (action == null) {
            return;
        }
        if (this.invoking) {
            System.out.println("TODO: put timer action while invoking timer: " + this);
            throw new RuntimeException("TODO: Timer.put while invoking!");
        }
        long ms = this.ems + delay;
        action.ms = ms;
        if (this.nms < 0L || ms < this.nms) {
            this.nms = ms;
        }
        this.set.add(action);
        if (!this.active) {
            this.scene.addActor(this);
            this.active = true;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    public Scene getScene() {
        return this.scene;
    }

    protected void setScene(Scene scene) {
        this.scene = scene;
    }

    public void addActor(long delay, Actor actor) {
        if (actor == null) {
            return;
        }
        if (delay < 0L) {
            delay = 0L;
        }
        this.put(delay, new AddActorAction(actor));
    }

    public void removeActor(long delay, Actor actor) {
        if (actor == null) {
            return;
        }
        if (delay < 0L) {
            delay = 0L;
        }
        this.put(delay, new RemoveActorAction(actor));
    }

    protected class ActionComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            long bms;
            long ams = ((TimeAction)a).ms;
            if (ams == (bms = ((TimeAction)b).ms)) {
                return -1;
            }
            return ams < bms ? -1 : 1;
        }
    }

    protected class RemoveActorAction
    extends TimeAction {
        public Actor actor;

        public RemoveActorAction(Actor actor) {
            this.actor = actor;
        }

        @Override
        public void invoke(long ms) {
            Timer.this.scene.removeActor(this.actor);
        }

        public String toString() {
            return super.toString() + "[actor=" + this.actor + "]";
        }
    }

    protected class AddActorAction
    extends TimeAction {
        public Actor actor;

        public AddActorAction(Actor actor) {
            this.actor = actor;
        }

        @Override
        public void invoke(long ms) {
            Timer.this.scene.addActor(this.actor);
        }

        public String toString() {
            return super.toString() + "[actor=" + this.actor + "]";
        }
    }

    public static abstract class TimeAction
    implements Action {
        private long ms;

        public final long ms() {
            return this.ms;
        }
    }
}

