/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.behavior;

import com.spacekiller.game2d.Behavior;
import com.spacekiller.game2d.MoveActor;

public class PositionRotateBehavior
extends Behavior {
    private MoveActor actor;
    private double speedX = 0.005;
    private double speedY = 0.005;
    private double radiusX = 50.0;
    private double radiusY = 50.0;
    private double angleX = 0.0;
    private double angleY = 0.0;
    private long msTotal = 0L;
    private double lastSin = 0.0;
    private double lastCos = 0.0;

    public PositionRotateBehavior(MoveActor actor) {
        this.actor = actor;
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public double getSpeedX() {
        return this.speedX;
    }

    public void setRadiusX(double d) {
        this.radiusX = d;
    }

    public void setSpeedX(double d) {
        this.speedX = d;
    }

    public void initRotation() {
        this.lastSin = Math.sin(this.angleX + (double)this.msTotal * this.speedX);
        this.lastCos = Math.cos(this.angleY + (double)this.msTotal * this.speedY);
    }

    @Override
    public void invoke(long ms) {
        this.msTotal += ms;
        double sin = Math.sin(this.angleX + (double)this.msTotal * this.speedX);
        double cos = Math.cos(this.angleY + (double)this.msTotal * this.speedY);
        this.actor.move((sin - this.lastSin) * this.radiusX, (cos - this.lastCos) * this.radiusY);
        this.lastSin = sin;
        this.lastCos = cos;
    }

    public double getRadiusY() {
        return this.radiusY;
    }

    public double getSpeedY() {
        return this.speedY;
    }

    public void setRadiusY(double d) {
        this.radiusY = d;
    }

    public void setSpeedY(double d) {
        this.speedY = d;
    }

    public double getAngleX() {
        return this.angleX;
    }

    public double getAngleY() {
        return this.angleY;
    }

    public void setAngleX(double d) {
        this.angleX = d;
    }

    public void setAngleY(double d) {
        this.angleY = d;
    }
}

